/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.Graphics;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.draw2d.Rectangle;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.ArchitectureDiagramLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Color;

final class GridFigure
extends Figure {
    private final ArchitectureDiagramLayout m_layout;

    GridFigure(ArchitectureDiagramLayout layout) {
        assert (layout != null) : "Parameter 'layout' of method 'GridFigure' must not be null";
        this.m_layout = layout;
        this.update();
    }

    void update() {
        this.revalidate();
    }

    protected void layout() {
        UmlComponentFigureGridLayout gridLayout = this.m_layout.getUmlComponentFigureGridLayout();
        if (gridLayout != null) {
            this.bounds = new Rectangle(0, 0, gridLayout.getSize().width, gridLayout.getSize().height);
            this.prefSize = new Dimension(gridLayout.getSize());
        }
        super.layout();
    }

    protected final void paintFigure(Graphics graphics) {
        assert (graphics != null) : "Parameter 'graphics' of method 'paintFigure' must not be null";
        UmlComponentFigureGridLayout gridLayout = this.m_layout.getUmlComponentFigureGridLayout();
        if (gridLayout != null) {
            Point to;
            Point from;
            Color initialFgColor = graphics.getForegroundColor();
            graphics.setForegroundColor(UiResourceManager.getInstance().getColor(UiResourceManager.VERY_LIGHT_GREY));
            int v = 0;
            while (v < gridLayout.getNumberOfVerticalGridLines()) {
                int nextPosX = gridLayout.getVerticalGridLinePosX(v);
                from = new Point(nextPosX, 0);
                to = new Point(nextPosX, gridLayout.getSize().height);
                graphics.drawLine(from, to);
                ++v;
            }
            int h = 0;
            while (h < gridLayout.getNumberOfHorizontalGridLines()) {
                int nextPosY = gridLayout.getHorizontalGridLinePosY(h);
                from = new Point(0, nextPosY);
                to = new Point(gridLayout.getSize().width, nextPosY);
                graphics.drawLine(from, to);
                ++h;
            }
            graphics.setForegroundColor(initialFgColor);
        }
    }
}

