/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureRegistry;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawCache;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvasLayout;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitectureDiagramLayout
extends DrawNodeAndConnectionFigureCanvasLayout<UmlComponent, UmlComponent.UmlComponentDependency>
implements IUmlComponentFigureRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureDiagramLayout.class);
    private final Map<UmlComponent, UmlComponentFigure> m_umlComponentToFigure = new THashMap();
    private UmlComponentFigureGridLayout m_gridLayout;

    ArchitectureDiagramLayout() {
        super(0.4, (double)0.1f);
    }

    protected void calculateSizeAndScale(List<DrawNodeFigure<UmlComponent>> nodeFigures, List<DrawConnectionFigure<UmlComponent.UmlComponentDependency>> connectionFigures, DrawNodeAndConnectionFigureCanvasLayout.SizeAndScale sizeAndScale, DrawCache cache) {
        assert (nodeFigures != null && !nodeFigures.isEmpty()) : "Parameter 'nodeFigures' of method 'calculateSizeAndScale' must not be empty";
        assert (connectionFigures != null) : "Parameter 'connectionFigures' of method 'calculateSizeAndScale' must not be null";
        assert (sizeAndScale != null) : "Parameter 'sizeAndScale' of method 'calculateSizeAndScale' must not be null";
        LOGGER.debug("Calculate grid layout");
        ArrayList<UmlComponentFigure> umlComponentFigures = new ArrayList<UmlComponentFigure>(nodeFigures.size());
        for (DrawNodeFigure<UmlComponent> nextNodeFigure : nodeFigures) {
            assert (nextNodeFigure instanceof UmlComponentFigure) : "Unexpected class in method 'calculateSize': " + String.valueOf(nextNodeFigure);
            umlComponentFigures.add((UmlComponentFigure)nextNodeFigure);
        }
        this.m_gridLayout = new UmlComponentFigureGridLayout(null, umlComponentFigures);
        LOGGER.debug("Calculate grid layout - done [" + String.valueOf(this.m_gridLayout) + "]");
        sizeAndScale.setSize(this.m_gridLayout.getSize());
    }

    protected void layout(List<DrawNodeFigure<UmlComponent>> nodeFigures, List<DrawConnectionFigure<UmlComponent.UmlComponentDependency>> connectionFigures, DrawCache cache) {
        assert (nodeFigures != null && !nodeFigures.isEmpty()) : "Parameter 'nodeFigures' of method 'layout' must not be empty";
        assert (connectionFigures != null) : "Parameter 'connectionFigures' of method 'layout' must not be null";
        assert (this.m_gridLayout != null) : "Parameter 'm_gridLayout' of method 'layout' must not be null";
        LOGGER.debug("Layout " + nodeFigures.size() + " node figure(s) [" + String.valueOf(this.m_gridLayout) + "]");
        ArrayList<UmlComponentFigure> umlComponentFigures = new ArrayList<UmlComponentFigure>(nodeFigures.size());
        for (DrawNodeFigure<UmlComponent> nextNodeFigure : nodeFigures) {
            assert (nextNodeFigure instanceof UmlComponentFigure) : "Unexpected class in method 'calculateSize': " + String.valueOf(nextNodeFigure);
            umlComponentFigures.add((UmlComponentFigure)nextNodeFigure);
        }
        this.m_gridLayout.layout(umlComponentFigures);
        LOGGER.debug("Layout " + nodeFigures.size() + " node figure(s) [" + String.valueOf(this.m_gridLayout) + "] - done");
    }

    void addUmlComponentFigure(UmlComponentFigure umlComponentFigure) {
        assert (umlComponentFigure != null) : "Parameter 'umlComponentFigure' of method 'addUmlComponentFigure' must not be null";
        LOGGER.trace("Add component figure for: " + ((UmlComponent)umlComponentFigure.getNode()).getName());
        UmlComponentFigure previous = this.m_umlComponentToFigure.put((UmlComponent)umlComponentFigure.getNode(), umlComponentFigure);
        assert (previous == null) : "Already added: " + String.valueOf(umlComponentFigure.getNode());
    }

    void removeUmlComponentFigure(UmlComponentFigure umlComponentFigure) {
        assert (umlComponentFigure != null) : "Parameter 'umlComponentFigure' of method 'removeUmlComponentFigure' must not be null";
        LOGGER.trace("Remove component figure for: " + ((UmlComponent)umlComponentFigure.getNode()).getName());
        UmlComponentFigure previous = this.m_umlComponentToFigure.remove(umlComponentFigure.getNode());
        assert (previous != null) : "'previous' of method 'removeUmlComponentFigure' must not be null";
    }

    void reset() {
        LOGGER.trace("Reset");
        this.m_umlComponentToFigure.clear();
        this.m_gridLayout = null;
    }

    @Override
    public UmlComponentFigure getUmlComponentFigure(UmlComponent umlComponent) {
        assert (umlComponent != null) : "Parameter 'umlComponent' of method 'getUmlComponentFigure' must not be null";
        return this.m_umlComponentToFigure.get(umlComponent);
    }

    UmlComponentFigureGridLayout getUmlComponentFigureGridLayout() {
        return this.m_gridLayout;
    }
}

