/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturediagram;

import com.hello2morrow.draw2d.ConnectionRouter;
import com.hello2morrow.draw2d.Dimension;
import com.hello2morrow.draw2d.Figure;
import com.hello2morrow.draw2d.IFigure;
import com.hello2morrow.draw2d.Point;
import com.hello2morrow.sonargraph.core.model.architecture.ArchitectureElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.ArchitectureDiagramRepresentation;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IArchitectureDiagramProvider;
import com.hello2morrow.sonargraph.core.model.architecturediagram.IUmlComponentElement;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponent;
import com.hello2morrow.sonargraph.core.model.architecturediagram.UmlComponentAnchor;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.ArchitectureDiagramLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.GridFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.IUmlComponentFigureRegistry;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentAnchorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentBodyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentConnectorFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentDependencyFigureAnchor;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentFigureGridLayout;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentIncludesExportsDependencyFigureRouter;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentInterfaceFigure;
import com.hello2morrow.sonargraph.ui.standalone.architecturediagram.UmlComponentUsesDependencyFigureRouter;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawConnectionFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawModifier;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeAndConnectionFigureCanvas;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawNodeFigure;
import com.hello2morrow.sonargraph.ui.swt.base.draw.DrawUtilities;
import com.hello2morrow.sonargraph.ui.swt.base.view.SelectionProviderAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import gnu.trove.set.hash.THashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArchitectureDiagramFigureProvider
implements DrawNodeFigure.INodeFigureProvider<UmlComponent>,
DrawConnectionFigure.IConnectionFigureProvider<UmlComponent.UmlComponentDependency>,
DrawNodeAndConnectionFigureCanvas.IListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArchitectureDiagramFigureProvider.class);
    private final Set<UmlComponentAnchorFigure> m_currentlyColoredAnchorFigures = new THashSet();
    private final IArchitectureDiagramProvider m_architectureDiagramProvider;
    private final DrawNodeAndConnectionFigureCanvas<UmlComponent, UmlComponent.UmlComponentDependency, ArchitectureDiagramLayout> m_canvas;
    private final ArchitectureDiagramRepresentation m_representation;
    private final GridFigure m_gridFigure;
    private final UmlComponentUsesDependencyFigureRouter m_usesRouter;
    private final UmlComponentIncludesExportsDependencyFigureRouter m_includesExportsRouter;

    ArchitectureDiagramFigureProvider(IViewId viewId, String secondaryId, SelectionProviderAdapter selectionProviderAdapter, IArchitectureDiagramProvider architectureDiagramProvider, DrawNodeAndConnectionFigureCanvas<UmlComponent, UmlComponent.UmlComponentDependency, ArchitectureDiagramLayout> canvas, ArchitectureDiagramRepresentation representation) {
        assert (viewId != null) : "Parameter 'viewId' of method 'ArchitectureDiagramFigureProvider' must not be null";
        assert (secondaryId != null && secondaryId.length() > 0) : "Parameter 'secondaryId' of method 'ArchitectureDiagramFigureProvider' must not be empty";
        assert (selectionProviderAdapter != null) : "Parameter 'selectionProviderAdapter' of method 'ArchitectureDiagramFigureProvider' must not be null";
        assert (architectureDiagramProvider != null) : "Parameter 'architectureDiagramProvider' of method 'ArchitectureDiagramFigureProvider' must not be null";
        assert (canvas != null) : "Parameter 'canvas' of method 'ArchitectureDiagramFigureProvider' must not be null";
        assert (representation != null) : "Parameter 'representation' of method 'ArchitectureDiagramFigureProvider' must not be null";
        this.m_architectureDiagramProvider = architectureDiagramProvider;
        this.m_canvas = canvas;
        this.m_usesRouter = new UmlComponentUsesDependencyFigureRouter((IUmlComponentFigureRegistry)this.m_canvas.getCanvasLayout());
        this.m_includesExportsRouter = new UmlComponentIncludesExportsDependencyFigureRouter((IUmlComponentFigureRegistry)this.m_canvas.getCanvasLayout());
        this.m_representation = representation;
        List umlComponents = this.m_representation.getChildren(UmlComponent.class);
        ArrayList<UmlComponentFigure> createdUmlComponentFigures = new ArrayList<UmlComponentFigure>(umlComponents.size());
        for (UmlComponent nextUmlComponent : umlComponents) {
            UmlComponentFigure nextCreated = new UmlComponentFigure(nextUmlComponent, this);
            ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).addUmlComponentFigure(nextCreated);
            this.m_canvas.addNodeFigure((DrawNodeFigure)nextCreated);
            createdUmlComponentFigures.add(nextCreated);
        }
        new UmlComponentFigureGridLayout(null, createdUmlComponentFigures);
        ArrayList<UmlComponentDependencyFigure> createdUmlComponentUsesDependencyFigures = new ArrayList<UmlComponentDependencyFigure>();
        for (UmlComponent nextUmlComponent : umlComponents) {
            UmlComponentFigure nextSource = ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).getUmlComponentFigure(nextUmlComponent);
            assert (nextSource != null) : "'nextSource' of method 'ArchitectureDiagramFigureProvider' must not be null";
            for (UmlComponent.Uses nextUses : nextUmlComponent.getOutgoingUses()) {
                UmlComponent nextTargetComponent = nextUses.getTargetComponent();
                UmlComponentFigure nextTarget = ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).getUmlComponentFigure(nextTargetComponent);
                assert (nextTarget != null) : "'nextTarget' of method 'ArchitectureDiagramFigureProvider' must not be null";
                UmlComponentConnectorFigure nextConnectorFigure = nextSource.getConnectorFigure(nextUses.getSourceConnector());
                assert (nextConnectorFigure != null) : "'nextConnectorFigure' of method 'ArchitectureDiagramFigureProvider' must not be null";
                UmlComponentInterfaceFigure nextInterfaceFigure = nextTarget.getInterfaceFigure(nextUses.getTargetInterface());
                assert (nextInterfaceFigure != null) : "'nextInterfaceFigure' of method 'ArchitectureDiagramFigureProvider' must not be null";
                UmlComponentDependencyFigure nextDependencyFigure = new UmlComponentDependencyFigure((UmlComponent.UmlComponentDependency)nextUses, this, new UmlComponentDependencyFigureAnchor(nextConnectorFigure, nextUses.getType(), UmlComponent.DependencyEndpoint.SOURCE), new UmlComponentDependencyFigureAnchor(nextInterfaceFigure, nextUses.getType(), UmlComponent.DependencyEndpoint.TARGET), (ConnectionRouter)this.m_usesRouter);
                createdUmlComponentUsesDependencyFigures.add(nextDependencyFigure);
            }
        }
        this.m_usesRouter.sort(createdUmlComponentUsesDependencyFigures).forEach(d -> this.m_canvas.addConnectionFigure((DrawConnectionFigure)d));
        if (LOGGER.isDebugEnabled()) {
            this.m_gridFigure = new GridFigure((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout());
            this.m_canvas.addToBasementLayer((IFigure)this.m_gridFigure);
        } else {
            this.m_gridFigure = null;
        }
        this.m_canvas.forceUpdate();
        this.m_canvas.setListener((DrawNodeAndConnectionFigureCanvas.IListener)this);
        selectionProviderAdapter.handleSelectionChanged();
    }

    ArchitectureDiagramRepresentation getRepresentation() {
        return this.m_representation;
    }

    public void clicked(DrawConnectionFigure<UmlComponent.UmlComponentDependency> connectionFigure, DrawModifier modifier) {
        assert (connectionFigure != null && connectionFigure instanceof UmlComponentDependencyFigure) : "Unexpected class in method 'clicked': " + String.valueOf(connectionFigure);
        assert (modifier != null) : "Parameter 'modifier' of method 'clicked' must not be null";
        LOGGER.debug("Clicked: " + String.valueOf(((UmlComponentDependencyFigure)connectionFigure).getConnection()));
        this.m_architectureDiagramProvider.select((IUmlComponentElement)((UmlComponentDependencyFigure)connectionFigure).getConnection(), this.m_representation);
    }

    public void clicked(DrawNodeFigure<UmlComponent> nodeFigure, DrawModifier modifier, IFigure source) {
        assert (nodeFigure != null && nodeFigure instanceof UmlComponentFigure) : "Unexpected class in method 'clicked': " + String.valueOf(nodeFigure);
        assert (modifier != null) : "Parameter 'modifier' of method 'clicked' must not be null";
        assert (source != null) : "Parameter 'source' of method 'clicked' must not be null";
        if (source instanceof UmlComponentAnchorFigure) {
            LOGGER.debug("Clicked: " + ((UmlComponentAnchorFigure)source).getUmlComponentAnchor().getName());
            this.m_architectureDiagramProvider.select(((UmlComponentAnchorFigure)source).getUmlComponentAnchor(), this.m_representation);
        } else {
            LOGGER.debug("Clicked: " + ((UmlComponent)nodeFigure.getNode()).getName());
            this.m_architectureDiagramProvider.select((IUmlComponentElement)nodeFigure.getNode(), this.m_representation);
        }
    }

    public void handleNoNodeOrConnectionClicked(DrawModifier modifier, Point location) {
        LOGGER.debug("No node or connection clicked");
        this.m_architectureDiagramProvider.deselectAll(this.m_representation);
    }

    private void updateSizeOfParentUmlComponentFigures(UmlComponentFigure umlComponentFigure) {
        assert (umlComponentFigure != null) : "Parameter 'umlComponentFigure' of method 'updateSizeOfParentUmlComponentFigures' must not be null";
        for (UmlComponentFigure next : DrawUtilities.findParents(UmlComponentFigure.class, (IFigure)umlComponentFigure)) {
            LOGGER.trace("Update size of uml component figure: " + ((UmlComponent)next.getNode()).getName());
            UmlComponentBodyFigure body = next.getBody();
            List children = body.getChildren();
            ArrayList<UmlComponentFigure> updateFigures = new ArrayList<UmlComponentFigure>(children.size());
            for (Object nextChild : children) {
                if (!(nextChild instanceof UmlComponentFigure)) continue;
                updateFigures.add((UmlComponentFigure)((Object)nextChild));
            }
            UmlComponentFigureGridLayout gridLayout = new UmlComponentFigureGridLayout((Figure)body, updateFigures);
            body.update(gridLayout.getSize());
            gridLayout.layout(updateFigures);
        }
    }

    public void expand(DrawNodeFigure<UmlComponent> nodeFigure) {
        assert (nodeFigure != null && nodeFigure instanceof UmlComponentFigure) : "Unexpected class in method 'expand': " + String.valueOf(nodeFigure);
        this.m_canvas.setRedraw(false);
        UmlComponentFigure umlComponentFigure = (UmlComponentFigure)nodeFigure;
        UmlComponent node = (UmlComponent)umlComponentFigure.getNode();
        assert (node.isExpandable()) : "Not expandable: " + String.valueOf(node);
        assert (!node.isExpanded()) : "Already expanded: " + String.valueOf(node);
        LOGGER.trace("Expand: " + node.getName());
        List childUmlComponents = node.getChildren(UmlComponent.class);
        assert (childUmlComponents != null && !childUmlComponents.isEmpty()) : "'childUmlComponents' of method 'expand' must not be empty for: " + node.getName();
        ArrayList<UmlComponentFigure> childFigures = new ArrayList<UmlComponentFigure>(childUmlComponents.size());
        for (UmlComponent nextChildComponent : childUmlComponents) {
            UmlComponentFigure nextCreated = new UmlComponentFigure(nextChildComponent, this);
            childFigures.add(nextCreated);
            ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).addUmlComponentFigure(nextCreated);
        }
        ArrayList<UmlComponentDependencyFigure> createdAnchorBasedDependencyFigures = new ArrayList<UmlComponentDependencyFigure>();
        for (UmlComponent nextSourceComponent : childUmlComponents) {
            UmlComponentFigure nextSource = ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).getUmlComponentFigure(nextSourceComponent);
            for (UmlComponent.AnchorBased nextAnchorBased : nextSourceComponent.getAnchorBased()) {
                UmlComponent nextTargetComponent = nextAnchorBased.getTargetComponent();
                assert (node == nextTargetComponent) : "Unexpected target component: " + String.valueOf(nextTargetComponent);
                UmlComponentAnchorFigure nextSourceAnchorFigure = nextSource.getAnchorFigure((UmlComponentAnchor<? extends ArchitectureElement>)nextAnchorBased.getSourceAnchor());
                assert (nextSourceAnchorFigure != null) : "'nextSourceAnchorFigure' of method 'expand' must not be null";
                UmlComponentAnchorFigure nextTargetAnchorFigure = umlComponentFigure.getAnchorFigure((UmlComponentAnchor<? extends ArchitectureElement>)nextAnchorBased.getTargetAnchor());
                assert (nextTargetAnchorFigure != null) : "'nextTargetAnchorFigure' of method 'expand' must not be null";
                UmlComponentDependencyFigure nextDependencyFigure = new UmlComponentDependencyFigure((UmlComponent.UmlComponentDependency)nextAnchorBased, this, new UmlComponentDependencyFigureAnchor(nextSourceAnchorFigure, nextAnchorBased.getType(), UmlComponent.DependencyEndpoint.SOURCE), new UmlComponentDependencyFigureAnchor(nextTargetAnchorFigure, nextAnchorBased.getType(), UmlComponent.DependencyEndpoint.TARGET), (ConnectionRouter)this.m_includesExportsRouter);
                createdAnchorBasedDependencyFigures.add(nextDependencyFigure);
            }
        }
        ArrayList<UmlComponentDependencyFigure> createdUsesDependencyFigures = new ArrayList<UmlComponentDependencyFigure>();
        for (UmlComponent nextSourceComponent : childUmlComponents) {
            UmlComponentFigure nextSource = ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).getUmlComponentFigure(nextSourceComponent);
            for (UmlComponent.Uses nextUses : nextSourceComponent.getOutgoingUses()) {
                UmlComponent nextTargetComponent = nextUses.getTargetComponent();
                UmlComponentFigure nextTarget = ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).getUmlComponentFigure(nextTargetComponent);
                assert (nextTarget != null) : "'nextTarget' of method 'ArchitectureDiagramFigureProvider' must not be null for: " + nextTargetComponent.getName();
                UmlComponentConnectorFigure nextConnectorFigure = nextSource.getConnectorFigure(nextUses.getSourceConnector());
                assert (nextConnectorFigure != null) : "'nextConnectorFigure' of method 'ArchitectureDiagramFigureProvider' must not be null";
                UmlComponentInterfaceFigure nextInterfaceFigure = nextTarget.getInterfaceFigure(nextUses.getTargetInterface());
                assert (nextInterfaceFigure != null) : "'nextInterfaceFigure' of method 'ArchitectureDiagramFigureProvider' must not be null";
                UmlComponentDependencyFigure nextDependencyFigure = new UmlComponentDependencyFigure((UmlComponent.UmlComponentDependency)nextUses, this, new UmlComponentDependencyFigureAnchor(nextConnectorFigure, nextUses.getType(), UmlComponent.DependencyEndpoint.SOURCE), new UmlComponentDependencyFigureAnchor(nextInterfaceFigure, nextUses.getType(), UmlComponent.DependencyEndpoint.TARGET), (ConnectionRouter)this.m_usesRouter);
                createdUsesDependencyFigures.add(nextDependencyFigure);
            }
        }
        UmlComponentBodyFigure body = umlComponentFigure.getBody();
        UmlComponentFigureGridLayout gridLayout = new UmlComponentFigureGridLayout((Figure)body, childFigures);
        body.update(gridLayout.getSize());
        gridLayout.layout(childFigures);
        createdAnchorBasedDependencyFigures.forEach(d -> body.add((IFigure)d));
        this.m_usesRouter.sort(createdUsesDependencyFigures).forEach(d -> body.add((IFigure)d));
        childFigures.forEach(n -> body.add((IFigure)n));
        this.updateSizeOfParentUmlComponentFigures(umlComponentFigure);
        node.setIsExpanded(true);
        if (this.m_gridFigure != null) {
            this.m_gridFigure.update();
        }
        this.m_canvas.setRedraw(true);
        this.m_canvas.forceUpdate();
    }

    public void collapse(DrawNodeFigure<UmlComponent> nodeFigure) {
        assert (nodeFigure != null && nodeFigure instanceof UmlComponentFigure) : "Unexpected class in method 'collapse': " + String.valueOf(nodeFigure);
        UmlComponentFigure umlComponentFigure = (UmlComponentFigure)nodeFigure;
        UmlComponent node = (UmlComponent)umlComponentFigure.getNode();
        assert (node.isExpandable()) : "Not expandable: " + String.valueOf(node);
        assert (node.isExpanded()) : "Not expanded: " + String.valueOf(node);
        this.m_canvas.setRedraw(false);
        List childFigures = DrawUtilities.findChildFigures(UmlComponentFigure.class, (IFigure)umlComponentFigure);
        childFigures.forEach(c -> ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).removeUmlComponentFigure((UmlComponentFigure)((Object)c)));
        UmlComponentBodyFigure body = umlComponentFigure.getBody();
        body.removeAll();
        body.update(new Dimension(umlComponentFigure.getHeader().getPreferredSize()));
        body.revalidate();
        body.repaint();
        this.updateSizeOfParentUmlComponentFigures((UmlComponentFigure)nodeFigure);
        node.getChildrenRecursively(UmlComponent.class, new Class[0]).forEach(c -> c.setIsExpanded(false));
        node.setIsExpanded(false);
        if (this.m_gridFigure != null) {
            this.m_gridFigure.update();
        }
        this.m_canvas.setRedraw(true);
        this.m_canvas.forceUpdate();
    }

    void delete() {
        this.m_currentlyColoredAnchorFigures.clear();
        ((ArchitectureDiagramLayout)this.m_canvas.getCanvasLayout()).reset();
    }
}

