/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.command.common.ICommandId;
import com.hello2morrow.sonargraph.core.command.system.base.CoreCommandId;
import com.hello2morrow.sonargraph.core.model.element.Element;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewFile;
import com.hello2morrow.sonargraph.core.model.explorationview.IArchitecturalViewProvider;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferExecutionInfo;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewHandler;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewMenuGroup;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.TransferWizard;
import com.hello2morrow.sonargraph.ui.swt.base.commandhandler.CommandHandler;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuContributor;
import com.hello2morrow.sonargraph.ui.swt.base.view.IMenuGroup;
import com.hello2morrow.sonargraph.ui.swt.base.view.IWorkbenchView;
import com.hello2morrow.sonargraph.ui.swt.base.view.WorkbenchViewSelection;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ViewId;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IViewId;
import jakarta.inject.Named;
import java.util.List;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.swt.widgets.Shell;

public final class TransferHandler
extends ArchitecturalViewHandler {
    public ICommandId getCorrespondingCommandId() {
        return CoreCommandId.TRANSFER_ARCHITECTURAL_VIEW;
    }

    @Override
    protected boolean mayBeExecutedInView(IViewId viewId) {
        assert (viewId != null) : "Parameter 'viewId' of method 'mayBeExecutedInView' must not be null";
        return viewId == ViewId.EXPLORATION_VIEW || viewId == ViewId.FILES_VIEW;
    }

    public final IContextMenuContributor createContextMenuContributor() {
        return new IContextMenuContributor(){

            public String getLabel(IWorkbenchView workbenchView, List<Element> currentSelection, String defaultLabel) {
                if (!$assertionsDisabled && workbenchView == null) {
                    throw new AssertionError((Object)"Parameter 'workbenchView' of method 'getLabel' must not be null");
                }
                if (workbenchView.getViewId() == ViewId.FILES_VIEW) {
                    if (!$assertionsDisabled && !WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) {
                        throw new AssertionError((Object)"No system available");
                    }
                    ArchitecturalViewFile file = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getArchitecturalViewFile(currentSelection);
                    if (!$assertionsDisabled && file == null) {
                        throw new AssertionError((Object)"'file' of method 'getLabel' must not be null");
                    }
                    return "Transfer Architectural View [" + file.getIdentifyingPath() + "]...";
                }
                return "Transfer...";
            }

            public IMenuGroup getMenuGroup() {
                return ArchitecturalViewMenuGroup.FILE;
            }
        };
    }

    @CanExecute
    public final boolean canExecute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        if (this.mayBeExecuted(selection)) {
            NamedElement element = (NamedElement)CommandHandler.getSingleSelection(NamedElement.class, (List)selection.getElements(), (boolean)false);
            return element != null && ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).isTransferPossible(element) != null;
        }
        return false;
    }

    @Execute
    public final void execute(@Optional @Named(value="org.eclipse.ui.selection") WorkbenchViewSelection selection) {
        assert (selection != null) : "Parameter 'selection' of method 'execute' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "Not software system available";
        NamedElement element = (NamedElement)CommandHandler.getSingleSelection(NamedElement.class, (List)selection.getElements(), (boolean)false);
        assert (element != null) : "'element' of method 'execute' must not be null";
        TransferExecutionInfo info = ((IArchitecturalViewProvider)WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem().getExtension(IArchitecturalViewProvider.class)).getTransferExecutionInfo(element);
        assert (info != null) : "'info' of method 'execute' must not be null";
        SonargraphWizardAdapter.createWizardDialog((Shell)WorkbenchRegistry.getInstance().getMainApplicationWindowShell(), (SonargraphWizard)new TransferWizard(info)).open();
    }
}

