/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.model.explorationview.TransferArchitectureExecutionInfo;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class TransferArchitectureWizardPage
extends NameAndDescriptionWizardPage {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_TRANSFER_ARCHITECTURE.getStandardName();
    private final TransferArchitectureExecutionInfo m_info;
    private Button m_addToArchitectureCheck;
    private Button m_createIgnoreViolationResolutions;

    private static ITextValidator getValidator(TransferArchitectureExecutionInfo info) {
        assert (info != null) : "Parameter 'info' of method 'getValidator' must not be null";
        return info.getTargetFileValidator();
    }

    private static String getNameProposal(TransferArchitectureExecutionInfo info) {
        assert (info != null) : "Parameter 'info' of method 'getNameProposal' must not be null";
        return info.getTargetFileNameProposal();
    }

    TransferArchitectureWizardPage(TransferArchitectureExecutionInfo info) {
        super(NAME, CoreDialogId.ARCHITECTURAL_VIEW_TRANSFER_ARCHITECTURE.getPresentationName(), "File Name", TransferArchitectureWizardPage.getValidator(info), TransferArchitectureWizardPage.getNameProposal(info), "");
        assert (info != null) : "Parameter 'info' of method 'GenerateArchitectureFileWizardPage' must not be null";
        this.m_info = info;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.m_addToArchitectureCheck.setEnabled(this.m_info.isAddToArchitectureCheckPossible());
        this.m_createIgnoreViolationResolutions.setEnabled(this.m_info.isCreateIgnoreViolationResolutionsPossible());
    }

    @Override
    protected void addWidgetsToDialogAreaBefore(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaBefore' must not be null";
        final Button transferArchitecture = new Button(composite, 32);
        transferArchitecture.setText("Transfer Architecture");
        transferArchitecture.setSelection(this.m_info.transfer());
        transferArchitecture.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransferArchitectureWizardPage.this.m_info.transfer(transferArchitecture.getSelection());
                if (TransferArchitectureWizardPage.this.m_info.transfer()) {
                    TransferArchitectureWizardPage.this.setEnabled(true);
                    TransferArchitectureWizardPage.this.getNameTextWidget().setText(TransferArchitectureWizardPage.this.m_info.getFileName());
                } else {
                    TransferArchitectureWizardPage.this.setPageComplete(true);
                    TransferArchitectureWizardPage.this.setEnabled(false);
                }
                TransferArchitectureWizardPage.this.getContainer().updateButtons();
            }
        });
        transferArchitecture.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        new Label(composite, 258).setLayoutData((Object)new GridData(4, 2, true, false, 3, 1));
    }

    @Override
    protected void addWidgetsToDialogAreaAfter(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        this.m_addToArchitectureCheck = new Button(composite, 32);
        this.m_addToArchitectureCheck.setText("Add To Architecture Check");
        this.m_addToArchitectureCheck.setToolTipText("If the generation overwrites a file that is already checked, it will not be removed from the architecture check.");
        this.m_addToArchitectureCheck.setSelection(this.m_info.addToArchitectureCheck());
        this.m_addToArchitectureCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransferArchitectureWizardPage.this.m_info.addToArchitectureCheck(TransferArchitectureWizardPage.this.m_addToArchitectureCheck.getSelection());
                TransferArchitectureWizardPage.this.m_createIgnoreViolationResolutions.setEnabled(TransferArchitectureWizardPage.this.m_info.isCreateIgnoreViolationResolutionsPossible());
            }
        });
        this.m_addToArchitectureCheck.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
        this.m_createIgnoreViolationResolutions = new Button(composite, 32);
        Map ignoredViolationsInfo = this.m_info.getIgnoredViolationsInfo();
        int total = 0;
        for (List next : ignoredViolationsInfo.values()) {
            total += next.size();
        }
        this.m_createIgnoreViolationResolutions.setText("Create " + ignoredViolationsInfo.size() + " resolution(s) ignoring " + total + " violation(s)");
        this.m_createIgnoreViolationResolutions.setSelection(this.m_info.createIgnoreViolationResolutions());
        this.m_createIgnoreViolationResolutions.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TransferArchitectureWizardPage.this.m_info.createIgnoreViolationResolutions(TransferArchitectureWizardPage.this.m_createIgnoreViolationResolutions.getSelection());
            }
        });
        this.m_createIgnoreViolationResolutions.setEnabled(this.m_info.isCreateIgnoreViolationResolutionsPossible());
        this.m_createIgnoreViolationResolutions.setLayoutData((Object)new GridData(3, 2, false, false, 3, 1));
    }

    @Override
    protected void elementNameModified(String name) {
        this.m_info.setFileName(name == null ? "" : name);
        this.getContainer().updateButtons();
    }

    @Override
    protected void descriptionModified(String description) {
        this.m_info.setDescription(description == null ? "" : description);
        this.getContainer().updateButtons();
    }
}

