/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.common.PresentationMode;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewElement;
import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.ExplorationViewRepresentation;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.ArchitecturalViewTreeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.workbench.CoreDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.ComboWithImages;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

final class SelectElementsPage<S extends ArchitecturalViewElement>
extends StandardWizardPage {
    static final String NAME = CoreDialogId.ARCHITECTURAL_VIEW_INPUT_ELEMENTS.getStandardName();
    private final Set<String> m_relativeElementPaths = new HashSet<String>();
    private final List<S> m_selected = new ArrayList<S>();
    private final ExplorationViewRepresentation m_representation;
    private final Class<S> m_selectableClass;
    private final IProvider m_provider;
    private ComboWithImages m_combo;
    private TreeViewer m_treeViewer;
    boolean m_hasBeenVisible;

    SelectElementsPage(String title, Class<S> selectableClass, List<S> select, List<String> relativeElementPaths, ExplorationViewRepresentation representation, IProvider provider) {
        super(NAME, title);
        assert (representation != null) : "Parameter 'representation' of method 'SelectElementsPage' must not be null";
        assert (selectableClass != null) : "Parameter 'selectableClass' of method 'SelectElementsPage' must not be null";
        assert (select != null) : "Parameter 'select' of method 'SelectElementsPage' must not be null";
        assert (relativeElementPaths != null && !relativeElementPaths.isEmpty()) : "Parameter 'relativeElementPaths' of method 'SelectElementsPage' must not be empty";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'SelectElementsPage' must not be empty";
        assert (provider != null) : "Parameter 'provider' of method 'SelectElementsPage' must not be null";
        this.m_representation = representation;
        this.m_selectableClass = selectableClass;
        this.m_provider = provider;
        this.m_selected.addAll(select);
        this.m_relativeElementPaths.addAll(relativeElementPaths);
        this.setPageComplete(this.m_provider.selectedElementsChanged(this.m_selected));
    }

    protected IDialogId getDialogId() {
        return CoreDialogId.ARCHITECTURAL_VIEW_INPUT_ELEMENTS;
    }

    boolean hasBeenEdited() {
        if (this.m_provider.includePresentationModeChangeInHasBeenEdited() && this.m_combo.getSelectedItem() != this.m_provider.getOriginalPresentationMode()) {
            return true;
        }
        HashSet<String> currentRelativeElementPaths = new HashSet<String>();
        for (ArchitecturalViewElement next : this.m_selected) {
            currentRelativeElementPaths.add(next.getRelativePath());
        }
        return !currentRelativeElementPaths.equals(this.m_relativeElementPaths);
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'addWidgetsToDialogAreaAfter' must not be null";
        this.m_combo = new ComboWithImages(composite, -1, "Select presentation mode", new ComboWithImages.ILabelProvider(){

            public String getText(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof PresentationMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getText': " + String.valueOf(item)));
                }
                return ((PresentationMode)item).getPresentationName();
            }

            public Image getImage(Object item) {
                if (!($assertionsDisabled || item != null && item instanceof PresentationMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'getImage': " + String.valueOf(item)));
                }
                return UiResourceManager.getInstance().getImage(((PresentationMode)item).getStandardName());
            }
        });
        this.m_combo.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_combo.setItems(Arrays.asList(PresentationMode.values()), (Object)PresentationMode.HIERARCHICAL);
        this.m_combo.setSelectionListener(new ComboWithImages.IItemSelectionListener(){

            public void itemSelected(ComboWithImages source, Object item) {
                if (!($assertionsDisabled || item != null && item instanceof PresentationMode)) {
                    throw new AssertionError((Object)("Unexpected class in method 'itemSelected': " + String.valueOf(item)));
                }
                SelectElementsPage.this.m_provider.setPresentationMode((PresentationMode)item);
                SelectElementsPage.this.m_treeViewer.refresh();
            }
        });
        this.m_treeViewer = new TreeViewer(composite, 2);
        this.m_treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        ContentAndLabelProvider contentAndLabelProvider = new ContentAndLabelProvider();
        this.m_treeViewer.setContentProvider((IContentProvider)contentAndLabelProvider);
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)contentAndLabelProvider);
        this.m_treeViewer.setInput((Object)this.m_representation);
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!$assertionsDisabled && event == null) {
                    throw new AssertionError((Object)"Parameter 'event' of method 'selectionChanged' must not be null");
                }
                SelectElementsPage.this.m_selected.clear();
                for (Object next : event.getStructuredSelection().toList()) {
                    if (!($assertionsDisabled || next != null && next instanceof ArchitecturalViewElement)) {
                        throw new AssertionError((Object)("Unexpected class in method 'selectionChanged': " + String.valueOf(next)));
                    }
                    if (!SelectElementsPage.this.m_selectableClass.isAssignableFrom(next.getClass())) continue;
                    SelectElementsPage.this.m_selected.add((ArchitecturalViewElement)next);
                }
                SelectElementsPage.this.setPageComplete(SelectElementsPage.this.m_provider.selectedElementsChanged(SelectElementsPage.this.m_selected));
            }
        });
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.m_hasBeenVisible) {
            this.m_combo.setSelected((Object)this.m_provider.getOriginalPresentationMode());
            this.m_treeViewer.expandAll();
            this.m_treeViewer.setSelection((ISelection)new StructuredSelection(this.m_selected), false);
            this.m_hasBeenVisible = true;
        }
    }

    List<S> getSelected() {
        return Collections.unmodifiableList(this.m_selected);
    }

    static final class ContentAndLabelProvider
    extends ArchitecturalViewTreeContentAndLabelProvider {
        ContentAndLabelProvider() {
        }

        public Object getParent(Object child) {
            assert (child instanceof ArchitecturalViewNode) : "Unexpected class in method 'getChildren': " + String.valueOf(child);
            return ((ArchitecturalViewNode)child).getNodeParent();
        }

        public Object[] getElements(Object parent) {
            assert (parent != null && parent instanceof ExplorationViewRepresentation) : "Unexpected class in method 'getElements': " + String.valueOf(parent);
            return ((ExplorationViewRepresentation)parent).getSortedVisibleNodeChildren().toArray();
        }

        public boolean hasChildren(Object parent) {
            assert (parent != null && parent instanceof ArchitecturalViewNode) : "Unexpected class in method 'hasChildren': " + String.valueOf(parent);
            return !((ArchitecturalViewNode)parent).getNodeChildren(n -> true, false).isEmpty();
        }

        public Object[] getChildren(Object parent) {
            assert (parent != null && parent instanceof ArchitecturalViewNode) : "Unexpected class in method 'getChildren': " + String.valueOf(parent);
            return ((ArchitecturalViewNode)parent).getNodeChildren(n -> true, true).toArray();
        }

        public String getText(Object element) {
            assert (element != null && element instanceof ArchitecturalViewNode) : "Unexpected class in method 'getText': " + String.valueOf(element);
            return ((ArchitecturalViewNode)element).getPresentationName(true);
        }
    }

    public static interface IProvider {
        public boolean includePresentationModeChangeInHasBeenEdited();

        public PresentationMode getOriginalPresentationMode();

        public void setPresentationMode(PresentationMode var1);

        public boolean selectedElementsChanged(List<? extends ArchitecturalViewElement> var1);
    }
}

