/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.architecturalview;

import com.hello2morrow.sonargraph.core.model.explorationview.ArchitecturalViewNode;
import com.hello2morrow.sonargraph.core.model.explorationview.PartialAlternativeInfo;
import com.hello2morrow.sonargraph.ui.standalone.architecturalview.LayoutCreator;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class PartialAlternativeInfoComposite
extends Composite
implements DisposeListener {
    private static final String PARTIAL_ALTERNATIVE_ID = "architecturalView.partialAlternative";
    private static final String USE = "use";
    private final PartialAlternativeInfo m_partialAlternativeInfo;
    private final IConsumer m_consumer;
    private boolean m_usePartialAlternative;

    static int getMovePartialElementsFeedback() {
        String question = "The elements you want to move do not show all their children due to a focus. \nWhat do you want to do?";
        String[] buttonLabels = new String[]{"Move Only With Shown Children", "Move With All Children", "Cancel"};
        return UserInterfaceAdapter.getInstance().question("The elements you want to move do not show all their children due to a focus. \nWhat do you want to do?", buttonLabels);
    }

    PartialAlternativeInfoComposite(Composite parent, PartialAlternativeInfo info, IConsumer consumer) {
        super(parent, 0);
        assert (parent != null) : "Parameter 'parent' of method 'PartialAlternativeInfoComposite' must not be null";
        assert (info != null) : "Parameter 'info' of method 'PartialAlternativeInfoComposite' must not be null";
        assert (consumer != null) : "Parameter 'consumer' of method 'PartialAlternativeInfoComposite' must not be null";
        this.m_partialAlternativeInfo = info;
        this.m_consumer = consumer;
        this.m_usePartialAlternative = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (String)PARTIAL_ALTERNATIVE_ID).getBoolean(USE, true);
        if (this.m_consumer.showBasedOnLabel()) {
            this.setLayout((Layout)LayoutCreator.createCompositeGridLayout(2));
            Label elements = new Label((Composite)this, 0);
            elements.setText("Based on:");
            elements.setLayoutData((Object)new GridData(1, 0x1000000, false, true));
        } else {
            this.setLayout((Layout)LayoutCreator.createCompositeGridLayout(1));
        }
        Composite elementsComposite = new Composite((Composite)this, 0);
        elementsComposite.setLayout((Layout)LayoutCreator.createRowLayout());
        elementsComposite.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        Button shownChildrenOnlyButton = new Button(elementsComposite, 16);
        shownChildrenOnlyButton.setText("Shown children only (due to focus)");
        shownChildrenOnlyButton.setSelection(this.m_usePartialAlternative);
        shownChildrenOnlyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PartialAlternativeInfoComposite.this.m_usePartialAlternative = true;
                PartialAlternativeInfoComposite.this.m_consumer.modified();
            }
        });
        Button allChildrenButton = new Button(elementsComposite, 16);
        allChildrenButton.setText("All children");
        allChildrenButton.setSelection(!this.m_usePartialAlternative);
        allChildrenButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                PartialAlternativeInfoComposite.this.m_usePartialAlternative = false;
                PartialAlternativeInfoComposite.this.m_consumer.modified();
            }
        });
        this.addDisposeListener(this);
    }

    public boolean usePartialAlternative() {
        return this.m_usePartialAlternative;
    }

    List<ArchitecturalViewNode> getAlternativeElements() {
        if (this.m_usePartialAlternative) {
            return this.m_partialAlternativeInfo.getAlternativeNodes();
        }
        return null;
    }

    public void widgetDisposed(DisposeEvent event) {
        IEclipsePreferences preferences = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone", (String)PARTIAL_ALTERNATIVE_ID);
        preferences.putBoolean(USE, this.m_usePartialAlternative);
    }

    public static interface IConsumer {
        default public boolean showBasedOnLabel() {
            return true;
        }

        default public void modified() {
        }
    }
}

