/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.application;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.system.CloseSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CloseCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.ISonargraphUIContribution;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.IWorkbench;
import org.eclipse.e4.ui.workbench.modeling.IWindowCloseHandler;

final class SonargraphStandaloneExitHandler
implements IWindowCloseHandler,
ISonargraphUIContribution {
    static void closeApplicationDueToLicenseLost() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (provider.hasSoftwareSystem()) {
            CloseSoftwareSystemCommand command = new CloseSoftwareSystemCommand(provider, (CloseSoftwareSystemCommand.ICloseInteraction)new HandleLicenseLostEventInteraction(false));
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
        }
        WorkbenchRegistry.getInstance().shutdownStarted();
        WorkbenchRegistry.getInstance().getWorkbench().close();
    }

    SonargraphStandaloneExitHandler() {
    }

    private static boolean shutdownRequested() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        if (provider.hasSoftwareSystem()) {
            CloseSoftwareSystemCommand command = new CloseSoftwareSystemCommand(provider, (CloseSoftwareSystemCommand.ICloseInteraction)new CloseCommandInteraction(true){

                @Override
                public boolean closeSoftwareSystem() {
                    return true;
                }
            });
            CommandException commandException = UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            if (commandException != null) {
                return UserInterfaceAdapter.getInstance().question("An error has occurred - force quit?", false) == UserInterfaceAdapter.Feedback.CONFIRMED;
            }
        }
        if (!provider.hasSoftwareSystem()) {
            WorkbenchRegistry.getInstance().shutdownStarted();
            return true;
        }
        return false;
    }

    @Execute
    public void close(IWorkbench workbench) {
        assert (workbench != null) : "Parameter 'workbench' of method 'execute' must not be null";
        if (SonargraphStandaloneExitHandler.shutdownRequested()) {
            workbench.close();
        }
    }

    public final boolean close(MWindow window) {
        assert (window != null) : "Parameter 'window' of method 'close' must not be null";
        return SonargraphStandaloneExitHandler.shutdownRequested();
    }

    private static final class HandleLicenseLostEventInteraction
    extends CloseCommandInteraction {
        private HandleLicenseLostEventInteraction(boolean allowCancel) {
            super(allowCancel);
        }

        @Override
        public boolean closeSoftwareSystem() {
            return true;
        }
    }
}

