/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.analyzersview;

import com.hello2morrow.sonargraph.core.model.analysis.AnalyzerResult;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

final class AnalyzerViewComparator
extends ViewerComparator {
    private Column m_column;
    private boolean m_ascending = true;

    AnalyzerViewComparator(Column column, boolean ascending) {
        assert (column != null) : "Parameter 'column' of method 'AnalyzerViewComparator' must not be null";
        this.m_column = column;
        this.m_ascending = ascending;
    }

    int getDirection() {
        return this.m_ascending ? 128 : 1024;
    }

    void setColumn(Column column) {
        assert (column != null) : "Parameter 'column' of method 'setColumn' must not be null";
        if (column.equals((Object)this.m_column)) {
            this.m_ascending = !this.m_ascending;
        } else {
            this.m_column = column;
            this.m_ascending = true;
        }
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        assert (viewer != null) : "Parameter 'viewer' of method 'compare' must not be null";
        assert (o1 != null && o1 instanceof AnalyzerResult) : "Unexpected class in method 'compare': " + String.valueOf(o1);
        assert (o2 != null && o2 instanceof AnalyzerResult) : "Unexpected class in method 'compare': " + String.valueOf(o1);
        AnalyzerResult a1 = (AnalyzerResult)o1;
        AnalyzerResult a2 = (AnalyzerResult)o2;
        int compared = 0;
        switch (this.m_column) {
            case LEVEL: {
                compared = a1.getId().getExecutionLevel().ordinal() - a2.getId().getExecutionLevel().ordinal();
                if (compared != 0) break;
                compared = a1.getPresentationName(false).compareTo(a2.getPresentationName(false));
                break;
            }
            case NAME: {
                compared = a1.getPresentationName(false).compareTo(a2.getPresentationName(false));
                break;
            }
            default: {
                assert (false) : "Unhandled column: " + String.valueOf((Object)this.m_column);
                compared = 0;
            }
        }
        if (!this.m_ascending) {
            compared = -compared;
        }
        return compared;
    }

    static enum Column {
        LEVEL,
        NAME;

    }
}

