/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.common;

import com.hello2morrow.sonargraph.ui.swt.common.NavigationState;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class QueuePrinterDebug {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueuePrinterDebug.class);
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void printCollection(Collection<? extends NavigationState> collection, String name) {
        LOGGER.debug(QueuePrinterDebug.getStringForQueue(collection, name));
    }

    private static String getStringForQueue(Collection<? extends NavigationState> collection, String name) {
        StringBuilder leadingQueue = new StringBuilder();
        leadingQueue.append(LINE_SEPARATOR);
        leadingQueue.append("------------------------------------------------------------------------------------------");
        leadingQueue.append(LINE_SEPARATOR);
        leadingQueue.append("************************************* ");
        leadingQueue.append(name);
        leadingQueue.append(" *************************************");
        leadingQueue.append(LINE_SEPARATOR);
        int index = 0;
        if (collection.isEmpty()) {
            leadingQueue.append("*EMPTY*");
            leadingQueue.append(LINE_SEPARATOR);
        }
        for (NavigationState navigationState : collection) {
            leadingQueue.append(QueuePrinterDebug.getNavigationStateString(navigationState, index));
            ++index;
        }
        leadingQueue.append("------------------------------------------------------------------------------------------");
        leadingQueue.append(LINE_SEPARATOR);
        return leadingQueue.toString();
    }

    public static String getNavigationStateString(NavigationState action, Object additionalInfo) {
        StringBuilder stateString = new StringBuilder();
        stateString.append("| ");
        stateString.append(additionalInfo);
        stateString.append(" | ");
        stateString.append(action);
        stateString.append(" | ");
        stateString.append(System.identityHashCode(action));
        stateString.append(" |");
        stateString.append(LINE_SEPARATOR);
        return stateString.toString();
    }

    public static void printFocusState(NavigationState current, NavigationState nextForUnfocus, Collection<NavigationState> queue) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuilder focusState = new StringBuilder(lineSeparator);
        focusState.append("************************************* ");
        focusState.append("FOCUS STATE");
        focusState.append(" *************************************");
        focusState.append(lineSeparator);
        focusState.append("---------------------------------------------------------------------------");
        focusState.append("---------------------------------------------------------------------------");
        focusState.append(lineSeparator);
        focusState.append("* CURRENT STATE * ");
        focusState.append(QueuePrinterDebug.getNavigationStateString(current, ""));
        focusState.append("---------------------------------------------------------------------------");
        focusState.append("---------------------------------------------------------------------------");
        focusState.append(lineSeparator);
        focusState.append("* NEXT UNFOCUS STATE * ");
        focusState.append(QueuePrinterDebug.getNavigationStateString(nextForUnfocus, ""));
        focusState.append(QueuePrinterDebug.getStringForQueue(queue, "Focus Queue"));
        LOGGER.debug(focusState.toString());
    }

    public static void logAlreadyNavigating(String methodName) {
        LOGGER.warn("Already navigating in method '" + methodName + "'");
    }
}

