/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.typescript.wizard;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.ImportQualityModelCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.typescript.command.system.CreateNewTypescriptSystemCommand;
import com.hello2morrow.sonargraph.languageprovider.typescript.foundation.common.TypescriptLanguage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.QualityModelLoader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CreateSystemCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.typescript.wizard.SelectTypescriptConfigFilePage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import java.util.List;

public final class TypescriptSystemWizard
extends NonLazySonargraphWizard {
    private SystemDirectoryWizardPage m_basicDataPage;
    private SelectTypescriptConfigFilePage m_configFilePage;

    public TypescriptSystemWizard() {
        super("New System based on Typescript tsconfig.json File");
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        List fileDescriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)provider);
        List resolvedDescriptors = QualityModelLoader.loadQualityModelFiles((List)fileDescriptors);
        int defaultIndex = 0;
        int i = 0;
        while (i < resolvedDescriptors.size()) {
            Language qualityModelLanguage = ((ResolvedQualityModelDescriptorFile)resolvedDescriptors.get(i)).getQualityModelFileDescriptor().getLanguage();
            if (qualityModelLanguage != null && qualityModelLanguage.equals((Object)TypescriptLanguage.INSTANCE)) {
                defaultIndex = i;
                break;
            }
            ++i;
        }
        this.m_basicDataPage = new SystemDirectoryWizardPage("PAGE_1", "Specify the name, description and location of the new system", "Name:", "Directory:", "Use predefined quality model", CreateSoftwareSystemCommand.getNameValidator((ISoftwareSystemProvider)provider), CreateSoftwareSystemCommand.getBaseDirectoryValidator((ISoftwareSystemProvider)provider), ImportQualityModelCommand.getImportQualityModelValidator((ISoftwareSystemProvider)provider), resolvedDescriptors, defaultIndex, "", "");
        this.m_configFilePage = new SelectTypescriptConfigFilePage("PAGE-2", (IDirectoryProvider)this.m_basicDataPage);
        this.addPage((SonargraphWizardPage)this.m_basicDataPage);
        this.addPage((SonargraphWizardPage)this.m_configFilePage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            Interaction interaction = new Interaction(this.m_basicDataPage);
            CreateNewTypescriptSystemCommand command = new CreateNewTypescriptSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (CreateNewTypescriptSystemCommand.IInteraction)interaction);
            UserInterfaceAdapter.getInstance().run((Command)command);
            return true;
        }
        return false;
    }

    private final class Interaction
    extends CreateSystemCommandInteraction
    implements CreateNewTypescriptSystemCommand.IInteraction {
        public Interaction(SystemDirectoryWizardPage basicDataPage) {
            super(basicDataPage);
        }

        public boolean collectTsConfigData(CreateNewTypescriptSystemCommand.TsConfigFileData configData) {
            configData.setTsConfigFile(TypescriptSystemWizard.this.m_configFilePage.getSelectedFile());
            return true;
        }

        public void processResult(OperationResult result) {
            if (!result.isEmpty()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

