/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.typescript.pages.preferences;

import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.typescript.model.system.ITypescriptSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.typescript.dialog.TypescriptDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class TypescriptPreferencesPage
extends StandardPreferencePage
implements ISettingsDelta {
    private ValidatingPathWidget m_typescriptPathWidget;
    private TFile m_interpreter = null;
    private String m_interpreterPath;

    public TypescriptPreferencesPage() {
        this.noDefaultAndApplyButton();
    }

    private ITypescriptSettingsProvider getSettingsExtension() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        return (ITypescriptSettingsProvider)installation.getExtension(ITypescriptSettingsProvider.class);
    }

    public IDialogId getDialogId() {
        return TypescriptDialogId.TYPESCRIPT_PREFERENCES;
    }

    protected boolean okToLeavePageWithErrors() {
        return true;
    }

    protected final Composite createPageContents(Composite parent) {
        this.initInterpreter();
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Composite composite = new Composite(container, 1);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        explanation.setText("Locate the executable for the NodeJS on this machine.");
        Label labelExecutable = new Label(composite, 0);
        labelExecutable.setText("NodeJS Interpreter:");
        this.m_typescriptPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                TypescriptPreferencesPage.this.m_interpreter = input;
                TypescriptPreferencesPage.this.setValid(TypescriptPreferencesPage.this.m_typescriptPathWidget.isValid());
                TypescriptPreferencesPage.this.updateButtonStates(inputModified);
            }
        }, this.getSettingsExtension().getNodeJSPathValidator(), 2, this.m_interpreter, true);
        this.m_typescriptPathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setValid(this.m_typescriptPathWidget.isValid());
        this.createButtonsPart(container, false);
        this.updateButtonStates(false);
        parent.layout();
        return container;
    }

    private void updateButtonStates(boolean inputModified) {
        boolean isModified = inputModified || this.isModified();
        this.getApplyButton().setEnabled(isModified && this.standardIsValid());
        this.getCancelButton().setEnabled(isModified);
    }

    public boolean isModified() {
        if (this.m_interpreter != null) {
            return !this.m_interpreter.getNormalizedAbsolutePath().equals(this.m_interpreterPath);
        }
        return this.m_interpreterPath != null;
    }

    public void reset() {
        this.initInterpreter();
    }

    private void initInterpreter() {
        TFile interpreterFile = this.getSettingsExtension().getNodeFile();
        if (interpreterFile == null) {
            this.m_interpreterPath = null;
            this.m_interpreter = null;
        } else {
            this.m_interpreterPath = interpreterFile.getNormalizedAbsolutePath();
            this.m_interpreter = interpreterFile.getNormalizedAbsoluteFile();
        }
    }

    protected ISettingsDelta getDelta() {
        return this;
    }

    protected final void cancel() {
        this.reset();
        this.m_typescriptPathWidget.reset();
    }

    protected void internPerformOk() {
        if (this.isModified() && this.standardIsValid()) {
            this.getSettingsExtension().setNodeFile(this.m_interpreter);
            this.updateButtonStates(false);
        }
    }

    protected OperationResult getOperationResult() {
        return null;
    }
}

