/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.python.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonPreferencesData;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonPreferencesInteraction;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonSystemPreferencesCommand;
import com.hello2morrow.sonargraph.languageprovider.python.foundation.common.PythonLanguage;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.python.dialog.PythonDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.io.File;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class PythonSystemPreferencesPage
extends StandardPreferencePage
implements ISettingsDelta {
    private TFile m_virtualEnvironmentFile = null;
    private String m_virtualEnvironmentDir = null;
    private ValidatingPathWidget m_venvWidget;
    private OperationResult m_result;
    private final IPythonVirtualEnvironmentValidator m_virtualEnvironmentValidator;
    private Button m_forceSkeletonRegeneration;
    private boolean m_skeletonRegeneration;

    public PythonSystemPreferencesPage() {
        TFile venvCfg;
        TFile venvDir;
        TFile interpreterDir;
        this.noDefaultAndApplyButton();
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        IPythonSettingsProvider settingsProvider = (IPythonSettingsProvider)provider.getInstallation().getExtension(IPythonSettingsProvider.class);
        this.m_virtualEnvironmentValidator = settingsProvider.getPythonVirtualEnvironmentPathValidator();
        String interpreterPath = settingsProvider.getSystemInterpreterPath(provider.getSoftwareSystem());
        if (interpreterPath != null && (interpreterDir = new TFile(interpreterPath).getParentFile()) != null && (venvDir = interpreterDir.getParentFile()) != null && (venvCfg = new TFile((File)venvDir, "pyvenv.cfg")).canRead()) {
            this.m_virtualEnvironmentFile = venvDir;
            this.m_virtualEnvironmentDir = venvDir.getNormalizedAbsolutePath();
        }
    }

    public Language getLanguage() {
        return PythonLanguage.INSTANCE;
    }

    protected Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Composite composite = new Composite(container, 1);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        explanation.setText("Locate the root directory of your project's virtual environment.");
        Label labelExecutable = new Label(composite, 0);
        labelExecutable.setText("Python Virtual Environment Root:");
        this.m_venvWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                PythonSystemPreferencesPage.this.m_virtualEnvironmentFile = input;
                PythonSystemPreferencesPage.this.setValid(PythonSystemPreferencesPage.this.m_venvWidget.isValid());
                PythonSystemPreferencesPage.this.updateButtonStates(inputModified);
            }
        }, (IPathValidator)this.m_virtualEnvironmentValidator, 2, this.m_virtualEnvironmentFile, true);
        this.m_venvWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setValid(this.m_venvWidget.isValid());
        this.m_forceSkeletonRegeneration = new Button(composite, 32);
        this.m_forceSkeletonRegeneration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_forceSkeletonRegeneration.setText("Force regeneration of skeletons");
        this.m_forceSkeletonRegeneration.setSelection(false);
        this.m_forceSkeletonRegeneration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PythonSystemPreferencesPage.this.m_skeletonRegeneration = PythonSystemPreferencesPage.this.m_forceSkeletonRegeneration.getSelection();
                PythonSystemPreferencesPage.this.setValid(PythonSystemPreferencesPage.this.m_venvWidget.isValid() && PythonSystemPreferencesPage.this.m_virtualEnvironmentFile != null);
                PythonSystemPreferencesPage.this.updateButtonStates(PythonSystemPreferencesPage.this.m_skeletonRegeneration);
            }
        });
        this.createButtonsPart(container, false);
        this.updateButtonStates(false);
        parent.layout();
        return container;
    }

    private void updateButtonStates(boolean inputModified) {
        boolean isModified = inputModified || this.isModified();
        this.getApplyButton().setEnabled(isModified && this.standardIsValid());
        this.getCancelButton().setEnabled(isModified);
    }

    public boolean isModified() {
        if (this.m_virtualEnvironmentFile != null) {
            return this.m_skeletonRegeneration || !this.m_virtualEnvironmentFile.getNormalizedAbsolutePath().equals(this.m_virtualEnvironmentDir);
        }
        return this.m_virtualEnvironmentDir != null;
    }

    protected ISettingsDelta getDelta() {
        return this;
    }

    protected OperationResult getOperationResult() {
        return this.m_result;
    }

    public void reset() {
        this.m_result = null;
        this.m_virtualEnvironmentFile = this.m_virtualEnvironmentDir != null && this.m_virtualEnvironmentDir.length() > 0 ? new TFile(this.m_virtualEnvironmentDir) : null;
        this.m_forceSkeletonRegeneration.setSelection(false);
        this.m_skeletonRegeneration = false;
    }

    protected void cancel() {
        this.reset();
        this.m_venvWidget.reset();
    }

    protected void internPerformOk() {
        if (this.isModified() && this.standardIsValid()) {
            UpdatePythonSystemPreferencesCommand command = new UpdatePythonSystemPreferencesCommand(WorkbenchRegistry.getInstance().getProvider(), (UpdatePythonPreferencesInteraction)new Interaction());
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            this.m_virtualEnvironmentDir = this.m_virtualEnvironmentFile == null ? null : this.m_virtualEnvironmentFile.getNormalizedAbsolutePath();
            this.updateButtonStates(false);
            this.m_skeletonRegeneration = false;
            this.m_forceSkeletonRegeneration.setSelection(false);
        }
    }

    public IDialogId getDialogId() {
        return PythonDialogId.PYTHON_INTERPRETER;
    }

    private class Interaction
    implements UpdatePythonPreferencesInteraction {
        private Interaction() {
        }

        public boolean collect(UpdatePythonPreferencesData data) {
            if (PythonSystemPreferencesPage.this.m_virtualEnvironmentValidator.getInterpreterFile() != null) {
                data.setInterpreterPath(PythonSystemPreferencesPage.this.m_virtualEnvironmentValidator.getInterpreterFile().getNormalizedAbsolutePath());
            } else {
                data.setInterpreterPath(null);
            }
            data.setForceSkeletonRegeneration(PythonSystemPreferencesPage.this.m_skeletonRegeneration);
            return true;
        }

        public void processUpdatePythonPreferencesResult(OperationResult result) {
            PythonSystemPreferencesPage.this.m_result = result;
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

