/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.python.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonPreferencesCommand;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonPreferencesData;
import com.hello2morrow.sonargraph.languageprovider.python.command.settings.UpdatePythonPreferencesInteraction;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.PythonInstallationSettings;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.python.dialog.PythonDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PythonPreferencesPage
extends StandardPreferencePage
implements ISettingsDelta {
    private ValidatingPathWidget m_pythonPathWidget;
    private TFile m_interpreter = null;
    private String m_interpreterPath;
    private OperationResult m_result;
    private Button m_forceSkeletonRegeneration;
    private boolean m_skeletonRegeneration;

    public PythonPreferencesPage() {
        this.noDefaultAndApplyButton();
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        PythonInstallationSettings settings = (PythonInstallationSettings)installation.getUniqueExistingChild(PythonInstallationSettings.class);
        this.m_interpreterPath = settings.getProperty(PythonInstallationSettings.PythonProperty.PYTHON_INTERPRETER);
        this.initInterpreter();
    }

    public IDialogId getDialogId() {
        return PythonDialogId.PYTHON_PREFERENCES;
    }

    protected boolean okToLeavePageWithErrors() {
        return true;
    }

    protected final Composite createPageContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Composite composite = new Composite(container, 1);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        explanation.setText("Locate the executable for the Python 3 interpreter on this machine.");
        Label labelExecutable = new Label(composite, 0);
        labelExecutable.setText("Python Interpreter:");
        IPythonSettingsProvider settingsProvider = (IPythonSettingsProvider)WorkbenchRegistry.getInstance().getInstallation().getExtension(IPythonSettingsProvider.class);
        this.m_pythonPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                PythonPreferencesPage.this.m_interpreter = input;
                PythonPreferencesPage.this.setValid(PythonPreferencesPage.this.m_pythonPathWidget.isValid());
                PythonPreferencesPage.this.updateButtonStates(inputModified);
            }
        }, settingsProvider.getPythonInterpreterPathValidator(), 2, this.m_interpreter, true);
        this.m_pythonPathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setValid(this.m_pythonPathWidget.isValid());
        this.m_forceSkeletonRegeneration = new Button(composite, 32);
        this.m_forceSkeletonRegeneration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_forceSkeletonRegeneration.setText("Force regeneration of skeletons");
        this.m_forceSkeletonRegeneration.setSelection(false);
        this.m_forceSkeletonRegeneration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PythonPreferencesPage.this.m_skeletonRegeneration = PythonPreferencesPage.this.m_forceSkeletonRegeneration.getSelection();
                PythonPreferencesPage.this.setValid(PythonPreferencesPage.this.m_pythonPathWidget.isValid() && PythonPreferencesPage.this.m_interpreter != null);
                PythonPreferencesPage.this.updateButtonStates(PythonPreferencesPage.this.m_skeletonRegeneration);
            }
        });
        this.createButtonsPart(container, false);
        this.updateButtonStates(false);
        parent.layout();
        return container;
    }

    private void updateButtonStates(boolean inputModified) {
        boolean isModified = inputModified || this.isModified();
        this.getApplyButton().setEnabled(isModified && this.standardIsValid());
        this.getCancelButton().setEnabled(isModified);
    }

    public boolean isModified() {
        if (this.m_interpreter != null) {
            return this.m_skeletonRegeneration || !this.m_interpreter.getNormalizedAbsolutePath().equals(this.m_interpreterPath);
        }
        return this.m_interpreterPath != null;
    }

    public void reset() {
        this.initInterpreter();
        this.m_forceSkeletonRegeneration.setSelection(false);
        this.m_skeletonRegeneration = false;
    }

    private void initInterpreter() {
        this.m_result = null;
        if (this.m_interpreterPath != null && this.m_interpreterPath.length() > 0) {
            this.m_interpreter = new TFile(this.m_interpreterPath);
        } else {
            this.m_interpreterPath = null;
        }
    }

    protected OperationResult getOperationResult() {
        return this.m_result;
    }

    protected ISettingsDelta getDelta() {
        return this;
    }

    protected final void cancel() {
        this.reset();
        this.m_pythonPathWidget.reset();
    }

    protected void internPerformOk() {
        if (this.isModified() && this.standardIsValid()) {
            UpdatePythonPreferencesCommand command = new UpdatePythonPreferencesCommand(WorkbenchRegistry.getInstance().getProvider(), (UpdatePythonPreferencesInteraction)new Interaction());
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command);
            this.m_interpreterPath = this.m_interpreter == null ? null : this.m_interpreter.getNormalizedAbsolutePath();
            this.updateButtonStates(false);
            this.m_skeletonRegeneration = false;
            this.m_forceSkeletonRegeneration.setSelection(false);
        }
    }

    protected class Interaction
    implements UpdatePythonPreferencesInteraction {
        protected Interaction() {
        }

        public boolean collect(UpdatePythonPreferencesData data) {
            if (PythonPreferencesPage.this.m_interpreter != null) {
                data.setInterpreterPath(PythonPreferencesPage.this.m_interpreter.getNormalizedAbsolutePath());
            } else {
                data.setInterpreterPath(null);
            }
            data.setForceSkeletonRegeneration(PythonPreferencesPage.this.m_skeletonRegeneration);
            return true;
        }

        public void processUpdatePythonPreferencesResult(OperationResult result) {
            PythonPreferencesPage.this.m_result = result;
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

