/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.python.wizards;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.python.command.system.CreatePythonSystemCommand;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonSettingsProvider;
import com.hello2morrow.sonargraph.languageprovider.python.model.settings.IPythonVirtualEnvironmentValidator;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class PythonSystemConfigPage
extends StandardWizardPage {
    private final IDirectoryProvider m_dirProvider;
    private ValidatingPathWidget m_validatingPathWidget;
    private TFile m_selectedRootDirectory;
    private TFile m_virtualEnvironmentFile;
    private ValidatingPathWidget m_venvWidget;
    private Button m_forceSkeletonRegeneration;
    private IPythonVirtualEnvironmentValidator m_validator;
    private boolean m_skeletonRegeneration;

    public PythonSystemConfigPage(String pageName, IDirectoryProvider dirProvider) {
        super(pageName, "Select Root Directory and Environment");
        assert (dirProvider != null) : "Parameter 'dirProvider' of method 'PythonSystemConfigPage' must not be null";
        this.m_dirProvider = dirProvider;
    }

    protected void createContent(Composite composite) {
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Root directory:");
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                PythonSystemConfigPage.this.m_selectedRootDirectory = input;
                PythonSystemConfigPage.this.validate();
            }
        }, new IPathValidator(){

            public IPathValidator.PathType getType() {
                return IPathValidator.PathType.DIRECTORY;
            }

            public ValidationResult isValid(TFile currentInput, TFile newInput) {
                ValidationResult result = new ValidationResult(!FileUtility.areEqual((TFile)currentInput, (TFile)newInput));
                if (newInput == null || newInput.getPath().isEmpty()) {
                    result.addError("Must not be empty");
                } else if (!newInput.isDirectory()) {
                    result.addError("Not a directory");
                }
                return result;
            }
        }, 2, null, true, this.m_dirProvider.getDirectory());
        this.m_validatingPathWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_validatingPathWidget.getBrowseButton().setFocus();
        IPythonSettingsProvider settingsProvider = (IPythonSettingsProvider)WorkbenchRegistry.getInstance().getProvider().getInstallation().getExtension(IPythonSettingsProvider.class);
        this.m_validator = settingsProvider.getPythonVirtualEnvironmentPathValidator();
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        explanation.setText("Locate the root directory of your project's virtual environment (optional).");
        Label labelExecutable = new Label(composite, 0);
        labelExecutable.setText("Virtual Environment Root:");
        this.m_venvWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                PythonSystemConfigPage.this.m_virtualEnvironmentFile = input;
            }
        }, (IPathValidator)this.m_validator, 2, this.m_virtualEnvironmentFile, true, this.m_dirProvider.getDirectory());
        this.m_venvWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_forceSkeletonRegeneration = new Button(composite, 32);
        this.m_forceSkeletonRegeneration.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_forceSkeletonRegeneration.setText("Force regeneration of skeletons");
        this.m_forceSkeletonRegeneration.setSelection(false);
        this.m_forceSkeletonRegeneration.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PythonSystemConfigPage.this.m_skeletonRegeneration = PythonSystemConfigPage.this.m_forceSkeletonRegeneration.getSelection();
            }
        });
    }

    private void validate() {
        this.setPageComplete(this.m_selectedRootDirectory != null);
    }

    public boolean isPageComplete() {
        if (!super.isPageComplete()) {
            return false;
        }
        return this.m_selectedRootDirectory != null && this.m_selectedRootDirectory.isDirectory();
    }

    public boolean collectSystemData(CreatePythonSystemCommand.PythonSystemData configData) {
        configData.setRootDirectory(this.m_selectedRootDirectory);
        if (this.m_virtualEnvironmentFile != null) {
            configData.setInterpreterPath(this.m_validator.getInterpreterFile());
            configData.setForceSkeletonGeneration(this.m_skeletonRegeneration);
        }
        return true;
    }

    protected final int getNumberOfColumns() {
        return 2;
    }
}

