/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportModuleCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportRootDirectoryPathCandidateUINode;
import org.eclipse.jface.viewers.DecoratingStyledCellLabelProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;

final class ViewDecoratingStyledCellLabelProvider
extends DecoratingStyledCellLabelProvider {
    ViewDecoratingStyledCellLabelProvider(DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider) {
        super(labelProvider, null, null);
    }

    public String getToolTipText(Object element) {
        if (element instanceof ImportModuleCandidateUINode) {
            ImportModuleCandidateUINode moduleCandidateNode = (ImportModuleCandidateUINode)((Object)element);
            ImportModuleCandidate moduleCandidate = (ImportModuleCandidate)moduleCandidateNode.getImportCandidate();
            StringBuilder sb = new StringBuilder();
            if (moduleCandidate.isAlreadyInWorkspace()) {
                sb.append("Module already exists in workspace.");
            }
            if (moduleCandidate.getError() != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(moduleCandidate.getError());
            }
            if (moduleCandidate.getWarning() != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(moduleCandidate.getWarning());
            }
            if (moduleCandidateNode.hasBrokenDependency()) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append("Module has a dependency to an element not present in workspace.");
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(moduleCandidate.getFile().getAbsolutePath());
            return sb.toString();
        }
        if (element instanceof ImportRootDirectoryPathCandidateUINode) {
            ImportRootDirectoryPathCandidateUINode rootDirectoryPathCandidateNode = (ImportRootDirectoryPathCandidateUINode)((Object)element);
            ImportRootDirectoryPathCandidate rootDirectoryPathCandidate = (ImportRootDirectoryPathCandidate)rootDirectoryPathCandidateNode.getImportCandidate();
            StringBuilder sb = new StringBuilder();
            if (rootDirectoryPathCandidate.isAlreadyInWorkspace()) {
                sb.append("Root directory path already exists in workspace.");
            } else if (!rootDirectoryPathCandidate.hasContent()) {
                sb.append("Root directory path is either non-existent or does not contain relevant information.");
            }
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(rootDirectoryPathCandidate.getFile().getAbsolutePath());
            return sb.toString();
        }
        return null;
    }
}

