/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportModuleCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportRootDirectoryPathCandidateUINode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

final class WorkspaceImportUiModel {
    private final List<ImportCandidateUINode<? extends ImportCandidate>> m_rootElements;

    WorkspaceImportUiModel(Set<ImportModuleCandidate> moduleCandidates) {
        assert (moduleCandidates != null) : "Parameter 'moduleCandidates' of method 'ExternalImportUiModel' must not be null";
        this.m_rootElements = new ArrayList<ImportCandidateUINode<? extends ImportCandidate>>(moduleCandidates.size());
        for (ImportModuleCandidate nextModuleCandidate : moduleCandidates) {
            ImportModuleCandidateUINode nextModuleNode = new ImportModuleCandidateUINode(nextModuleCandidate);
            this.m_rootElements.add(nextModuleNode);
            for (ImportRootDirectoryPathCandidate nextRootPathCandidate : nextModuleCandidate.getRootPaths()) {
                nextModuleNode.addChild((TreeNode)new ImportRootDirectoryPathCandidateUINode(nextRootPathCandidate, nextModuleCandidate.getModulePath()));
            }
        }
        Collections.sort(this.m_rootElements, new Comparator<ImportCandidateUINode<? extends ImportCandidate>>(){

            @Override
            public int compare(ImportCandidateUINode<? extends ImportCandidate> candidate1, ImportCandidateUINode<? extends ImportCandidate> candidate2) {
                if (!$assertionsDisabled && candidate1 == null) {
                    throw new AssertionError((Object)"Parameter 'candidate1' of method 'compare' must not be null");
                }
                if (!$assertionsDisabled && candidate2 == null) {
                    throw new AssertionError((Object)"Parameter 'candidate2' of method 'compare' must not be null");
                }
                return candidate1.getName().compareTo(candidate2.getName());
            }
        });
    }

    public List<ImportCandidateUINode<? extends ImportCandidate>> getRootElements() {
        return Collections.unmodifiableList(this.m_rootElements);
    }
}

