/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaWorkspaceProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class SourceRootDirectoryPathWizardPage
extends StandardWizardPage {
    static final String NAME = "Java Source Root Directory/Archive Page";
    private final Module m_selectedMdule;
    private TFile m_selectedDirectory;
    private ValidatingPathWidget m_validatingPathWidget;

    SourceRootDirectoryPathWizardPage(Module module) {
        super(NAME);
        assert (module != null) : "Parameter 'module' of method 'RootDirectoryPathWizardPage' must not be null";
        this.setTitle("New Java source root directory/archive in " + module.getLanguage().getPresentationName() + " module: '" + module.getName() + "'");
        this.m_selectedMdule = module;
        this.setPageComplete(false);
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        assert (WorkbenchRegistry.getInstance().getProvider().hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = WorkbenchRegistry.getInstance().getProvider().getSoftwareSystem();
        Label nameLabel = new Label(composite, 0);
        nameLabel.setText("Directory/Archive:");
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                SourceRootDirectoryPathWizardPage.this.m_selectedDirectory = input;
                SourceRootDirectoryPathWizardPage.this.validate();
            }
        }, ((IJavaWorkspaceProvider)softwareSystem.getExtension(IJavaWorkspaceProvider.class)).getSourceRootDirectoryPathValidator(), 2, null, true, softwareSystem.getDirectoryFile());
        this.m_validatingPathWidget.setLayoutData((Object)new GridData(4, 0, true, false));
        this.m_validatingPathWidget.getBrowseButton().setFocus();
        this.validate();
    }

    private void validate() {
        this.setPageComplete(this.m_selectedDirectory != null);
    }

    Module getSelectedModule() {
        assert (this.m_selectedMdule != null) : "'m_selectedMdule' of method 'getSelectedModule' must not be null";
        return this.m_selectedMdule;
    }

    TFile getSelectedDirectory() {
        assert (this.m_selectedDirectory != null) : "'m_selectedDirectory' of method 'getSelectedDirectory' must not be null";
        return this.m_selectedDirectory;
    }

    protected final int getNumberOfColumns() {
        return 2;
    }
}

