/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelData;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelDirectoryPerBuildFileCommand;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.IDetectFromBazelInteraction;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.bazel.IBazelImportProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.NewJavaModulesFromBazelPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class NewJavaModulesFromBazelBuildFileWizardLoadModulesPage
extends NewJavaModulesFromBazelPage {
    private ValidatingPathWidget m_textFieldBuildFilePath;
    private IPathValidator m_buildFileValidator;
    private Composite m_options;
    private Group m_classOptions;
    private Group m_sourceOptions;
    private Button m_includeTestCheckbox;
    private boolean m_includeTest = true;
    private IBazelImportProvider.RootMode m_classMode;
    private IBazelImportProvider.RootMode m_sourceMode;
    private GridLayout m_optionsLayoutVisible;

    NewJavaModulesFromBazelBuildFileWizardLoadModulesPage(String pageName, String description, boolean isCreation) {
        super(pageName, description, isCreation);
    }

    @Override
    protected IDialogId getDialogId() {
        return JavaDialogId.IMPORT_MODULE_JAVA_BAZEL_BUILD_FILE_WIZARD_PAGE;
    }

    @Override
    protected void addSpecificContent(Composite parent) {
        this.m_optionsLayoutVisible = new GridLayout();
        this.m_optionsLayoutVisible.numColumns = 2;
        this.m_optionsLayoutVisible.marginLeft = 20;
        this.m_optionsLayoutVisible.horizontalSpacing = 20;
        ISoftwareSystemProvider m_softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        this.m_buildFileValidator = ((IBazelImportProvider)m_softwareSystemProvider.getInstallation().getExtension(IBazelImportProvider.class)).getBuildfileValidator();
        this.m_textFieldBuildFilePath = new ValidatingPathWidget(parent, (ValidatingPathWidget.IConsumer)this, this.m_buildFileValidator, 2, null, true);
        this.m_textFieldBuildFilePath.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_options = new Composite(parent, 0);
        this.m_options.setLayout((Layout)this.m_optionsLayoutVisible);
        this.m_classOptions = this.createOptionGroup(this.m_options, "Import Class Files From", this::setClassMode);
        this.m_classOptions.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.m_sourceOptions = this.createOptionGroup(this.m_options, "Import Source Files From", this::setSourceMode);
        this.m_sourceOptions.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_includeTestCheckbox = new Button(parent, 32);
        this.m_includeTestCheckbox.setText("Include test rules");
        this.m_includeTestCheckbox.setSelection(this.m_includeTest);
        this.m_includeTestCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_includeTestCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.m_includeTest = NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.m_includeTestCheckbox.getSelection();
            }
        });
    }

    private Group createOptionGroup(Composite parent, String caption, final Function<IBazelImportProvider.RootMode, Void> memberToSet) {
        Group options = new Group(parent, 32);
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 1;
        optionsLayout.horizontalSpacing = 20;
        options.setLayout((Layout)optionsLayout);
        options.setText(caption);
        final Button outputJar = new Button((Composite)options, 16);
        outputJar.setText("Output Jar");
        outputJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (outputJar.getSelection()) {
                    memberToSet.apply(IBazelImportProvider.RootMode.OUTPUT_JAR);
                }
            }
        });
        outputJar.setSelection(true);
        memberToSet.apply(IBazelImportProvider.RootMode.OUTPUT_JAR);
        final Button directory = new Button((Composite)options, 16);
        directory.setText("Directory");
        directory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (directory.getSelection()) {
                    memberToSet.apply(IBazelImportProvider.RootMode.DIRECTORY);
                }
            }
        });
        return options;
    }

    private Void setClassMode(IBazelImportProvider.RootMode mode) {
        this.m_classMode = mode;
        return null;
    }

    private Void setSourceMode(IBazelImportProvider.RootMode mode) {
        this.m_sourceMode = mode;
        return null;
    }

    @Override
    protected boolean isValidInput(TFile input) {
        boolean valid = this.m_buildFileValidator.isValid(null, input).isSuccess();
        this.enableDetection(valid);
        return valid;
    }

    private boolean isIncludeTest() {
        return this.m_includeTest;
    }

    @Override
    protected void detectModuleCandidates(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectModuleCandidates' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        CommandResultConsumer consumer = new CommandResultConsumer(){

            public void consume(CommandException exception) {
            }
        };
        IDetectFromBazelInteraction interaction = new IDetectFromBazelInteraction(){

            public void processDetectModulesResult(OperationResultWithOutcome<Set<ImportModuleCandidate>> detected) {
                NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.showResult(detected);
            }

            public boolean collect(DetectFromBazelData data) {
                data.setBuildFiles(Arrays.asList(NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.m_textFieldBuildFilePath.getCurrentFile()));
                data.setClassRootMode(NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.m_classMode);
                data.setSourceRootMode(NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.m_sourceMode);
                data.setNamingMode(IBazelImportProvider.NamingMode.SHORT);
                data.setIncludeTest(NewJavaModulesFromBazelBuildFileWizardLoadModulesPage.this.isIncludeTest());
                return true;
            }
        };
        DetectFromBazelDirectoryPerBuildFileCommand command = new DetectFromBazelDirectoryPerBuildFileCommand(softwareSystemProvider, interaction);
        command.run(workerContext, consumer);
    }
}

