/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.element.NamedElement;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaClassRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSourceRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaModule;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.RootDirectoryPathsModification;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.AvailableModulesNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.AvailableRootDirectoryPathsNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.DetectedRootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ExistingRootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaModuleNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.RootDirectoryPathNode;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ManageRootDirectoryPathsModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageRootDirectoryPathsModel.class);
    private final List<DetectedRootDirectoryPathNode> m_detectedAvailableRootDirectoryPathNodes = new ArrayList<DetectedRootDirectoryPathNode>();
    private final List<ExistingRootDirectoryPathNode> m_existingAvailableRootDirectoryPathNodes = new ArrayList<ExistingRootDirectoryPathNode>();
    private final List<JavaModuleNode> m_existingModulNodes = new ArrayList<JavaModuleNode>();
    private final SoftwareSystem m_softwareSystem;
    private final AvailableRootDirectoryPathsNode m_availableRootDirectoryPathsNode;
    private final AvailableModulesNode m_availableModulesNode;
    private final List<UiTreeNode> m_rootElements;

    ManageRootDirectoryPathsModel(SoftwareSystem softwareSystem) {
        assert (softwareSystem != null) : "Parameter 'softwareSystem' of method 'DetectRootDirectoryPathsModel' must not be null";
        this.m_softwareSystem = softwareSystem;
        this.m_availableRootDirectoryPathsNode = new AvailableRootDirectoryPathsNode();
        this.m_availableModulesNode = new AvailableModulesNode();
        this.m_rootElements = new ArrayList<UiTreeNode>(2);
        this.m_rootElements.add(this.m_availableModulesNode);
        this.m_rootElements.add(this.m_availableRootDirectoryPathsNode);
        for (JavaModule nextModule : ((Workspace)this.m_softwareSystem.getUniqueExistingChild(Workspace.class)).getChildren(JavaModule.class)) {
            JavaModuleNode nextModuleNode = new JavaModuleNode(nextModule);
            this.m_existingModulNodes.add(nextModuleNode);
            this.m_availableModulesNode.addChild((TreeNode)nextModuleNode);
            for (RootDirectoryPath nextRoot : nextModule.getChildren(RootDirectoryPath.class)) {
                ExistingRootDirectoryPathNode node = new ExistingRootDirectoryPathNode(nextRoot);
                nextModuleNode.addChild((TreeNode)node);
                assert (!this.m_existingAvailableRootDirectoryPathNodes.contains((Object)node)) : "Already added: " + String.valueOf((Object)node);
                this.m_existingAvailableRootDirectoryPathNodes.add(node);
            }
        }
    }

    void reset() {
        RootDirectoryPathNode next;
        Iterator<RootDirectoryPathNode> iterator = this.m_existingAvailableRootDirectoryPathNodes.iterator();
        while (iterator.hasNext()) {
            next = iterator.next();
            if (next.getParent() != this.m_availableRootDirectoryPathsNode) continue;
            next.remove();
            iterator.remove();
        }
        iterator = this.m_detectedAvailableRootDirectoryPathNodes.iterator();
        while (iterator.hasNext()) {
            next = (DetectedRootDirectoryPathNode)iterator.next();
            if (next.getParent() != this.m_availableRootDirectoryPathsNode) continue;
            next.remove();
            iterator.remove();
        }
    }

    boolean isAlreadyClassRootDirectory(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isAlreadyClassRootDirectory' must not be null";
        assert (!file.isFile()) : "Not an archive or directory: " + String.valueOf(file);
        for (ExistingRootDirectoryPathNode existingRootDirectoryPathNode : this.m_existingAvailableRootDirectoryPathNodes) {
            if (!(existingRootDirectoryPathNode.getRootDirectoryPath() instanceof JavaClassRootDirectoryPath) || !FileUtility.areEqual((TFile)file, (TFile)existingRootDirectoryPathNode.getRootDirectoryPath().getFile())) continue;
            return true;
        }
        for (DetectedRootDirectoryPathNode detectedRootDirectoryPathNode : this.m_detectedAvailableRootDirectoryPathNodes) {
            if (!detectedRootDirectoryPathNode.isClassRootDirectory() || !FileUtility.areEqual((TFile)file, (TFile)detectedRootDirectoryPathNode.getDetectedRootDirectoryPath().getDirectory())) continue;
            return true;
        }
        return false;
    }

    boolean isAlreadySourceRootDirectory(TFile file) {
        assert (file != null) : "Parameter 'file' of method 'isAlreadySourceRootDirectory' must not be null";
        assert (!file.isFile()) : "Not an archive or directory: " + String.valueOf(file);
        for (ExistingRootDirectoryPathNode existingRootDirectoryPathNode : this.m_existingAvailableRootDirectoryPathNodes) {
            if (!(existingRootDirectoryPathNode.getRootDirectoryPath() instanceof JavaSourceRootDirectoryPath) || !FileUtility.areEqual((TFile)file, (TFile)existingRootDirectoryPathNode.getRootDirectoryPath().getFile())) continue;
            return true;
        }
        for (DetectedRootDirectoryPathNode detectedRootDirectoryPathNode : this.m_detectedAvailableRootDirectoryPathNodes) {
            if (!detectedRootDirectoryPathNode.isSourceRootDirectory() || !FileUtility.areEqual((TFile)file, (TFile)detectedRootDirectoryPathNode.getDetectedRootDirectoryPath().getDirectory())) continue;
            return true;
        }
        return false;
    }

    List<UiTreeNode> getRootElements() {
        return Collections.unmodifiableList(this.m_rootElements);
    }

    AvailableModulesNode getAvailableModules() {
        return this.m_availableModulesNode;
    }

    AvailableRootDirectoryPathsNode getAvailableRootDirectoryPaths() {
        return this.m_availableRootDirectoryPathsNode;
    }

    void add(DetectedRootDirectoryPath root) {
        assert (root != null) : "Parameter 'root' of method 'add' must not be null";
        Module module = root.getModule();
        if (module == null) {
            DetectedRootDirectoryPathNode node = new DetectedRootDirectoryPathNode(FileUtility.calculateRelativePath((TFile)root.getDirectory(), (TFile)this.m_softwareSystem.getDirectoryFile()), root);
            this.m_availableRootDirectoryPathsNode.addChild((TreeNode)node);
            assert (!this.m_detectedAvailableRootDirectoryPathNodes.contains((Object)node)) : "Already added: " + String.valueOf((Object)node);
            this.m_detectedAvailableRootDirectoryPathNodes.add(node);
        } else {
            for (RootDirectoryPath nextRoot : module.getChildren(RootDirectoryPath.class)) {
                if (!FileUtility.areEqual((TFile)nextRoot.getFile(), (TFile)root.getDirectory())) continue;
                ExistingRootDirectoryPathNode node = new ExistingRootDirectoryPathNode(nextRoot);
                assert (!this.m_existingAvailableRootDirectoryPathNodes.contains((Object)node)) : "Already added: " + String.valueOf((Object)node);
                this.m_existingAvailableRootDirectoryPathNodes.add(node);
                this.m_availableRootDirectoryPathsNode.addChild((TreeNode)node);
                break;
            }
        }
    }

    void move(JavaModuleNode moduleNode, AvailableModulesNode availableModulesNode, int pos) {
        assert (moduleNode != null) : "Parameter 'moduleNode' of method 'move' must not be null";
        assert (availableModulesNode != null) : "Parameter 'availableModulesNode' of method 'move' must not be null";
        availableModulesNode.addChild((TreeNode)moduleNode, pos);
    }

    void assign(RootDirectoryPathNode rootNode, JavaModuleNode moduleNode, int pos) {
        assert (rootNode != null) : "Parameter 'rootNode' of method 'move' must not be null";
        assert (moduleNode != null) : "Parameter 'moduleNode' of method 'move' must not be null";
        moduleNode.addChild((TreeNode)rootNode, pos);
    }

    public void unassign(RootDirectoryPathNode rootNode) {
        assert (rootNode != null) : "Parameter 'rootNode' of method 'unassign' must not be null";
        assert (rootNode.getParent() != null && rootNode.getParent() != this.m_availableRootDirectoryPathsNode) : "Already unassigned: " + String.valueOf((Object)rootNode);
        this.m_availableRootDirectoryPathsNode.addChild((TreeNode)rootNode);
    }

    public int getNumberOfAvailableRootPaths() {
        return this.m_availableRootDirectoryPathsNode.getNumberOfChildren();
    }

    public UiTreeNode getAvailableRootDirectoryPathsNode() {
        return this.m_availableRootDirectoryPathsNode;
    }

    private boolean detectModification(RootDirectoryPathsModification modification) {
        for (JavaModuleNode javaModuleNode : this.m_existingModulNodes) {
            if (this.m_availableModulesNode.getIndexOf((TreeNode)javaModuleNode) == ((Workspace)javaModuleNode.getModule().getParent(Workspace.class, new Class[0])).getIndexOf(Module.class, (NamedElement)javaModuleNode.getModule())) continue;
            if (modification != null) {
                modification.moved(javaModuleNode.getModule(), this.m_availableModulesNode.getIndexOf((TreeNode)javaModuleNode));
                continue;
            }
            return true;
        }
        for (DetectedRootDirectoryPathNode detectedRootDirectoryPathNode : this.m_detectedAvailableRootDirectoryPathNodes) {
            if (detectedRootDirectoryPathNode.getParent() == this.m_availableRootDirectoryPathsNode) continue;
            if (modification != null) {
                modification.assigned(detectedRootDirectoryPathNode.getDetectedRootDirectoryPath(), ((JavaModuleNode)detectedRootDirectoryPathNode.getParent()).getModule(), ((JavaModuleNode)detectedRootDirectoryPathNode.getParent()).getIndexOf((TreeNode)detectedRootDirectoryPathNode));
                continue;
            }
            return true;
        }
        for (ExistingRootDirectoryPathNode existingRootDirectoryPathNode : this.m_existingAvailableRootDirectoryPathNodes) {
            if (existingRootDirectoryPathNode.getParent() == this.m_availableRootDirectoryPathsNode) {
                if (modification != null) {
                    modification.unassigned(existingRootDirectoryPathNode.getRootDirectoryPath());
                    continue;
                }
                return true;
            }
            Module nextAssignedToModule = (Module)existingRootDirectoryPathNode.getRootDirectoryPath().getParent(Module.class, new Class[0]);
            if (nextAssignedToModule != null) {
                UiTreeNode treeNode = (UiTreeNode)existingRootDirectoryPathNode.getParent();
                assert (treeNode instanceof JavaModuleNode) : "Not a module node: " + String.valueOf(treeNode);
                JavaModuleNode moduleNode = (JavaModuleNode)treeNode;
                if (moduleNode.getModule() == nextAssignedToModule && nextAssignedToModule.getChildren().contains(existingRootDirectoryPathNode.getRootDirectoryPath()) && moduleNode.getIndexOf((TreeNode)existingRootDirectoryPathNode) == nextAssignedToModule.getIndexOf(RootDirectoryPath.class, (NamedElement)existingRootDirectoryPathNode.getRootDirectoryPath())) continue;
                if (modification != null) {
                    modification.assignmentChanged(existingRootDirectoryPathNode.getRootDirectoryPath(), ((JavaModuleNode)existingRootDirectoryPathNode.getParent()).getModule(), ((UiTreeNode)existingRootDirectoryPathNode.getParent()).getIndexOf((TreeNode)existingRootDirectoryPathNode));
                    continue;
                }
                return true;
            }
            LOGGER.warn("Existing root directory path no longer contained in module: " + String.valueOf(existingRootDirectoryPathNode.getRootDirectoryPath()));
        }
        return modification != null && !modification.isEmpty();
    }

    RootDirectoryPathsModification getModification() {
        RootDirectoryPathsModification modification = new RootDirectoryPathsModification(this.m_softwareSystem);
        this.detectModification(modification);
        assert (!modification.isEmpty()) : "'modification' of method 'getModification' must not be empty";
        return modification;
    }

    boolean rootPathsModified() {
        return this.detectModification(null);
    }
}

