/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.modulith;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.ITextValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.model.path.CoreFileType;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.ISpringModulithProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextOrComboWidget;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingTextWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.CustomCheckbox;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class ModulithWizardPage
extends StandardWizardPage {
    private TFile m_selectedFile;
    private String m_name;
    private boolean m_addToArchitectureCheck;

    public ModulithWizardPage(String pageName) {
        super(pageName, "Create Spring-Modulith based Architecture");
    }

    private void updateStatus() {
        this.setPageComplete(this.m_selectedFile != null && this.m_name != null && !this.m_name.isEmpty());
    }

    protected void createContent(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Select the application-modules.json file (Spring-Modulith 1.4.2 or higher)");
        label.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        ValidatingPathWidget pathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    ModulithWizardPage.this.m_selectedFile = input.getNormalizedFile();
                    ModulithWizardPage.this.updateStatus();
                }
            }
        }, (IPathValidator)new StandardFilePathValidator((IFileType)CoreFileType.JSON), 5, null, false);
        pathWidget.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        label = new Label(composite, 0);
        label.setText("Choose a name for the architecture file to be generated");
        label.setLayoutData((Object)new GridData(1, 2, false, false, 2, 1));
        ITextValidator validator = ((ISpringModulithProvider)WorkbenchRegistry.getInstance().getSoftwareSystem().getExtension(ISpringModulithProvider.class)).getArchitectureNameValidator();
        ValidatingTextWidget validatingNameTextWidget = new ValidatingTextWidget(composite, validator, new ValidatingTextOrComboWidget.IConsumer(){

            public void setText(ValidatingTextOrComboWidget source, String text, boolean inputModified) {
                ModulithWizardPage.this.m_name = text;
                ModulithWizardPage.this.updateStatus();
            }
        }, "", 0);
        validatingNameTextWidget.setLayoutData((Object)new GridData(4, 2, true, false, 2, 1));
        CustomCheckbox architectureCheck = new CustomCheckbox(composite, "Add to architecture check", false, b -> {
            boolean bl = this.m_addToArchitectureCheck = b.booleanValue();
        });
        architectureCheck.setSelection(this.m_addToArchitectureCheck);
        this.setPageComplete(false);
    }

    TFile getSelectedFile() {
        return this.m_selectedFile;
    }

    String getArchitectureFileName() {
        return this.m_name;
    }

    boolean getAddToArchitectureCheck() {
        return this.m_addToArchitectureCheck;
    }
}

