/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.command.common.CommandException;
import com.hello2morrow.sonargraph.core.command.common.CommandResultConsumer;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelData;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelWorkspacePerBuildFileCommand;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelWorkspacePerRuleCommand;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.DetectFromBazelWorkspacePerWorkspaceCommand;
import com.hello2morrow.sonargraph.languageprovider.java.command.system.IDetectFromBazelInteraction;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.bazel.IBazelImportProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.NewJavaModulesFromBazelPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Set;
import java.util.function.Function;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

final class NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage
extends NewJavaModulesFromBazelPage {
    private ValidatingPathWidget m_textFieldWorkspacePath;
    private IPathValidator m_workspaceValidator;
    private Button m_multiModuleFromRulesImportRadioButton;
    private Button m_multiModuleFromBuildFilesImportRadioButton;
    private Button m_singleModuleImportRadioButton;
    private Composite m_options;
    private Group m_classOptions;
    private Group m_sourceOptions;
    private Button m_includeTestCheckbox;
    private boolean m_includeTest = true;
    private IBazelImportProvider.RootMode m_classMode;
    private IBazelImportProvider.RootMode m_sourceMode;
    private GridLayout m_optionsLayoutVisible;
    private GridLayout m_optionsLayoutInvisible;

    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage(String pageName, String description, boolean isCreation) {
        super(pageName, description, isCreation);
    }

    @Override
    protected IDialogId getDialogId() {
        return JavaDialogId.IMPORT_MODULE_JAVA_BAZEL_WORKSPACE_WIZARD_PAGE;
    }

    @Override
    protected void addSpecificContent(final Composite parent) {
        this.m_optionsLayoutVisible = new GridLayout();
        this.m_optionsLayoutVisible.numColumns = 2;
        this.m_optionsLayoutVisible.marginLeft = 20;
        this.m_optionsLayoutVisible.horizontalSpacing = 20;
        this.m_optionsLayoutInvisible = new GridLayout();
        this.m_optionsLayoutInvisible.numColumns = 0;
        ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        this.m_workspaceValidator = ((IBazelImportProvider)softwareSystemProvider.getInstallation().getExtension(IBazelImportProvider.class)).getWorkspaceValidator();
        this.m_textFieldWorkspacePath = new ValidatingPathWidget(parent, (ValidatingPathWidget.IConsumer)this, this.m_workspaceValidator, 2, null, true);
        this.m_textFieldWorkspacePath.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_multiModuleFromBuildFilesImportRadioButton = new Button(parent, 16);
        this.m_multiModuleFromBuildFilesImportRadioButton.setText("Import multiple Sonargraph modules from Bazel build files");
        this.m_multiModuleFromBuildFilesImportRadioButton.setToolTipText("Every Bazel build file found in Bazel workspace will result in a Sonargraph module");
        this.m_multiModuleFromBuildFilesImportRadioButton.setSelection(true);
        this.m_multiModuleFromBuildFilesImportRadioButton.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_multiModuleFromBuildFilesImportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_multiModuleFromBuildFilesImportRadioButton.getSelection()) {
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_options.moveBelow((Control)NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_multiModuleFromBuildFilesImportRadioButton);
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.enableOptions(true);
                    parent.layout();
                }
            }
        });
        this.m_options = new Composite(parent, 0);
        this.m_options.setLayout((Layout)this.m_optionsLayoutVisible);
        this.m_classOptions = this.createOptionGroup(this.m_options, "Import Class Files From", this::setClassMode);
        this.m_classOptions.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.m_sourceOptions = this.createOptionGroup(this.m_options, "Import Source Files From", this::setSourceMode);
        this.m_sourceOptions.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
        this.m_multiModuleFromRulesImportRadioButton = new Button(parent, 16);
        this.m_multiModuleFromRulesImportRadioButton.setText("Import multiple Sonargraph modules from Bazel rules");
        this.m_multiModuleFromRulesImportRadioButton.setToolTipText("Every Bazel rule found in Bazel workspace will result in a Sonargraph module");
        this.m_multiModuleFromRulesImportRadioButton.setSelection(false);
        this.m_multiModuleFromRulesImportRadioButton.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_multiModuleFromRulesImportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_multiModuleFromRulesImportRadioButton.getSelection()) {
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_options.moveBelow((Control)NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_multiModuleFromRulesImportRadioButton);
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.enableOptions(true);
                    parent.layout();
                }
            }
        });
        this.m_singleModuleImportRadioButton = new Button(parent, 16);
        this.m_singleModuleImportRadioButton.setText("Import single Sonargraph module from Bazel workspace");
        this.m_singleModuleImportRadioButton.setToolTipText("The whole Bazel workspace will result in a single Sonargraph module");
        this.m_singleModuleImportRadioButton.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_singleModuleImportRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_singleModuleImportRadioButton.getSelection()) {
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_options.moveBelow((Control)NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_singleModuleImportRadioButton);
                    NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.enableOptions(false);
                    parent.layout();
                }
            }
        });
        Label separator = new Label(parent, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_includeTestCheckbox = new Button(parent, 32);
        this.m_includeTestCheckbox.setText("Include test rules");
        this.m_includeTestCheckbox.setSelection(this.m_includeTest);
        this.m_includeTestCheckbox.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_includeTestCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_includeTest = NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_includeTestCheckbox.getSelection();
            }
        });
    }

    private Group createOptionGroup(Composite parent, String caption, final Function<IBazelImportProvider.RootMode, Void> memberToSet) {
        Group options = new Group(parent, 32);
        GridLayout optionsLayout = new GridLayout();
        optionsLayout.numColumns = 1;
        optionsLayout.horizontalSpacing = 20;
        options.setLayout((Layout)optionsLayout);
        options.setText(caption);
        final Button outputJar = new Button((Composite)options, 16);
        outputJar.setText("Output Jar");
        outputJar.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (outputJar.getSelection()) {
                    memberToSet.apply(IBazelImportProvider.RootMode.OUTPUT_JAR);
                }
            }
        });
        outputJar.setSelection(true);
        memberToSet.apply(IBazelImportProvider.RootMode.OUTPUT_JAR);
        final Button directory = new Button((Composite)options, 16);
        directory.setText("Directory");
        directory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (directory.getSelection()) {
                    memberToSet.apply(IBazelImportProvider.RootMode.DIRECTORY);
                }
            }
        });
        return options;
    }

    private Void setClassMode(IBazelImportProvider.RootMode mode) {
        this.m_classMode = mode;
        return null;
    }

    private Void setSourceMode(IBazelImportProvider.RootMode mode) {
        this.m_sourceMode = mode;
        return null;
    }

    @Override
    protected boolean isValidInput(TFile input) {
        boolean valid = this.m_workspaceValidator.isValid(null, input).isSuccess();
        this.enableDetection(valid);
        return valid;
    }

    @Override
    protected void detectModuleCandidates(IWorkerContext workerContext) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectModuleCandidates' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        CommandResultConsumer consumer = new CommandResultConsumer(){

            public void consume(CommandException exception) {
            }
        };
        IDetectFromBazelInteraction interaction = new IDetectFromBazelInteraction(){

            public void processDetectModulesResult(OperationResultWithOutcome<Set<ImportModuleCandidate>> detected) {
                NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.showResult(detected);
            }

            public boolean collect(DetectFromBazelData data) {
                data.setBazelWorkspace(NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_textFieldWorkspacePath.getCurrentFile());
                data.setClassRootMode(NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_classMode);
                data.setSourceRootMode(NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.m_sourceMode);
                data.setNamingMode(IBazelImportProvider.NamingMode.SHORT);
                data.setIncludeTest(NewJavaModulesFromBazelWorkspaceWizardLoadModulesPage.this.isIncludeTest());
                return true;
            }
        };
        if (this.isMultiModuleFromRulesImport()) {
            DetectFromBazelWorkspacePerRuleCommand command = new DetectFromBazelWorkspacePerRuleCommand(softwareSystemProvider, interaction);
            command.run(workerContext, consumer);
        } else if (this.isMultiModuleFromBuildFilesImport()) {
            DetectFromBazelWorkspacePerBuildFileCommand command = new DetectFromBazelWorkspacePerBuildFileCommand(softwareSystemProvider, interaction);
            command.run(workerContext, consumer);
        } else {
            DetectFromBazelWorkspacePerWorkspaceCommand command = new DetectFromBazelWorkspacePerWorkspaceCommand(softwareSystemProvider, interaction);
            command.run(workerContext, consumer);
        }
    }

    private boolean isMultiModuleFromBuildFilesImport() {
        return this.m_multiModuleFromBuildFilesImportRadioButton.getSelection();
    }

    private boolean isMultiModuleFromRulesImport() {
        return this.m_multiModuleFromRulesImportRadioButton.getSelection();
    }

    private boolean isIncludeTest() {
        return this.m_includeTest;
    }

    private void enableOptions(boolean enabled) {
        this.m_options.setVisible(enabled);
        this.m_options.setLayout((Layout)(enabled ? this.m_optionsLayoutVisible : this.m_optionsLayoutInvisible));
    }
}

