/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.activity.WorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.foundation.utilities.Pair;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaWorkspaceProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.LabelBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.SimpleCheckBoxTreeViewer;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.StandardUiTreeNodeContentProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportModuleCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportRootDirectoryPathCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ViewDecoratingStyledCellLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.WorkspaceImportUiModel;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.view.TextFilterWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class NewJavaModulesFromBazelPage
extends StandardWizardPage
implements ValidatingPathWidget.IConsumer,
SimpleCheckBoxTreeViewer.IStateChangedListener<ImportCandidateUINode<? extends ImportCandidate>> {
    private static final String DETECTED_MODULES_AND_ROOT_DIRECTORIES = "Detected Modules and Root Directories:";
    private final boolean m_isSystemCreation;
    private WorkerContext m_currentWorkerContext;
    private OperationResultWithOutcome<Set<ImportModuleCandidate>> m_currentResult;
    private Label m_statusLabel;
    private Button m_detectModulesButton;
    private SimpleCheckBoxTreeViewer<ImportCandidateUINode<? extends ImportCandidate>> m_modulesCheckBoxTree;
    private WorkspaceImportUiModel m_uiModel;
    private TextFilterWidget m_textFilter;
    private Button m_modulesFilterCheckBox;
    private Button m_rootDirectoriesFilterCheckBox;
    private Button m_selectAll;
    private Button m_deselectAll;

    protected NewJavaModulesFromBazelPage(String pageName, String description, boolean isCreation) {
        super(pageName, description);
        this.m_isSystemCreation = isCreation;
        this.setPageComplete(false);
    }

    protected abstract IDialogId getDialogId();

    protected abstract void addSpecificContent(Composite var1);

    protected abstract boolean isValidInput(TFile var1);

    protected void enableDetection(boolean enabled) {
        this.m_detectModulesButton.setEnabled(enabled);
    }

    protected abstract void detectModuleCandidates(IWorkerContext var1);

    protected final void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        this.addSpecificContent(composite);
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_detectModulesButton = new Button(composite, 8);
        this.m_detectModulesButton.setText("Detect Modules");
        this.m_detectModulesButton.setLayoutData((Object)new GridData(131072, 0, false, false, 2, 1));
        this.m_detectModulesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.m_detectModulesButton.setEnabled(false);
                NewJavaModulesFromBazelPage.this.clearTree();
                NewJavaModulesFromBazelPage.this.createNewWorkerContext();
                NewJavaModulesFromBazelPage.this.detectModuleCandidates((IWorkerContext)NewJavaModulesFromBazelPage.this.m_currentWorkerContext);
            }
        });
        this.m_detectModulesButton.setEnabled(false);
        this.m_statusLabel = new Label(composite, 0);
        this.m_statusLabel.setText(DETECTED_MODULES_AND_ROOT_DIRECTORIES);
        this.m_statusLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Composite filterControl = new Composite(composite, 0);
        filterControl.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        filterControl.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithoutMargin((int)2));
        Composite filterRadioButtons = new Composite(filterControl, 0);
        filterRadioButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        filterRadioButtons.setLayout((Layout)new FillLayout());
        this.m_modulesFilterCheckBox = new Button(filterRadioButtons, 16);
        this.m_modulesFilterCheckBox.setImage(UiResourceManager.getInstance().getImage(Module.class.getSimpleName()));
        this.m_modulesFilterCheckBox.setSelection(true);
        this.m_modulesFilterCheckBox.setToolTipText("Filter modules");
        SelectionAdapter modulesRootFilterLevelChangedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.filterModuleTree(NewJavaModulesFromBazelPage.this.m_textFilter.getFilterText().getText());
            }
        };
        this.m_modulesFilterCheckBox.addSelectionListener((SelectionListener)modulesRootFilterLevelChangedListener);
        this.m_rootDirectoriesFilterCheckBox = new Button(filterRadioButtons, 16);
        this.m_rootDirectoriesFilterCheckBox.setImage(UiResourceManager.getInstance().getImage(RootDirectoryPath.class.getSimpleName()));
        this.m_rootDirectoriesFilterCheckBox.setToolTipText("Filter root directories");
        this.m_rootDirectoriesFilterCheckBox.addSelectionListener((SelectionListener)modulesRootFilterLevelChangedListener);
        this.m_textFilter = new TextFilterWidget(filterControl, text -> this.filterModuleTree(text));
        this.m_textFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_modulesCheckBoxTree = new SimpleCheckBoxTreeViewer(composite, (ICheckStateProvider)new SimpleCheckBoxTreeViewer.UiTreeNodeCheckStateProvider());
        this.m_modulesCheckBoxTree.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_modulesCheckBoxTree.enableTooltipSupport();
        this.m_modulesCheckBoxTree.setContentProvider((IContentProvider)new StandardUiTreeNodeContentProvider());
        this.m_modulesCheckBoxTree.setLabelProvider((IBaseLabelProvider)new ViewDecoratingStyledCellLabelProvider(new ImportLabelProvider()));
        this.m_modulesCheckBoxTree.setStateChangedListener((SimpleCheckBoxTreeViewer.IStateChangedListener)this);
        this.m_modulesCheckBoxTree.setCheckStateProvider((ICheckStateProvider)new SimpleCheckBoxTreeViewer.UiTreeNodeCheckStateProvider());
        Composite buttons = new Composite(composite, 0);
        buttons.setLayout((Layout)new FillLayout());
        buttons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false, 2, 1));
        this.m_selectAll = new Button(buttons, 8);
        this.m_selectAll.setText("Select All");
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.updateSelectionStateOfVisibleTreeNodes(true);
            }
        });
        this.m_deselectAll = new Button(buttons, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.updateSelectionStateOfVisibleTreeNodes(false);
            }
        });
        this.m_modulesFilterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.m_selectAll.setToolTipText("Select all currently shown modules and root directories");
                NewJavaModulesFromBazelPage.this.m_deselectAll.setToolTipText("Deselect all currently shown modules and root directories");
            }
        });
        this.m_rootDirectoriesFilterCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewJavaModulesFromBazelPage.this.m_selectAll.setToolTipText("Select all currently shown root directories");
                NewJavaModulesFromBazelPage.this.m_deselectAll.setToolTipText("Deselect all currently shown root directories");
            }
        });
        this.enableSelectAllButtons(false);
        this.setControl((Control)composite);
        if (!this.isValidInput(null)) {
            this.setMessage("There are input fields with errors, please check.", 3);
        }
    }

    private void enableSelectAllButtons(boolean enabled) {
        this.m_selectAll.setEnabled(enabled);
        this.m_deselectAll.setEnabled(enabled);
    }

    protected void clearTree() {
        this.m_modulesCheckBoxTree.getTree().setRedraw(false);
        this.m_modulesCheckBoxTree.setInput(null);
        this.m_modulesCheckBoxTree.getTree().setRedraw(true);
        this.m_uiModel = null;
    }

    private void updateSelectionStateOfVisibleTreeNodes(boolean select) {
        int filterMask = this.determineFilterMask();
        this.m_modulesCheckBoxTree.setAllVisibleChecked(select, filterMask);
    }

    private void checkMultipleDefinitions() {
        if (!this.m_isSystemCreation) {
            ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
            assert (provider.hasSoftwareSystem()) : "No system available";
            IJavaWorkspaceProvider workspaceProvider = (IJavaWorkspaceProvider)provider.getSoftwareSystem().getExtension(IJavaWorkspaceProvider.class);
            workspaceProvider.checkModuleCandidatesForDuplicates((IWorkerContext)this.m_currentWorkerContext, this.getModuleCandidates());
        }
        ImportModuleCandidate.checkDuplicates(this.getModuleCandidates());
    }

    private void filterModuleTree(String text) {
        int filterMask = this.determineFilterMask();
        if (filterMask == 0) {
            UserInterfaceAdapter.getInstance().warning("No Filtering Enabled", "Please select at least one element type to filter.");
            return;
        }
        this.m_modulesCheckBoxTree.setFilter(text, filterMask);
    }

    private int determineFilterMask() {
        if (this.m_modulesFilterCheckBox.getSelection()) {
            return SimpleCheckBoxTreeViewer.TreeViewerFilter.determineFilterMask((int[])new int[]{0});
        }
        if (this.m_rootDirectoriesFilterCheckBox.getSelection()) {
            return SimpleCheckBoxTreeViewer.TreeViewerFilter.determineFilterMask((int[])new int[]{1});
        }
        return 0;
    }

    private void refreshModulesContent(ImportCandidateUINode<? extends ImportCandidate> node) {
        String message;
        this.createNewWorkerContext();
        assert (this.m_currentResult != null) : "'m_currentResult' of method 'refreshModulesContent' must not be null";
        this.m_modulesCheckBoxTree.removeStateChangedListener();
        this.checkMultipleDefinitions();
        StringBuilder overallMessage = new StringBuilder();
        Iterator iterator = this.m_currentResult.getErrorMessages().iterator();
        while (iterator.hasNext()) {
            message = (String)iterator.next();
            overallMessage.append("Error: ").append(message);
            if (!iterator.hasNext()) continue;
            overallMessage.append("\n");
        }
        iterator = this.m_currentResult.getWarningMessages().iterator();
        while (iterator.hasNext()) {
            message = (String)iterator.next();
            overallMessage.append("Warning: ").append(message);
            if (!iterator.hasNext()) continue;
            overallMessage.append("\n");
        }
        Pair<Boolean, Boolean> moduleWarningsAndErrors = new Pair<Boolean, Boolean>((Object)Boolean.FALSE, (Object)Boolean.FALSE);
        if (!this.getModuleCandidates().isEmpty()) {
            moduleWarningsAndErrors = this.processModuleCandidates(node);
        } else {
            this.setPageComplete(false);
        }
        String moduleInfo = null;
        boolean moduleWarningsExist = (Boolean)moduleWarningsAndErrors.getFirst();
        boolean moduleErrorsExist = (Boolean)moduleWarningsAndErrors.getSecond();
        if (moduleErrorsExist && moduleWarningsExist) {
            moduleInfo = "errors/warnings";
        } else if (moduleErrorsExist) {
            moduleInfo = "errors";
        } else if (moduleWarningsExist) {
            moduleInfo = "warnings";
        }
        if (moduleInfo != null) {
            overallMessage.insert(0, "Modules have " + moduleInfo + ". Hover over modules with a marker for details.\n");
        }
        if (overallMessage.length() > 0) {
            this.setMessage(overallMessage.toString(), this.m_currentResult.isSuccess() ? 2 : 3);
        }
        this.m_modulesCheckBoxTree.setStateChangedListener((SimpleCheckBoxTreeViewer.IStateChangedListener)this);
    }

    private void createNewWorkerContext() {
        this.m_currentWorkerContext = new LabelBasedWorkerContext(this.m_statusLabel, 20);
    }

    private Pair<Boolean, Boolean> processModuleCandidates(ImportCandidateUINode<? extends ImportCandidate> node) {
        Boolean moduleErrorsExist = Boolean.FALSE;
        Boolean moduleWarningsExist = Boolean.FALSE;
        if (this.m_uiModel == null) {
            this.m_uiModel = new WorkspaceImportUiModel(this.getModuleCandidates());
            this.m_modulesCheckBoxTree.setInput(this.m_uiModel.getRootElements());
            this.m_modulesCheckBoxTree.expandAll();
            this.enableSelectAllButtons(true);
        }
        List<ImportCandidateUINode<? extends ImportCandidate>> rootElements = this.m_uiModel.getRootElements();
        Pair<Pair<Integer, Integer>, Pair<Boolean, Boolean>> updateResult = this.updateCheckBoxes(node, rootElements);
        Pair errorsAndWarningsExist = (Pair)updateResult.getSecond();
        moduleErrorsExist = (Boolean)errorsAndWarningsExist.getFirst();
        moduleWarningsExist = (Boolean)errorsAndWarningsExist.getSecond();
        Pair includedModulesAndRoots = (Pair)updateResult.getFirst();
        int numberOfIncludedModules = (Integer)includedModulesAndRoots.getFirst();
        int numberOfIncludedRootDirectoryPaths = (Integer)includedModulesAndRoots.getSecond();
        this.setPageComplete(numberOfIncludedModules > 0 || numberOfIncludedRootDirectoryPaths > 0);
        return new Pair((Object)moduleWarningsExist, (Object)moduleErrorsExist);
    }

    private Pair<Pair<Integer, Integer>, Pair<Boolean, Boolean>> updateCheckBoxes(ImportCandidateUINode<? extends ImportCandidate> node, List<ImportCandidateUINode<? extends ImportCandidate>> rootElements) {
        assert (rootElements != null) : "Parameter 'rootElements' of method 'updateCheckBoxes' must not be null";
        Boolean moduleErrorsExist = Boolean.FALSE;
        Boolean moduleWarningsExist = Boolean.FALSE;
        int numberOfIncludedModules = 0;
        int numOfIncludedRootDirectoryPaths = 0;
        for (ImportCandidateUINode<? extends ImportCandidate> nextTreeNode : rootElements) {
            ImportModuleCandidateUINode nextModuleUiNode = (ImportModuleCandidateUINode)nextTreeNode;
            ImportModuleCandidate nextModule = (ImportModuleCandidate)nextModuleUiNode.getImportCandidate();
            boolean updateCheckBoxTreeForModule = node == null || nextModuleUiNode == node;
            for (UiTreeNode nextChild : nextModuleUiNode.getChildren()) {
                if (!(nextChild instanceof ImportRootDirectoryPathCandidateUINode)) continue;
                boolean updateCheckBoxTree = node == null || nextModuleUiNode == node || nextChild == node;
                ImportRootDirectoryPathCandidateUINode nextRootDirectoryUiNode = (ImportRootDirectoryPathCandidateUINode)nextChild;
                ImportRootDirectoryPathCandidate nextRootDirectory = (ImportRootDirectoryPathCandidate)nextRootDirectoryUiNode.getImportCandidate();
                if (nextRootDirectory.isAlreadyInWorkspace() && updateCheckBoxTree) {
                    this.m_modulesCheckBoxTree.setDisabled((UiTreeNode)nextRootDirectoryUiNode, false);
                    continue;
                }
                if (!nextRootDirectory.isIncluded()) continue;
                ++numOfIncludedRootDirectoryPaths;
            }
            if ((nextModule.getError() != null || nextModule.isAlreadyInWorkspace()) && updateCheckBoxTreeForModule) {
                this.m_modulesCheckBoxTree.setDisabled((UiTreeNode)nextModuleUiNode, false);
            } else if (nextModule.isIncluded()) {
                ++numberOfIncludedModules;
            }
            if (nextModule.getError() != null) {
                moduleErrorsExist = Boolean.TRUE;
            }
            if (nextModule.getWarning() == null) continue;
            moduleWarningsExist = Boolean.TRUE;
        }
        return new Pair((Object)new Pair((Object)numberOfIncludedModules, (Object)numOfIncludedRootDirectoryPaths), (Object)new Pair((Object)moduleErrorsExist, (Object)moduleWarningsExist));
    }

    private final List<ImportModuleCandidateUINode> resolveLinkedDependencies(ImportModuleCandidate moduleCandidateChecked) {
        assert (moduleCandidateChecked != null) : "Parameter 'moduleCandidateChecked' of method 'resolveLinkedDependencies' must not be null";
        ArrayList<ImportModuleCandidateUINode> dependentModules = new ArrayList<ImportModuleCandidateUINode>();
        block0: for (ImportModuleCandidate nextModuleCandidate : this.getModuleCandidates()) {
            if (moduleCandidateChecked.equals(nextModuleCandidate) || !nextModuleCandidate.getDependencies().contains(moduleCandidateChecked.getName())) continue;
            assert (this.m_uiModel != null) : "'m_uiModel' of method 'resolveLinkedDependencies' must not be null";
            for (UiTreeNode uiTreeNode : this.m_uiModel.getRootElements()) {
                if (!((ImportModuleCandidate)((ImportModuleCandidateUINode)uiTreeNode).getImportCandidate()).equals(nextModuleCandidate)) continue;
                dependentModules.add((ImportModuleCandidateUINode)uiTreeNode);
                continue block0;
            }
        }
        return dependentModules;
    }

    public final void handleStateChanged(ImportCandidateUINode<? extends ImportCandidate> element) {
        this.stateChanged(element);
        this.refreshModulesContent(element);
    }

    private void stateChanged(UiTreeNode element) {
        if (element instanceof ImportModuleCandidateUINode) {
            ImportModuleCandidateUINode moduleCandidateNode = (ImportModuleCandidateUINode)element;
            ImportModuleCandidate moduleCandidate = (ImportModuleCandidate)moduleCandidateNode.getImportCandidate();
            moduleCandidate.setIncluded(element.isChecked());
            for (ImportModuleCandidateUINode nextDependentCandidateUiNode : this.resolveLinkedDependencies(moduleCandidate)) {
                nextDependentCandidateUiNode.setHasBrokenDependency(!element.isChecked());
            }
        } else if (element instanceof ImportRootDirectoryPathCandidateUINode) {
            ((ImportRootDirectoryPathCandidate)((ImportRootDirectoryPathCandidateUINode)element).getImportCandidate()).setIncluded(element.isChecked());
        } else assert (false) : "Unexpected instance : " + String.valueOf(element);
    }

    public final void handleAllStatesChanged() {
        for (ImportCandidateUINode next : this.m_modulesCheckBoxTree.getInput()) {
            this.stateChanged(next);
            for (UiTreeNode root : next.getChildren()) {
                this.stateChanged(root);
            }
        }
        this.refreshModulesContent(null);
    }

    final Set<ImportModuleCandidate> getModuleCandidates() {
        Set outcome;
        if (this.m_currentResult != null && (outcome = (Set)this.m_currentResult.getOutcome()) != null) {
            return Collections.unmodifiableSet(outcome);
        }
        return Collections.emptySet();
    }

    public void dispose() {
        if (this.m_currentWorkerContext != null) {
            this.m_currentWorkerContext.cancel();
        }
        super.dispose();
    }

    protected void showResult(final OperationResultWithOutcome<Set<ImportModuleCandidate>> result) {
        UserInterfaceAdapter.getInstance().displayUiElement(new Runnable(){

            @Override
            public void run() {
                if (!NewJavaModulesFromBazelPage.this.hasBeenDisposed()) {
                    NewJavaModulesFromBazelPage.this.m_statusLabel.setText(NewJavaModulesFromBazelPage.DETECTED_MODULES_AND_ROOT_DIRECTORIES);
                    NewJavaModulesFromBazelPage.this.m_currentResult = result;
                    NewJavaModulesFromBazelPage.this.refreshModulesContent(null);
                    NewJavaModulesFromBazelPage.this.m_detectModulesButton.setEnabled(true);
                }
            }
        });
    }

    public void setPath(TFile input, boolean inputModified) {
        if (this.isValidInput(input)) {
            this.setMessage("");
        } else {
            this.setMessage("There are input fields with errors, please check.", 3);
            this.setPageComplete(false);
        }
    }
}

