/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.path.RootDirectoryPath;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportRootDirectoryPathCandidate;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.propertyreader.StringBeanAdapter;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.buildunits.BuildUnitData;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaModulesProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.NameAndDescriptionDialog;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.TextBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.SimpleCheckBoxTreeViewer;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.StandardUiTreeNodeContentProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportModuleCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ImportRootDirectoryPathCandidateUINode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.UnassignedRootBeanAdapter;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ViewDecoratingStyledCellLabelProvider;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.view.IContextMenuInteractionListener;
import com.hello2morrow.sonargraph.ui.swt.base.view.TextFilterWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.IContextMenuContentProvider;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.MenuHandler;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

final class JavaModulesBasedOnBuildUnitsWizardPage
extends StandardWizardPage
implements SimpleCheckBoxTreeViewer.IStateChangedListener<UiTreeNode>,
IContextMenuContentProvider {
    private static final String INFO = "This wizard can only work well when you have previously build your system. Java class and source files are analyzed. Press F1 for more information!";
    private static final String SELECT_DIRECTORY_INFO = "Select the directory containing the build units to trigger the initial detection of root segments and definitions!";
    private static final String SELECT_DIRECTORY_INFO_NO_ROOTS_FOUND = "No root segments and definitions detected! Select a different directory containing the build units to trigger the initial detection of root segments and definitions!";
    private static final String IMPORT_CANDIDATES = "Import Candidates";
    private static final String IMPORT_CANDIDATES_DETECTION_NOT_RUN = "Import Candidates [detection has not been run]";
    private static final String TWEAK_RUN = "Tweak the root segments and/or root definitions and run the root definitions and/or import candidates detection!";
    private static final String TWEAK_RERUN = "Tweak the root segments and/or root definitions and rerun the root definitions and/or import candidates detection (if needed)!";
    private static final String SELECT_DIRECTORY = "Select Directory";
    private static final String DETECT_IMPORT_CANDIDATES = "Detect Import Candidates";
    private static final String DETECTING = "Detecting...";
    private static final String STOP = "Stop Detection";
    private final IJavaModulesProvider m_provider;
    private final IInfoProvider m_infoProvider;
    private boolean m_alreadyOpenedSelectDirectoryDialog;
    private Text m_startDirectory;
    private Button m_selectDirectory;
    private Button m_detectImportCandidates;
    private PropertyTableViewer<String> m_classRootSegments;
    private PropertyTableViewer<String> m_sourceRootSegments;
    private PropertyTableViewer<String> m_classRootDefinitions;
    private PropertyTableViewer<String> m_sourceRootDefinitions;
    private Text m_info;
    private PropertyTableViewer<String> m_unassignedClassRoots;
    private PropertyTableViewer<String> m_unassignedSourceRoots;
    private Button m_modulesFilterCheckBox;
    private Button m_rootDirectoriesFilterCheckBox;
    private TextFilterWidget m_textFilter;
    private Button m_collapseAll;
    private Button m_expandAll;
    private Group m_importCandidatesGroup;
    private SimpleCheckBoxTreeViewer<UiTreeNode> m_importCandidates;
    private Button m_selectAll;
    private Button m_deselectAll;
    private TextBasedWorkerContext m_workerContext;
    private BuildUnitData m_data;

    JavaModulesBasedOnBuildUnitsWizardPage(String title, IJavaModulesProvider provider, IInfoProvider infoProvider) {
        super(JavaDialogId.IMPORT_MODULE_JAVA_BUILD_UNIT.getStandardName(), title);
        assert (provider != null) : "Parameter 'provider' of method 'JavaModulesBasedOnBuildUnitsWizardPage' must not be null";
        assert (infoProvider != null) : "Parameter 'infoProvider' of method 'JavaModulesBasedOnBuildUnitsWizardPage' must not be null";
        this.m_provider = provider;
        this.m_infoProvider = infoProvider;
        this.setPageComplete(false);
    }

    protected IDialogId getDialogId() {
        return JavaDialogId.IMPORT_MODULE_JAVA_BUILD_UNIT;
    }

    protected int getNumberOfColumns() {
        return 1;
    }

    private GridLayout createCompositeGridLayout(int columns, int horizontalSpacing, int verticalSpacing) {
        GridLayout gridLayout = new GridLayout(columns, false);
        gridLayout.marginBottom = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = horizontalSpacing;
        gridLayout.verticalSpacing = verticalSpacing;
        return gridLayout;
    }

    private void stopDetection(boolean inDispose) {
        if (this.m_workerContext != null) {
            this.m_workerContext.cancel();
        }
        if (!inDispose && !this.hasBeenDisposed()) {
            this.update();
        }
    }

    private BuildUnitData confirmDetectInitialBuildUnitData(BuildUnitData data) {
        if (data != null) {
            String message = null;
            if (data.haveRootSegmentsBeenModified()) {
                message = "Root segments modified! ";
            } else if (data.haveRootDefinitionsBeenModified()) {
                message = "Root definitions modified! ";
            }
            if (message != null && UserInterfaceAdapter.getInstance().question(message + "This will reset the wizard in it's initial state!\nYou will lose your modifications!\n\nDo you want to proceed?", false) != UserInterfaceAdapter.Feedback.CONFIRMED) {
                return data;
            }
        }
        return null;
    }

    private void startInitialBuildUnitDataDetection() {
        assert (this.m_workerContext == null) : "'m_workerContext' of method 'startInitialBuildUnitDataDetection' must not be null";
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 4096);
        if (!this.m_alreadyOpenedSelectDirectoryDialog) {
            String defaultDirectory = this.m_infoProvider.getDefaultDirectory();
            if (defaultDirectory != null) {
                directoryDialog.setFilterPath(defaultDirectory);
            }
            this.m_alreadyOpenedSelectDirectoryDialog = true;
        }
        BuildUnitData data = this.m_data;
        this.m_data = null;
        String directory = directoryDialog.open();
        if (directory != null && !directory.isEmpty()) {
            this.m_data = this.confirmDetectInitialBuildUnitData(data);
            if (this.m_data == null) {
                this.update();
                this.m_detectImportCandidates.setEnabled(false);
                this.setImportCandidatesInteractionEnabled(false);
                this.m_startDirectory.setText(directory);
                this.m_selectDirectory.setText(STOP);
                this.m_selectDirectory.setImage(UiResourceManager.getInstance().getImage("StopDetection"));
                this.m_workerContext = new TextBasedWorkerContext(this.m_info, 100);
                this.m_workerContext.start(DETECTING, ActivityMode.NONE, false);
                this.m_data = this.m_provider.detectInitialBuildUnitData((IWorkerContext)this.m_workerContext, new TFile(this.m_startDirectory.getText()), this.m_infoProvider.getSoftwareSystem());
                if (this.m_workerContext.hasBeenCanceled() && !this.m_startDirectory.isDisposed()) {
                    this.m_startDirectory.setText("");
                }
                this.m_workerContext.stop();
                this.m_workerContext = null;
            }
        } else {
            this.m_data = this.confirmDetectInitialBuildUnitData(data);
            if (this.m_data == null) {
                this.m_startDirectory.setText("");
            }
        }
        this.stopDetection(false);
    }

    private void confirmRootDefintionsModificationAndRun(Runnable action) {
        assert (this.m_data != null) : "Parameter 'm_data' of method 'confirmRootDefintionsModificationAndRun' must not be null";
        assert (action != null) : "Parameter 'action' of method 'confirmRootDefintionsModificationAndRun' must not be null";
        if (!this.m_data.haveRootDefinitionsBeenModified() || UserInterfaceAdapter.getInstance().question("Root definitions modified!\nYou will lose your modifications!\n\nDo you want to proceed?", false) == UserInterfaceAdapter.Feedback.CONFIRMED) {
            this.m_selectDirectory.setEnabled(false);
            this.m_detectImportCandidates.setEnabled(false);
            this.setImportCandidatesInteractionEnabled(false);
            action.run();
            this.m_workerContext = new TextBasedWorkerContext(this.m_info, 100);
            this.m_workerContext.start(DETECTING, ActivityMode.NONE, false);
            this.m_provider.detectRootDefinitions((IWorkerContext)this.m_workerContext, this.m_data);
            this.m_workerContext.stop();
            this.m_workerContext = null;
            this.stopDetection(false);
        }
    }

    private void startImportCandidatesDetection() {
        assert (this.m_workerContext == null) : "'m_workerContext' of method 'startImportCandidatesDetection' must be null";
        this.m_selectDirectory.setEnabled(false);
        this.m_detectImportCandidates.setText(STOP);
        this.m_detectImportCandidates.setImage(UiResourceManager.getInstance().getImage("StopDetection"));
        this.m_workerContext = new TextBasedWorkerContext(this.m_info, 100);
        this.m_workerContext.start(DETECTING, ActivityMode.NONE, false);
        this.m_provider.detectImportCandidates((IWorkerContext)this.m_workerContext, this.m_data);
        this.m_workerContext.stop();
        this.m_workerContext = null;
        this.stopDetection(false);
    }

    private int determineFilterMask() {
        if (this.m_modulesFilterCheckBox.getSelection()) {
            return SimpleCheckBoxTreeViewer.TreeViewerFilter.determineFilterMask((int[])new int[]{0});
        }
        if (this.m_rootDirectoriesFilterCheckBox.getSelection()) {
            return SimpleCheckBoxTreeViewer.TreeViewerFilter.determineFilterMask((int[])new int[]{1});
        }
        return 0;
    }

    private void filterModuleTree(String text) {
        int filterMask = this.determineFilterMask();
        if (filterMask == 0) {
            UserInterfaceAdapter.getInstance().warning("No Filtering Enabled", "Please select at least one element type to filter.");
            return;
        }
        this.m_importCandidates.setFilter(text, filterMask);
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createContent' must not be null";
        this.setMessage(INFO, 1);
        Composite detectionComposite = new Composite(composite, 0);
        detectionComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        detectionComposite.setLayout((Layout)this.createCompositeGridLayout(3, 4, 2));
        this.m_selectDirectory = new Button(detectionComposite, 0x800008);
        this.m_selectDirectory.setImage(UiResourceManager.getInstance().getImage("OpenSystem"));
        this.m_selectDirectory.setText(SELECT_DIRECTORY);
        this.m_selectDirectory.setToolTipText(SELECT_DIRECTORY_INFO);
        this.m_selectDirectory.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_selectDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JavaModulesBasedOnBuildUnitsWizardPage.this.m_workerContext == null) {
                    JavaModulesBasedOnBuildUnitsWizardPage.this.startInitialBuildUnitDataDetection();
                } else {
                    JavaModulesBasedOnBuildUnitsWizardPage.this.stopDetection(false);
                }
            }
        });
        this.m_startDirectory = new Text(detectionComposite, 8);
        this.m_startDirectory.setLayoutData((Object)new GridData(4, 4, true, false));
        this.m_startDirectory.setText("");
        this.m_startDirectory.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        this.m_detectImportCandidates = new Button(detectionComposite, 0x800008);
        this.m_detectImportCandidates.setText(DETECT_IMPORT_CANDIDATES);
        this.m_detectImportCandidates.setImage(UiResourceManager.getInstance().getImage("StartDetection"));
        this.m_detectImportCandidates.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_detectImportCandidates.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (JavaModulesBasedOnBuildUnitsWizardPage.this.m_workerContext == null) {
                    JavaModulesBasedOnBuildUnitsWizardPage.this.startImportCandidatesDetection();
                } else {
                    JavaModulesBasedOnBuildUnitsWizardPage.this.stopDetection(false);
                }
            }
        });
        this.m_detectImportCandidates.setEnabled(false);
        Group infoGroup = new Group(detectionComposite, 0);
        infoGroup.setLayout((Layout)new FillLayout());
        infoGroup.setText("Info");
        GridData infoGridData = new GridData(4, 0x1000000, true, false, 3, 1);
        infoGroup.setLayoutData((Object)infoGridData);
        this.m_info = new Text((Composite)infoGroup, 72);
        this.m_info.setBackground(UiResourceManager.getInstance().getBackgroundColor());
        infoGridData.heightHint = SwtUtility.calculatePreferredHeight((Text)this.m_info, (int)2);
        this.m_info.setText(SELECT_DIRECTORY_INFO);
        SashForm sashForm = new SashForm(composite, 512);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Group rootSegmentsGroup = new Group((Composite)sashForm, 0);
        rootSegmentsGroup.setLayout((Layout)new FillLayout());
        rootSegmentsGroup.setText("Root Segments");
        SashForm rootSegmentsSashForm = new SashForm((Composite)rootSegmentsGroup, 256);
        this.m_classRootSegments = new PropertyTableViewer((Composite)rootSegmentsSashForm, (BeanPropertyReader.BeanAdapter)new StringBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_classRootSegments.addColumn("Class Root Segment", "info", null, null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_classRootSegments.showData(Collections.emptyList());
        new MenuHandler((IContextMenuContentProvider)this, (Control)this.m_classRootSegments.getTable());
        this.m_sourceRootSegments = new PropertyTableViewer((Composite)rootSegmentsSashForm, (BeanPropertyReader.BeanAdapter)new StringBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_sourceRootSegments.addColumn("Source Root Segment", "info", null, null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_sourceRootSegments.showData(Collections.emptyList());
        new MenuHandler((IContextMenuContentProvider)this, (Control)this.m_sourceRootSegments.getTable());
        Group rootDefinitionsGroup = new Group((Composite)sashForm, 0);
        rootDefinitionsGroup.setLayout((Layout)new FillLayout());
        rootDefinitionsGroup.setText("Root Definitions");
        SashForm rootViewersSashForm = new SashForm((Composite)rootDefinitionsGroup, 256);
        this.m_classRootDefinitions = new PropertyTableViewer((Composite)rootViewersSashForm, (BeanPropertyReader.BeanAdapter)new StringBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_classRootDefinitions.addColumn("Class Root Definition", "info", null, null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_classRootDefinitions.showData(Collections.emptyList());
        new MenuHandler((IContextMenuContentProvider)this, (Control)this.m_classRootDefinitions.getTable());
        this.m_sourceRootDefinitions = new PropertyTableViewer((Composite)rootViewersSashForm, (BeanPropertyReader.BeanAdapter)new StringBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_sourceRootDefinitions.addColumn("Source Root Definition", "info", null, null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_sourceRootDefinitions.showData(Collections.emptyList());
        new MenuHandler((IContextMenuContentProvider)this, (Control)this.m_sourceRootDefinitions.getTable());
        Group unassignedGroup = new Group((Composite)sashForm, 0);
        unassignedGroup.setLayout((Layout)new FillLayout());
        unassignedGroup.setText("Unassigned roots");
        SashForm unassignedRootViewersSashForm = new SashForm((Composite)unassignedGroup, 256);
        this.m_unassignedClassRoots = new PropertyTableViewer((Composite)unassignedRootViewersSashForm, (BeanPropertyReader.BeanAdapter)new UnassignedRootBeanAdapter("RootDirectoryPath"), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_unassignedClassRoots.addColumn("Unassigned Class Root", "info", null, "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_unassignedClassRoots.showData(Collections.emptyList());
        this.m_unassignedSourceRoots = new PropertyTableViewer((Composite)unassignedRootViewersSashForm, (BeanPropertyReader.BeanAdapter)new UnassignedRootBeanAdapter("JavaSourceRootDirectoryPath"), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_unassignedSourceRoots.addColumn("Unassigned Source Root", "info", null, "image", 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_unassignedSourceRoots.showData(Collections.emptyList());
        this.m_importCandidatesGroup = new Group((Composite)sashForm, 0);
        this.m_importCandidatesGroup.setLayout((Layout)this.createCompositeGridLayout(1, 0, 0));
        this.m_importCandidatesGroup.setText(IMPORT_CANDIDATES);
        Composite filterControl = new Composite((Composite)this.m_importCandidatesGroup, 0);
        filterControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        filterControl.setLayout((Layout)this.createCompositeGridLayout(3, 0, 0));
        Composite filterRadioButtons = new Composite(filterControl, 0);
        filterRadioButtons.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        filterRadioButtons.setLayout((Layout)this.createCompositeGridLayout(2, 2, 0));
        this.m_modulesFilterCheckBox = new Button(filterRadioButtons, 16);
        this.m_modulesFilterCheckBox.setImage(UiResourceManager.getInstance().getImage(Module.class.getSimpleName()));
        this.m_modulesFilterCheckBox.setSelection(true);
        this.m_modulesFilterCheckBox.setToolTipText("Filter modules");
        SelectionAdapter modulesRootFilterLevelChangedListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaModulesBasedOnBuildUnitsWizardPage.this.filterModuleTree(JavaModulesBasedOnBuildUnitsWizardPage.this.m_textFilter.getFilterText().getText());
            }
        };
        this.m_modulesFilterCheckBox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_modulesFilterCheckBox.setEnabled(false);
        this.m_modulesFilterCheckBox.addSelectionListener((SelectionListener)modulesRootFilterLevelChangedListener);
        this.m_rootDirectoriesFilterCheckBox = new Button(filterRadioButtons, 16);
        this.m_rootDirectoriesFilterCheckBox.setImage(UiResourceManager.getInstance().getImage(RootDirectoryPath.class.getSimpleName()));
        this.m_rootDirectoriesFilterCheckBox.setToolTipText("Filter root directories");
        this.m_rootDirectoriesFilterCheckBox.addSelectionListener((SelectionListener)modulesRootFilterLevelChangedListener);
        this.m_rootDirectoriesFilterCheckBox.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.m_rootDirectoriesFilterCheckBox.setEnabled(false);
        this.m_textFilter = new TextFilterWidget(filterControl, text -> this.filterModuleTree(text));
        this.m_textFilter.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_textFilter.setEnabled(false);
        Composite collapseExpandButtons = new Composite(filterControl, 0);
        collapseExpandButtons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        collapseExpandButtons.setLayout((Layout)this.createCompositeGridLayout(2, 0, 0));
        this.m_collapseAll = new Button(collapseExpandButtons, 0x800008);
        this.m_collapseAll.setImage(UiResourceManager.getInstance().getImage("CollapseAll"));
        this.m_collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaModulesBasedOnBuildUnitsWizardPage.this.m_importCandidates.collapseAll();
            }
        });
        this.m_collapseAll.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_collapseAll.setEnabled(false);
        this.m_expandAll = new Button(collapseExpandButtons, 0x800008);
        this.m_expandAll.setImage(UiResourceManager.getInstance().getImage("ExpandAll"));
        this.m_expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaModulesBasedOnBuildUnitsWizardPage.this.m_importCandidates.expandAll();
            }
        });
        this.m_expandAll.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.m_expandAll.setEnabled(false);
        this.m_importCandidates = new SimpleCheckBoxTreeViewer((Composite)this.m_importCandidatesGroup, (ICheckStateProvider)new SimpleCheckBoxTreeViewer.UiTreeNodeCheckStateProvider());
        this.m_importCandidates.enableTooltipSupport();
        this.m_importCandidates.setContentProvider((IContentProvider)new StandardUiTreeNodeContentProvider());
        this.m_importCandidates.setLabelProvider((IBaseLabelProvider)new ViewDecoratingStyledCellLabelProvider(new ImportLabelProvider()));
        this.m_importCandidates.setStateChangedListener((SimpleCheckBoxTreeViewer.IStateChangedListener)this);
        this.m_importCandidates.setCheckStateProvider((ICheckStateProvider)new SimpleCheckBoxTreeViewer.UiTreeNodeCheckStateProvider());
        this.m_importCandidates.setInput(Collections.emptyList());
        this.m_importCandidates.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        new MenuHandler((IContextMenuContentProvider)this, (Control)this.m_importCandidates.getTree());
        Composite buttons = new Composite((Composite)this.m_importCandidatesGroup, 0);
        buttons.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        buttons.setLayout((Layout)this.createCompositeGridLayout(2, 4, 0));
        this.m_selectAll = new Button(buttons, 8);
        this.m_selectAll.setText("Select All");
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaModulesBasedOnBuildUnitsWizardPage.this.m_importCandidates.setAllVisibleChecked(true, JavaModulesBasedOnBuildUnitsWizardPage.this.determineFilterMask());
            }
        });
        this.m_selectAll.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, false));
        this.m_selectAll.setEnabled(false);
        this.m_deselectAll = new Button(buttons, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaModulesBasedOnBuildUnitsWizardPage.this.m_importCandidates.setAllVisibleChecked(false, JavaModulesBasedOnBuildUnitsWizardPage.this.determineFilterMask());
            }
        });
        this.m_deselectAll.setLayoutData((Object)new GridData(0x1000008, 0x1000008, false, false));
        this.m_deselectAll.setEnabled(false);
        sashForm.setWeights(new int[]{15, 15, 25, 45});
        this.applySettings();
    }

    public void dispose() {
        this.stopDetection(true);
        this.saveSettings();
        super.dispose();
    }

    private void applySettings() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone.java", (IDialogId)JavaDialogId.IMPORT_MODULE_JAVA_BUILD_UNIT);
        assert (settings != null) : "'settings' of method 'createContent' must not be null";
    }

    private void saveSettings() {
        if (!this.hasBeenDisposed()) {
            IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone.java", (IDialogId)JavaDialogId.IMPORT_MODULE_JAVA_BUILD_UNIT);
            assert (settings != null) : "'settings' of method 'dispose' must not be null";
        }
    }

    private void updataImportCandidates() {
        assert (this.m_data != null) : "Parameter 'm_data' of method 'updataImportCandidates' must not be null";
        int modules = 0;
        int classRoots = 0;
        int sourceRoots = 0;
        int checkedModules = 0;
        int checkedClassRoots = 0;
        int checkedSourceRoots = 0;
        for (ImportModuleCandidate next : this.m_data.getModuleCandidates()) {
            ++modules;
            if (next.isIncluded()) {
                ++checkedModules;
            }
            for (ImportRootDirectoryPathCandidate nextRoot : next.getRootPaths()) {
                if (nextRoot.hasSource()) {
                    ++sourceRoots;
                    if (!nextRoot.isIncluded()) continue;
                    ++checkedSourceRoots;
                    continue;
                }
                ++classRoots;
                if (!nextRoot.isIncluded()) continue;
                ++checkedClassRoots;
            }
        }
        this.setPageComplete(checkedModules > 0);
        this.m_importCandidatesGroup.setText("Import Candidates [modules: " + checkedModules + "/" + modules + ", class roots: " + checkedClassRoots + "/" + classRoots + ", source roots: " + checkedSourceRoots + "/" + sourceRoots);
    }

    private void setImportCandidatesInteractionEnabled(boolean enable) {
        this.m_modulesFilterCheckBox.setEnabled(enable);
        this.m_rootDirectoriesFilterCheckBox.setEnabled(enable);
        this.m_textFilter.setEnabled(enable);
        this.m_collapseAll.setEnabled(enable);
        this.m_expandAll.setEnabled(enable);
        this.m_selectAll.setEnabled(enable);
        this.m_deselectAll.setEnabled(enable);
    }

    private void update() {
        this.m_selectDirectory.setImage(UiResourceManager.getInstance().getImage("OpenSystem"));
        this.m_selectDirectory.setText(SELECT_DIRECTORY);
        this.m_selectDirectory.setEnabled(true);
        this.m_detectImportCandidates.setImage(UiResourceManager.getInstance().getImage("StartDetection"));
        this.m_detectImportCandidates.setText(DETECT_IMPORT_CANDIDATES);
        this.m_detectImportCandidates.setEnabled(this.m_data != null && this.m_data.isImportCandidatesDetectionPossible());
        this.setImportCandidatesInteractionEnabled(this.m_data != null && this.m_data.hasImportCandidates());
        if (this.m_data != null) {
            StringBuilder info = new StringBuilder();
            info.append("Detected ").append(this.m_data.getNumberOfDetectedClassRoots()).append(" class and ").append(this.m_data.getNumberOfDetectedSourceRoots()).append(" source roots.");
            this.m_classRootSegments.showData((Collection)this.m_data.getClassRootSegments());
            this.m_sourceRootSegments.showData((Collection)this.m_data.getSourceRootSegments());
            this.m_classRootDefinitions.showData(this.m_data.getClassRootDefinitions());
            this.m_sourceRootDefinitions.showData(this.m_data.getSourceRootDefinitions());
            this.m_unassignedClassRoots.showData(this.m_data.getUnassignedClassRoots());
            this.m_unassignedSourceRoots.showData(this.m_data.getUnassignedSourceRoots());
            if (this.m_data.hasImportCandidatesDetectionBeenRun()) {
                ImportModuleCandidateUINode nextModuleNode;
                Set modules = this.m_data.getModuleCandidates();
                THashMap moduleToRootNodes = new THashMap(modules.size());
                ArrayList<ImportModuleCandidateUINode> moduleNodes = new ArrayList<ImportModuleCandidateUINode>(modules.size());
                for (ImportModuleCandidate importModuleCandidate : modules) {
                    nextModuleNode = new ImportModuleCandidateUINode(importModuleCandidate);
                    moduleNodes.add(nextModuleNode);
                    List nextRootPaths = importModuleCandidate.getRootPaths();
                    ArrayList<ImportRootDirectoryPathCandidateUINode> nextRootNodes = new ArrayList<ImportRootDirectoryPathCandidateUINode>(nextRootPaths.size());
                    for (ImportRootDirectoryPathCandidate nextRootPath : nextRootPaths) {
                        nextRootNodes.add(new ImportRootDirectoryPathCandidateUINode(nextRootPath, importModuleCandidate.getModulePath()));
                    }
                    moduleToRootNodes.put(nextModuleNode, nextRootNodes);
                }
                for (Map.Entry entry : moduleToRootNodes.entrySet()) {
                    nextModuleNode = (ImportModuleCandidateUINode)((Object)entry.getKey());
                    List nextSortedRootNodes = ((List)entry.getValue()).stream().sorted(Comparator.comparing(n -> n.getName().toLowerCase())).collect(Collectors.toList());
                    for (ImportRootDirectoryPathCandidateUINode nextRoot : nextSortedRootNodes) {
                        nextModuleNode.addChild((TreeNode)nextRoot);
                    }
                }
                List list = moduleNodes.stream().sorted(Comparator.comparing(n -> n.getName().toLowerCase())).collect(Collectors.toList());
                this.m_importCandidates.setInput(list);
                this.updataImportCandidates();
                info.append(TWEAK_RERUN);
            } else {
                this.setPageComplete(false);
                this.m_importCandidatesGroup.setText(IMPORT_CANDIDATES_DETECTION_NOT_RUN);
                this.m_importCandidates.setInput(null);
                info.append(TWEAK_RUN);
            }
            this.m_info.setText(info.toString());
        } else {
            this.m_info.setText(!this.m_startDirectory.getText().isEmpty() ? SELECT_DIRECTORY_INFO_NO_ROOTS_FOUND : SELECT_DIRECTORY_INFO);
            this.m_classRootSegments.showData(Collections.emptyList());
            this.m_sourceRootSegments.showData(Collections.emptyList());
            this.m_classRootDefinitions.showData(Collections.emptyList());
            this.m_sourceRootDefinitions.showData(Collections.emptyList());
            this.m_importCandidatesGroup.setText(IMPORT_CANDIDATES);
            this.m_unassignedClassRoots.showData(Collections.emptyList());
            this.m_unassignedSourceRoots.showData(Collections.emptyList());
            this.m_importCandidates.setInput(null);
            this.setPageComplete(false);
        }
    }

    private void stateChanged(UiTreeNode element) {
        if (element instanceof ImportModuleCandidateUINode) {
            ImportModuleCandidateUINode moduleCandidateNode = (ImportModuleCandidateUINode)element;
            ImportModuleCandidate moduleCandidate = (ImportModuleCandidate)moduleCandidateNode.getImportCandidate();
            moduleCandidate.setIncluded(element.isChecked());
        } else if (element instanceof ImportRootDirectoryPathCandidateUINode) {
            ((ImportRootDirectoryPathCandidate)((ImportRootDirectoryPathCandidateUINode)element).getImportCandidate()).setIncluded(element.isChecked());
        }
    }

    public final void handleStateChanged(UiTreeNode element) {
        if (!this.hasBeenDisposed()) {
            this.stateChanged(element);
            this.updataImportCandidates();
        }
    }

    public final void handleAllStatesChanged() {
        if (!this.hasBeenDisposed()) {
            for (UiTreeNode next : this.m_importCandidates.getInput()) {
                this.stateChanged(next);
                for (UiTreeNode root : next.getChildren()) {
                    this.stateChanged(root);
                }
            }
            this.updataImportCandidates();
        }
    }

    Set<ImportModuleCandidate> getModuleCandidates() {
        return this.m_data != null ? this.m_data.getModuleCandidates() : Collections.emptySet();
    }

    private void addSeparator(Menu menu) {
        assert (menu != null) : "Parameter 'menu' of method 'addSeparator' must not be null";
        if (menu.getItemCount() > 0 && menu.getItem(menu.getItemCount() - 1).getStyle() != 2) {
            new MenuItem(menu, 2);
        }
    }

    private void add(Control onControl, IContextMenuInteractionListener listener) {
        assert (onControl != null) : "Parameter 'onControl' of method 'add' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'add' must not be null";
        if (onControl == this.m_classRootSegments.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Add Class Root Segment", "Class Root Segment", this.m_provider.getClassRootSegmentValidator(this.m_data), "", null);
            if (dialog.open() == 0) {
                this.confirmRootDefintionsModificationAndRun(() -> this.m_data.addClassRootSegment(dialog.getName()));
            }
        } else if (onControl == this.m_sourceRootSegments.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Add Source Root Segment", "Source Root Segment", this.m_provider.getSourceRootSegmentValidator(this.m_data), "", null);
            if (dialog.open() == 0) {
                this.confirmRootDefintionsModificationAndRun(() -> this.m_data.addSourceRootSegment(dialog.getName()));
            }
        } else if (onControl == this.m_classRootDefinitions.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Add Class Root Definition", "Class Root Definition", this.m_provider.getClassRootDefinitionValidator(this.m_data), "", null);
            if (dialog.open() == 0) {
                this.m_data.addClassRootDefintion(dialog.getName());
            }
        } else if (onControl == this.m_sourceRootDefinitions.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Add Source Root Definition", "Source Root Definition", this.m_provider.getSourceRootDefinitionValidator(this.m_data), "", null);
            if (dialog.open() == 0) {
                this.m_data.addSourceRootDefinition(dialog.getName());
            }
        } else assert (false) : "Unhandled viewer: " + String.valueOf(onControl);
        listener.interactionFinished();
        this.update();
    }

    private void edit(Control onControl, String edit, IContextMenuInteractionListener listener) {
        assert (onControl != null) : "Parameter 'onControl' of method 'edit' must not be null";
        assert (edit != null && edit.length() > 0) : "Parameter 'edit' of method 'edit' must not be empty";
        assert (listener != null) : "Parameter 'listener' of method 'edit' must not be null";
        if (onControl == this.m_classRootSegments.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Edit Class Root Segment", "Class Root Segment", this.m_provider.getClassRootSegmentValidator(this.m_data), edit, null);
            if (dialog.open() == 0) {
                this.confirmRootDefintionsModificationAndRun(() -> {
                    this.m_data.deleteClassRootSegments(Collections.singletonList(edit));
                    this.m_data.addClassRootSegment(dialog.getName());
                });
            }
        } else if (onControl == this.m_sourceRootSegments.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Edit Source Root Segment", "Source Root Segment", this.m_provider.getSourceRootSegmentValidator(this.m_data), edit, null);
            if (dialog.open() == 0) {
                this.confirmRootDefintionsModificationAndRun(() -> {
                    this.m_data.deleteSourceRootSegments(Collections.singletonList(edit));
                    this.m_data.addSourceRootSegment(dialog.getName());
                });
            }
        } else if (onControl == this.m_classRootDefinitions.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Edit Class Root Definition", "Class Root Definition", this.m_provider.getClassRootDefinitionValidator(this.m_data), edit, null);
            if (dialog.open() == 0) {
                this.m_data.deleteClassRootDefintions(Collections.singletonList(edit));
                this.m_data.addClassRootDefintion(dialog.getName());
            }
        } else if (onControl == this.m_sourceRootDefinitions.getTable()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Edit Source Root Definition", "Source Root Definition", this.m_provider.getSourceRootDefinitionValidator(this.m_data), edit, null);
            if (dialog.open() == 0) {
                this.m_data.deleteSourceRootDefinitions(Collections.singletonList(edit));
                this.m_data.addSourceRootDefinition(dialog.getName());
            }
        } else if (onControl == this.m_importCandidates.getTree()) {
            NameAndDescriptionDialog dialog = new NameAndDescriptionDialog(this.getShell(), "Edit Module", "Module", this.m_provider.getModuleValidator(this.m_data), edit, null);
            if (dialog.open() == 0) {
                this.m_data.editModule(edit, dialog.getName());
            }
        } else assert (false) : "Unhandled viewer: " + String.valueOf(onControl);
        listener.interactionFinished();
        this.update();
    }

    private void delete(Control onControl, List<String> entries, IContextMenuInteractionListener listener) {
        assert (onControl != null) : "Parameter 'onControl' of method 'delete' must not be null";
        assert (entries != null && !entries.isEmpty()) : "Parameter 'entries' of method 'delete' must not be empty";
        assert (listener != null) : "Parameter 'listener' of method 'delete' must not be null";
        if (onControl == this.m_classRootSegments.getTable()) {
            this.confirmRootDefintionsModificationAndRun(() -> this.m_data.deleteClassRootSegments(entries));
        } else if (onControl == this.m_sourceRootSegments.getTable()) {
            this.confirmRootDefintionsModificationAndRun(() -> this.m_data.deleteSourceRootSegments(entries));
        } else if (onControl == this.m_classRootDefinitions.getTable()) {
            this.m_data.deleteClassRootDefintions(entries);
        } else if (onControl == this.m_sourceRootDefinitions.getTable()) {
            this.m_data.deleteSourceRootDefinitions(entries);
        } else assert (false) : "Unhandled viewer: " + String.valueOf(onControl);
        listener.interactionFinished();
        this.update();
    }

    public void aboutToShowContextMenu(Menu menu, final Control onControl, final IContextMenuInteractionListener listener) {
        assert (menu != null) : "Parameter 'menu' of method 'aboutToShowContextMenu' must not be null";
        assert (onControl != null) : "Parameter 'onControl' of method 'aboutToShowContextMenu' must not be null";
        assert (listener != null) : "Parameter 'listener' of method 'aboutToShowContextMenu' must not be null";
        if (this.m_data != null && this.m_workerContext == null) {
            String item;
            List selected;
            boolean isAddPossible;
            boolean isDeletePossible;
            if (onControl == this.m_classRootSegments.getTable()) {
                isDeletePossible = true;
                isAddPossible = true;
                selected = this.m_classRootSegments.getSelected();
                item = "Class Root Segment";
            } else if (onControl == this.m_sourceRootSegments.getTable()) {
                isDeletePossible = true;
                isAddPossible = true;
                selected = this.m_sourceRootSegments.getSelected();
                item = "Source Root Segment";
            } else if (onControl == this.m_classRootDefinitions.getTable()) {
                isDeletePossible = true;
                isAddPossible = true;
                selected = this.m_classRootDefinitions.getSelected();
                item = "Class Root Definition";
            } else if (onControl == this.m_sourceRootDefinitions.getTable()) {
                isDeletePossible = true;
                isAddPossible = true;
                selected = this.m_sourceRootDefinitions.getSelected();
                item = "Source Root Definition";
            } else if (onControl == this.m_importCandidates.getTree()) {
                isDeletePossible = false;
                isAddPossible = false;
                TreeItem[] treeItems = this.m_importCandidates.getTree().getSelection();
                item = "Module";
                if (treeItems != null && treeItems.length > 0) {
                    selected = new ArrayList(treeItems.length);
                    TreeItem[] treeItemArray = treeItems;
                    int n = treeItems.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem next = treeItemArray[n2];
                        Object nextData = next.getData();
                        if (nextData instanceof ImportModuleCandidateUINode) {
                            selected.add(((ImportModuleCandidateUINode)((Object)nextData)).getName());
                        }
                        ++n2;
                    }
                } else {
                    selected = Collections.emptyList();
                }
            } else {
                assert (false) : "Unhandled viewer: " + String.valueOf(onControl);
                isDeletePossible = false;
                isAddPossible = false;
                selected = null;
                item = null;
            }
            if (selected != null) {
                if (selected.size() == 1) {
                    MenuItem edit = new MenuItem(menu, 8);
                    edit.setText("Edit '" + item + "'...");
                    edit.setImage(UiResourceManager.getInstance().getImage("Edit"));
                    edit.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            JavaModulesBasedOnBuildUnitsWizardPage.this.edit(onControl, (String)selected.get(0), listener);
                        }
                    });
                    if (isDeletePossible) {
                        MenuItem delete = new MenuItem(menu, 8);
                        delete.setText("Delete '" + item + "'");
                        delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
                        delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                JavaModulesBasedOnBuildUnitsWizardPage.this.delete(onControl, selected, listener);
                            }
                        });
                    }
                } else if (selected.size() > 1 && isDeletePossible) {
                    MenuItem delete = new MenuItem(menu, 8);
                    delete.setText("Delete '" + item + "s'");
                    delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
                    delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            JavaModulesBasedOnBuildUnitsWizardPage.this.delete(onControl, selected, listener);
                        }
                    });
                }
                if (isAddPossible) {
                    this.addSeparator(menu);
                    MenuItem add = new MenuItem(menu, 8);
                    add.setText("Add '" + item + "'...");
                    add.setImage(UiResourceManager.getInstance().getImage("New"));
                    add.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            JavaModulesBasedOnBuildUnitsWizardPage.this.add(onControl, listener);
                        }
                    });
                }
            }
        }
    }

    static interface IInfoProvider {
        default public String getDefaultDirectory() {
            return null;
        }

        default public SoftwareSystem getSoftwareSystem() {
            return null;
        }
    }
}

