/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportModuleCandidate;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.java.model.externalimport.intellij.IIntelliJImportProvider;
import com.hello2morrow.sonargraph.languageprovider.java.model.path.JavaSupportingFileType;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.NewJavaModulesPage;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Set;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public final class NewJavaModulesFromIntelliJWizardLoadModulesPage
extends NewJavaModulesPage
implements SelectionListener {
    private ValidatingPathWidget m_textFieldProjectDirectory;
    private ValidatingPathWidget m_textFieldProjectFile;
    private ValidatingPathWidget m_textFieldDirectoryScan;
    private Button m_projectDirectoryRadioButton;
    private Button m_projectFileRadioButton;
    private Button m_directoryScanRadioButton;
    private IPathValidator m_projectDirectoryValidator;
    private IPathValidator m_projectFileValidator;
    private IPathValidator m_directoryScanValidator;

    public NewJavaModulesFromIntelliJWizardLoadModulesPage(String pageName, String description, boolean isCreation) {
        super(pageName, description, isCreation);
    }

    @Override
    protected IDialogId getDialogId() {
        return JavaDialogId.IMPORT_MODULE_JAVA_INTELLIJ_WIZARD_PAGE;
    }

    @Override
    protected void addSpecificContent(Composite parent) {
        assert (parent != null) : "Parameter 'parent' of method 'addSpecificContent' must not be null";
        ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        this.m_projectDirectoryRadioButton = new Button(parent, 16);
        this.m_projectDirectoryRadioButton.setText("Import from IntelliJ Project Directory (with '.idea' subdirectory)");
        this.m_projectDirectoryRadioButton.addSelectionListener((SelectionListener)this);
        this.m_projectDirectoryRadioButton.setSelection(true);
        this.m_projectDirectoryValidator = ((IIntelliJImportProvider)softwareSystemProvider.getInstallation().getExtension(IIntelliJImportProvider.class)).getProjectDirectoryValidator();
        this.m_textFieldProjectDirectory = new ValidatingPathWidget(parent, (ValidatingPathWidget.IConsumer)this, this.m_projectDirectoryValidator, 2, null, false);
        this.m_textFieldProjectDirectory.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_projectFileRadioButton = new Button(parent, 16);
        this.m_projectFileRadioButton.setText("Import from IntelliJ Project File ('*.ipr')");
        this.m_projectFileRadioButton.addSelectionListener((SelectionListener)this);
        this.m_projectFileValidator = ((IIntelliJImportProvider)softwareSystemProvider.getInstallation().getExtension(IIntelliJImportProvider.class)).getProjectFileValidator();
        this.m_textFieldProjectFile = new ValidatingPathWidget(parent, (ValidatingPathWidget.IConsumer)this, this.m_projectFileValidator, 2, null, false, false);
        this.m_textFieldProjectFile.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_textFieldProjectFile.setEnabled(false);
        this.m_textFieldProjectFile.setFilterExtensions(new String[]{"*" + JavaSupportingFileType.INTELLIJ_PROJECT_FILE.getDefaultExtension()});
        this.m_directoryScanRadioButton = new Button(parent, 16);
        this.m_directoryScanRadioButton.setText("Scan directory for IntelliJ Module Files ('*.iml')");
        this.m_directoryScanRadioButton.addSelectionListener((SelectionListener)this);
        this.m_directoryScanValidator = ((IIntelliJImportProvider)softwareSystemProvider.getInstallation().getExtension(IIntelliJImportProvider.class)).getDirectoryScanValidator();
        this.m_textFieldDirectoryScan = new ValidatingPathWidget(parent, (ValidatingPathWidget.IConsumer)this, this.m_directoryScanValidator, 2, null, false, false);
        this.m_textFieldDirectoryScan.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
    }

    @Override
    protected boolean isValidInput(TFile input) {
        if (this.m_projectDirectoryRadioButton.getSelection() && this.m_projectDirectoryValidator.isValid(null, input).isFailure()) {
            return false;
        }
        if (this.m_projectFileRadioButton.getSelection() && this.m_projectFileValidator.isValid(null, input).isFailure()) {
            return false;
        }
        return !this.m_directoryScanRadioButton.getSelection() || !this.m_directoryScanValidator.isValid(null, input).isFailure();
    }

    public final void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        if (event.getSource() == this.m_projectDirectoryRadioButton && this.m_projectDirectoryRadioButton.getSelection()) {
            this.resetProjectFile();
            this.resetDirectoryScan();
            this.m_textFieldProjectDirectory.setEnabled(true);
            this.m_textFieldProjectDirectory.validate();
            TFile currentInput = this.m_textFieldProjectDirectory.getCurrentFile();
            if (currentInput != null) {
                this.setPath(this.m_textFieldProjectDirectory.getCurrentFile(), true);
                return;
            }
        } else if (event.getSource() == this.m_projectFileRadioButton && this.m_projectFileRadioButton.getSelection()) {
            this.resetProjectDirectory();
            this.resetDirectoryScan();
            this.m_textFieldProjectFile.setEnabled(true);
            this.m_textFieldProjectFile.validate();
            TFile currentInput = this.m_textFieldProjectFile.getCurrentFile();
            if (currentInput != null) {
                this.setPath(this.m_textFieldProjectFile.getCurrentFile(), true);
                return;
            }
        } else if (event.getSource() == this.m_directoryScanRadioButton && this.m_directoryScanRadioButton.getSelection()) {
            this.resetProjectDirectory();
            this.resetProjectFile();
            this.m_textFieldDirectoryScan.setEnabled(true);
            this.m_textFieldDirectoryScan.validate();
            TFile currentInput = this.m_textFieldDirectoryScan.getCurrentFile();
            if (currentInput != null) {
                this.setPath(this.m_textFieldDirectoryScan.getCurrentFile(), true);
                return;
            }
        }
        this.setPath(null, true);
    }

    private void resetProjectDirectory() {
        if (!this.m_textFieldProjectDirectory.getText().isEmpty()) {
            this.m_textFieldProjectDirectory.reset();
        }
        this.m_textFieldProjectDirectory.clearDecoration();
        this.m_textFieldProjectDirectory.setEnabled(false);
    }

    private void resetProjectFile() {
        if (!this.m_textFieldProjectFile.getText().isEmpty()) {
            this.m_textFieldProjectFile.reset();
        }
        this.m_textFieldProjectFile.clearDecoration();
        this.m_textFieldProjectFile.setEnabled(false);
    }

    private void resetDirectoryScan() {
        if (!this.m_textFieldDirectoryScan.getText().isEmpty()) {
            this.m_textFieldDirectoryScan.reset();
        }
        this.m_textFieldDirectoryScan.clearDecoration();
        this.m_textFieldDirectoryScan.setEnabled(false);
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    @Override
    protected OperationResultWithOutcome<Set<ImportModuleCandidate>> detectModuleCandidates(IWorkerContext workerContext, ISoftwareSystemProvider provider, TFile dataSource) {
        assert (workerContext != null) : "Parameter 'workerContext' of method 'detectModuleCandidates' must not be null";
        assert (provider != null) : "Parameter 'provider' of method 'detectModuleCandidates' must not be null";
        assert (dataSource != null) : "Parameter 'dataSource' of method 'detectModuleCandidates' must not be null";
        return ((IIntelliJImportProvider)provider.getInstallation().getExtension(IIntelliJImportProvider.class)).getIntelliJImportCandidates(this.getMode(), workerContext, dataSource);
    }

    private IIntelliJImportProvider.Mode getMode() {
        if (this.m_projectDirectoryRadioButton.getSelection()) {
            return IIntelliJImportProvider.Mode.PROJECT_DIRECTORY;
        }
        if (this.m_projectFileRadioButton.getSelection()) {
            return IIntelliJImportProvider.Mode.PROJECT_FILE;
        }
        if (this.m_directoryScanRadioButton.getSelection()) {
            return IIntelliJImportProvider.Mode.DIRECTORY_SCAN;
        }
        assert (false) : "Missing mode because radio button has no selection";
        return null;
    }
}

