/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.tree.TreeNode;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.activity.ActivityMode;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IJavaWorkspaceProvider;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathCollector;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.IRootDirectoryPathDetectionConsumer;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.RootDirectoryPathsModification;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.LabelBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DragSourceAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.DropTargetAdapter;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.StandardUiTreeNodeContentAndLabelProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.AvailableModulesNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.DetectedRootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ExistingRootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaDialogId;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.JavaModuleNode;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ManageRootDirectoryPathsModel;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.ManageRootDirectoryPathsViewSorter;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.RootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.swt.base.PreferencesUtility;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.DropLocation;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

final class ManageRootPathsWizardPage
extends StandardWizardPage
implements IRootDirectoryPathDetectionConsumer,
ValidatingPathWidget.IConsumer,
DropTargetAdapter.IDropTargetActionHandler<UiTreeNode>,
SelectionListener {
    private static final String INCLUDE_PATHS_STARTING_WITH_DOT = "includePathsStartingWithDot";
    private static final String INCLUDE_ZIP = "includeZip";
    private static final String NESTED_INCLUDE_ZIP = "includeNestedZip";
    private IPathValidator m_pathValidator;
    private IRootDirectoryPathCollector m_collector;
    private StandardUiTreeNodeContentAndLabelProvider m_contentAndLabelProvider;
    private ManageRootDirectoryPathsModel m_model;
    private LabelBasedWorkerContext m_workerContext;
    private ValidatingPathWidget m_validatingPathWidget;
    private TFile m_directory;
    private Button m_includePathsStartingWithDot;
    private Button m_includeZips;
    private Button m_includeNestedZips;
    private Button m_detect;
    private TreeViewer m_pathsViewer;
    private TreeViewer m_modulesViewer;
    private Label m_progressLabel;
    private boolean m_currentIncludePathsStartingWithDot;
    private boolean m_currentIncludeZips;
    private boolean m_currentIncludeNestedZips;

    public ManageRootPathsWizardPage() {
        super("Manage Root Paths", "Manage Java Root Directories/Archives");
    }

    protected int getNumberOfColumns() {
        return 2;
    }

    private void applySettings() {
        IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone.java", (IDialogId)JavaDialogId.MANAGE_ROOT_DIRECTORY_PATHS_WIZARD_PAGE);
        assert (settings != null) : "'settings' of method 'createContent' must not be null";
        this.m_includePathsStartingWithDot.setSelection(settings.getBoolean(INCLUDE_PATHS_STARTING_WITH_DOT, false));
        boolean isZipIncluded = settings.getBoolean(INCLUDE_ZIP, false);
        this.m_includeZips.setSelection(isZipIncluded);
        if (isZipIncluded) {
            this.m_includeNestedZips.setSelection(settings.getBoolean(NESTED_INCLUDE_ZIP, false));
            this.m_includeNestedZips.setEnabled(true);
        } else {
            this.m_includeNestedZips.setSelection(false);
            this.m_includeNestedZips.setEnabled(false);
        }
        this.m_currentIncludePathsStartingWithDot = this.m_includePathsStartingWithDot.getSelection();
        this.m_currentIncludeZips = this.m_includeZips.getSelection();
        this.m_currentIncludeNestedZips = this.m_includeNestedZips.getSelection();
    }

    private void saveSettings() {
        if (!this.hasBeenDisposed()) {
            IEclipsePreferences settings = PreferencesUtility.getPreferences((String)"com.hello2morrow.sonargraph.standalone.java", (IDialogId)JavaDialogId.MANAGE_ROOT_DIRECTORY_PATHS_WIZARD_PAGE);
            assert (settings != null) : "'settings' of method 'dispose' must not be null";
            settings.putBoolean(INCLUDE_PATHS_STARTING_WITH_DOT, this.m_includePathsStartingWithDot.getSelection());
            settings.putBoolean(INCLUDE_ZIP, this.m_includeZips.getSelection());
            settings.putBoolean(NESTED_INCLUDE_ZIP, this.m_includeNestedZips.getSelection());
        }
    }

    private void startDetection() {
        assert (this.m_workerContext == null) : "'m_workerContext' of method 'startDetection' must be null";
        this.m_model.reset();
        this.m_pathsViewer.getControl().setRedraw(false);
        this.m_pathsViewer.refresh();
        this.m_pathsViewer.getControl().setRedraw(true);
        this.m_detect.setText("Stop");
        this.m_detect.setImage(UiResourceManager.getInstance().getImage("StopDetection"));
        this.m_progressLabel.setText("Ready");
        this.m_modulesViewer.getControl().setEnabled(false);
        this.m_pathsViewer.getControl().setEnabled(false);
        this.m_workerContext = new LabelBasedWorkerContext(this.m_progressLabel, 100);
        this.m_workerContext.start("Start detection", ActivityMode.NONE, false);
        this.m_collector.collect((IRootDirectoryPathDetectionConsumer)this, (IWorkerContext)this.m_workerContext, this.m_directory, this.m_currentIncludePathsStartingWithDot, this.m_currentIncludeZips, this.m_currentIncludeNestedZips);
        this.m_workerContext.stop();
        this.m_workerContext = null;
        this.stopDetection();
        this.validate();
    }

    private void validate() {
        if (!this.hasBeenDisposed()) {
            this.setPageComplete(this.m_model.rootPathsModified());
        }
    }

    private void stopDetection() {
        if (this.m_workerContext != null) {
            this.m_workerContext.cancel();
        }
        if (!this.hasBeenDisposed() && this.getShell() != null && !this.getShell().isDisposed()) {
            this.m_detect.setText("Detect");
            this.m_detect.setImage(UiResourceManager.getInstance().getImage("StartDetection"));
            StringBuilder builder = new StringBuilder("Ready");
            builder.append(" (found ");
            builder.append(this.m_model.getNumberOfAvailableRootPaths());
            builder.append(" assignable root directories/archives)");
            this.m_progressLabel.setText(builder.toString());
            this.m_modulesViewer.getControl().setEnabled(true);
            this.m_pathsViewer.getControl().setEnabled(true);
            this.validate();
        }
    }

    protected void createContent(Composite composite) {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "No system available";
        SoftwareSystem softwareSystem = provider.getSoftwareSystem();
        IJavaWorkspaceProvider workspaceProvider = (IJavaWorkspaceProvider)softwareSystem.getExtension(IJavaWorkspaceProvider.class);
        this.m_model = new ManageRootDirectoryPathsModel(softwareSystem);
        this.m_directory = softwareSystem.getDirectoryFile();
        this.m_pathValidator = workspaceProvider.getDetectRootDirectoryPathsStartPathValidator();
        this.m_collector = workspaceProvider.getRootDirectoryPathsDetector();
        this.m_contentAndLabelProvider = new StandardUiTreeNodeContentAndLabelProvider();
        this.m_includePathsStartingWithDot = new Button(composite, 32);
        this.m_includePathsStartingWithDot.setText("Include paths starting with '.'");
        this.m_includePathsStartingWithDot.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.m_includePathsStartingWithDot.addSelectionListener((SelectionListener)this);
        this.m_includeZips = new Button(composite, 32);
        this.m_includeZips.setText("Include ZIP format archives (*.zip, *.jar, *.war, *.ear)");
        this.m_includeZips.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.m_includeZips.addSelectionListener((SelectionListener)this);
        this.m_includeNestedZips = new Button(composite, 32);
        this.m_includeNestedZips.setText("Include nested ZIP format archives (i.e. archives contained in others)");
        this.m_includeNestedZips.setLayoutData((Object)new GridData(16384, 128, false, false, 2, 1));
        this.m_includeNestedZips.setEnabled(false);
        this.m_includeNestedZips.addSelectionListener((SelectionListener)this);
        this.m_validatingPathWidget = new ValidatingPathWidget(composite, (ValidatingPathWidget.IConsumer)this, this.m_pathValidator, 2, this.m_directory, false);
        this.m_validatingPathWidget.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.m_validatingPathWidget.getBrowseButton().setFocus();
        this.m_detect = new Button(composite, 0x800008);
        this.m_detect.setText("Detect");
        this.m_detect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ManageRootPathsWizardPage.this.m_workerContext == null) {
                    if (ManageRootPathsWizardPage.this.m_directory != null) {
                        ManageRootPathsWizardPage.this.m_validatingPathWidget.setPath(ManageRootPathsWizardPage.this.m_directory.getAbsolutePath());
                        if (ManageRootPathsWizardPage.this.m_directory.exists() && ManageRootPathsWizardPage.this.m_directory.isDirectory() && ManageRootPathsWizardPage.this.m_directory.canRead()) {
                            ManageRootPathsWizardPage.this.startDetection();
                        }
                    }
                } else {
                    ManageRootPathsWizardPage.this.stopDetection();
                }
            }
        });
        this.m_detect.setImage(UiResourceManager.getInstance().getImage("StartDetection"));
        this.m_detect.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label separator = new Label(composite, 258);
        separator.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        Label dragAndDropDescription = new Label(composite, 64);
        dragAndDropDescription.setText("Use drag and drop to assign detected root directories/archives on the right to existing modules on the left.\nRemove already assigned root directories/archives on the left by dragging them to the right.");
        dragAndDropDescription.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        SashForm sashForm = new SashForm(composite, 256);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.m_modulesViewer = new TreeViewer((Composite)sashForm, 65538);
        this.m_modulesViewer.setContentProvider((IContentProvider)this.m_contentAndLabelProvider);
        this.m_modulesViewer.setLabelProvider((IBaseLabelProvider)this.m_contentAndLabelProvider);
        this.m_modulesViewer.setInput((Object)this.m_model.getAvailableModules());
        this.m_pathsViewer = new TreeViewer((Composite)sashForm, 65538);
        this.m_pathsViewer.setContentProvider((IContentProvider)this.m_contentAndLabelProvider);
        this.m_pathsViewer.setLabelProvider((IBaseLabelProvider)this.m_contentAndLabelProvider);
        this.m_pathsViewer.setComparator((ViewerComparator)new ManageRootDirectoryPathsViewSorter(this.m_model.getAvailableRootDirectoryPathsNode()));
        this.m_pathsViewer.setInput((Object)this.m_model.getAvailableRootDirectoryPaths());
        SwtUtility.applySashSeparatorStyle((SashForm)sashForm);
        sashForm.setWeights(new int[]{40, 60});
        this.m_progressLabel = new Label(composite, 0);
        this.m_progressLabel.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_progressLabel.setText("Ready");
        ArrayList<Class<DetectedRootDirectoryPathNode>> modulesViewerDropClasses = new ArrayList<Class<DetectedRootDirectoryPathNode>>(4);
        modulesViewerDropClasses.add(JavaModuleNode.class);
        modulesViewerDropClasses.add(ExistingRootDirectoryPathNode.class);
        modulesViewerDropClasses.add(DetectedRootDirectoryPathNode.class);
        DropTargetAdapter modulesViewerTargetAdapter = new DropTargetAdapter((StructuredViewer)this.m_modulesViewer, (DropTargetAdapter.IDropTargetActionHandler)this, modulesViewerDropClasses, false);
        ArrayList<Class> pathsViewerDragClasses = new ArrayList<Class>(2);
        pathsViewerDragClasses.add(DetectedRootDirectoryPathNode.class);
        pathsViewerDragClasses.add(ExistingRootDirectoryPathNode.class);
        new DragSourceAdapter((StructuredViewer)this.m_pathsViewer, 2, Collections.singletonList(modulesViewerTargetAdapter), pathsViewerDragClasses);
        ArrayList<Class> pathsViewerDropClasses = new ArrayList<Class>();
        pathsViewerDropClasses.add(ExistingRootDirectoryPathNode.class);
        pathsViewerDropClasses.add(DetectedRootDirectoryPathNode.class);
        DropTargetAdapter pathsViewerTargetAdapter = new DropTargetAdapter((StructuredViewer)this.m_pathsViewer, (DropTargetAdapter.IDropTargetActionHandler)this, pathsViewerDropClasses, true);
        ArrayList<Class<DetectedRootDirectoryPathNode>> modulesViewerDragClasses = new ArrayList<Class<DetectedRootDirectoryPathNode>>();
        modulesViewerDragClasses.add(JavaModuleNode.class);
        modulesViewerDragClasses.add(ExistingRootDirectoryPathNode.class);
        modulesViewerDragClasses.add(DetectedRootDirectoryPathNode.class);
        ArrayList<DropTargetAdapter> modulesViewerDropTargetAdapters = new ArrayList<DropTargetAdapter>(2);
        modulesViewerDropTargetAdapters.add(pathsViewerTargetAdapter);
        modulesViewerDropTargetAdapters.add(modulesViewerTargetAdapter);
        new DragSourceAdapter((StructuredViewer)this.m_modulesViewer, 2, modulesViewerDropTargetAdapters, modulesViewerDragClasses);
        this.applySettings();
        this.setPageComplete(false);
    }

    public void dispose() {
        this.stopDetection();
        this.saveSettings();
        super.dispose();
    }

    RootDirectoryPathsModification getModification() {
        assert (this.m_model != null) : "'m_model' of method 'getModification' must not be null";
        assert (this.m_model.rootPathsModified()) : "No modification";
        return this.m_model.getModification();
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        if (event.getSource() == this.m_includePathsStartingWithDot) {
            this.m_currentIncludePathsStartingWithDot = this.m_includePathsStartingWithDot.getSelection();
        } else if (event.getSource() == this.m_includeZips) {
            this.m_currentIncludeZips = this.m_includeZips.getSelection();
            if (this.m_currentIncludeZips) {
                this.m_includeNestedZips.setEnabled(true);
            } else {
                this.m_includeNestedZips.setSelection(false);
                this.m_includeNestedZips.setEnabled(false);
            }
        } else if (event.getSource() == this.m_includeNestedZips) {
            this.m_currentIncludeNestedZips = this.m_includeNestedZips.getSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    private void assign(List<RootDirectoryPathNode> dropped, JavaModuleNode targetModuleNode, int targetPosition) {
        assert (targetModuleNode != null) : "Parameter 'targetModuleNode' of method 'assign' must not be null";
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'assign' must not be empty";
        int numberOfAlreadyDropped = 0;
        for (RootDirectoryPathNode nextDropped : dropped) {
            this.m_model.assign(nextDropped, targetModuleNode, targetPosition + numberOfAlreadyDropped);
            ++numberOfAlreadyDropped;
        }
    }

    private void unassign(List<RootDirectoryPathNode> dropped) {
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'unassign' must not be empty";
        ArrayList<RootDirectoryPathNode> notAlreadyUnassigned = new ArrayList<RootDirectoryPathNode>();
        for (UiTreeNode uiTreeNode : dropped) {
            if (uiTreeNode.getParent() == this.m_model.getAvailableRootDirectoryPathsNode()) continue;
            notAlreadyUnassigned.add((RootDirectoryPathNode)uiTreeNode);
        }
        for (RootDirectoryPathNode rootDirectoryPathNode : notAlreadyUnassigned) {
            this.m_model.unassign(rootDirectoryPathNode);
        }
    }

    private void assignWithTargetPosition(List<RootDirectoryPathNode> dropped, UiTreeNode target, DropLocation location) {
        assert (dropped != null && !dropped.isEmpty()) : "Parameter 'dropped' of method 'assignWithTargetPosition' must not be empty";
        assert (target != null) : "Parameter 'target' of method 'determineTargetPosition' must not be null";
        assert (location != null) : "Parameter 'location' of method 'determineTargetPosition' must not be null";
        UiTreeNode treeNode = (UiTreeNode)target.getParent();
        assert (treeNode instanceof JavaModuleNode) : "Not a module node: " + String.valueOf(treeNode);
        JavaModuleNode moduleNode = (JavaModuleNode)treeNode;
        int pos = moduleNode.getIndexOf((TreeNode)target);
        int targetPos = DropTargetAdapter.convertToPosition((DropLocation)location, (int)pos, (int)moduleNode.getNumberOfChildren());
        this.assign(dropped, moduleNode, targetPos);
    }

    public boolean perform(UiTreeNode target, DropLocation location, List<UiTreeNode> dropped, StructuredViewer viewer) {
        assert (dropped != null && dropped.size() > 0) : "Parameter 'dropped' of method 'perform' must not be empty";
        ArrayList<JavaModuleNode> droppedModuleNodes = new ArrayList<JavaModuleNode>();
        ArrayList<RootDirectoryPathNode> droppedRootDirectoryPathNodes = new ArrayList<RootDirectoryPathNode>();
        for (UiTreeNode nextDropped : dropped) {
            if (nextDropped instanceof JavaModuleNode) {
                droppedModuleNodes.add((JavaModuleNode)nextDropped);
                continue;
            }
            if (nextDropped instanceof RootDirectoryPathNode) {
                droppedRootDirectoryPathNodes.add((RootDirectoryPathNode)nextDropped);
                continue;
            }
            assert (false) : "Unexpected class: " + nextDropped.getClass().getName();
        }
        if (!droppedModuleNodes.isEmpty() && !droppedRootDirectoryPathNodes.isEmpty()) {
            return false;
        }
        if (target instanceof JavaModuleNode) {
            JavaModuleNode moduleNode = (JavaModuleNode)target;
            if (!droppedModuleNodes.isEmpty()) {
                this.move(droppedModuleNodes, target, location);
            } else {
                this.assign(droppedRootDirectoryPathNodes, moduleNode, moduleNode.getNumberOfChildren());
            }
        } else {
            if (droppedRootDirectoryPathNodes.isEmpty()) {
                return false;
            }
            boolean unassign = false;
            if (target instanceof ExistingRootDirectoryPathNode) {
                if (target.getParent() == this.m_model.getAvailableRootDirectoryPathsNode()) {
                    unassign = true;
                } else {
                    this.assignWithTargetPosition(droppedRootDirectoryPathNodes, target, location);
                }
            } else if (target instanceof DetectedRootDirectoryPathNode) {
                if (target.getParent() == this.m_model.getAvailableRootDirectoryPathsNode()) {
                    unassign = true;
                } else {
                    this.assignWithTargetPosition(droppedRootDirectoryPathNodes, target, location);
                }
            } else {
                unassign = true;
            }
            if (unassign) {
                this.unassign(droppedRootDirectoryPathNodes);
            }
        }
        this.validate();
        if (target != null) {
            this.m_modulesViewer.setExpandedState((Object)target, true);
        }
        this.m_modulesViewer.refresh();
        this.m_pathsViewer.refresh();
        return true;
    }

    private void move(List<JavaModuleNode> moduleNodes, UiTreeNode target, DropLocation location) {
        assert (moduleNodes != null && !moduleNodes.isEmpty()) : "Parameter 'moduleNodes' of method 'move' must not be empty";
        assert (target != null) : "Parameter 'target' of method 'move' must not be null";
        assert (location != null) : "Parameter 'location' of method 'move' must not be null";
        UiTreeNode treeNode = (UiTreeNode)target.getParent();
        assert (treeNode instanceof AvailableModulesNode) : "Not an available modules node: " + String.valueOf(treeNode);
        AvailableModulesNode availableModulesNode = (AvailableModulesNode)treeNode;
        int pos = availableModulesNode.getIndexOf((TreeNode)target);
        int targetPosition = DropTargetAdapter.convertToPosition((DropLocation)location, (int)pos, (int)availableModulesNode.getNumberOfChildren());
        int numberOfAlreadyDropped = 0;
        for (JavaModuleNode nextDropped : moduleNodes) {
            this.m_model.move(nextDropped, availableModulesNode, targetPosition + numberOfAlreadyDropped);
            ++numberOfAlreadyDropped;
        }
    }

    public void setPath(TFile input, boolean inputModified) {
        this.m_directory = input;
    }

    public void found(DetectedRootDirectoryPath candidate) {
        assert (candidate != null) : "Parameter 'candidate' of method 'found' must not be null";
        if (this.getShell() != null && !this.getShell().isDisposed()) {
            this.m_model.add(candidate);
            this.m_pathsViewer.getControl().setRedraw(false);
            this.m_pathsViewer.refresh();
            if (this.m_model.getNumberOfAvailableRootPaths() == 1) {
                this.m_pathsViewer.expandToLevel((Object)this.m_model.getAvailableRootDirectoryPathsNode(), 1);
            }
            this.m_pathsViewer.getControl().setRedraw(true);
        }
    }

    public boolean ignoreClassRootDirectory(TFile file) {
        assert (this.m_model != null) : "Parameter 'm_model' of method 'ignoreClassRootDirectory' must not be null";
        return this.m_model.isAlreadyClassRootDirectory(file);
    }

    public boolean ignoreSourceRootDirectory(TFile file) {
        assert (this.m_model != null) : "Parameter 'm_model' of method 'ignoreSourceRootDirectory' must not be null";
        return this.m_model.isAlreadySourceRootDirectory(file);
    }

    protected IDialogId getDialogId() {
        return JavaDialogId.MANAGE_ROOT_DIRECTORY_PATHS_WIZARD_PAGE;
    }
}

