/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.core.model.workspaceimport.ImportCandidate;
import com.hello2morrow.sonargraph.ui.standalone.base.swt.UiTreeNode;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

abstract class ImportCandidateUINode<T extends ImportCandidate>
extends UiTreeNode {
    private final T m_importCandidate;
    private boolean m_hasBrokenDependency;

    ImportCandidateUINode(T candidate) {
        assert (candidate != null) : "Parameter 'candidate' of method 'ImportCandidateUINode' must not be null";
        this.m_importCandidate = candidate;
        this.setChecked(candidate.isIncluded());
    }

    public abstract String getName();

    public final Image getImage() {
        CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor(this.getImportCandidate().getImageResourceName());
        if (this.hasBrokenDependency() || this.getImportCandidate().getWarning() != null) {
            compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "WarningMarker");
        }
        if (this.getImportCandidate().getError() != null) {
            compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "ErrorMarker");
        }
        return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
    }

    public final T getImportCandidate() {
        return this.m_importCandidate;
    }

    public final void setHasBrokenDependency(boolean hasBrokenDependency) {
        this.m_hasBrokenDependency = hasBrokenDependency;
    }

    public final boolean hasBrokenDependency() {
        return this.m_hasBrokenDependency;
    }
}

