/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.workspaceview;

import com.hello2morrow.sonargraph.languageprovider.java.model.system.DetectedRootDirectoryPath;
import com.hello2morrow.sonargraph.ui.standalone.workspaceview.RootDirectoryPathNode;
import com.hello2morrow.sonargraph.ui.swt.base.CompositeImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.DecoratingImageDescriptor;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import org.eclipse.swt.graphics.Image;

final class DetectedRootDirectoryPathNode
extends RootDirectoryPathNode {
    private final String m_name;
    private final DetectedRootDirectoryPath m_detectedRootDirectoryPath;

    DetectedRootDirectoryPathNode(String name, DetectedRootDirectoryPath detectedRootDirectoryPath) {
        assert (name != null && name.length() > 0) : "Parameter 'name' of method 'DetectedRootDirectoryPathNode' must not be empty";
        assert (detectedRootDirectoryPath != null) : "Parameter 'detectedRootDirectoryPath' of method 'DetectedRootDirectoryPathNode' must not be null";
        this.m_name = name;
        this.m_detectedRootDirectoryPath = detectedRootDirectoryPath;
    }

    public DetectedRootDirectoryPath getDetectedRootDirectoryPath() {
        return this.m_detectedRootDirectoryPath;
    }

    public String getName() {
        return this.m_name;
    }

    public boolean isClassRootDirectory() {
        switch (this.m_detectedRootDirectoryPath.getType()) {
            case CLASSES_DIRECTORY: 
            case CLASSES_ARCHIVE: {
                return true;
            }
            case SOURCE_DIRECTORY: 
            case SOURCE_ARCHIVE: {
                return false;
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf(this.m_detectedRootDirectoryPath.getType());
        return false;
    }

    public boolean isSourceRootDirectory() {
        switch (this.m_detectedRootDirectoryPath.getType()) {
            case CLASSES_DIRECTORY: 
            case CLASSES_ARCHIVE: {
                return false;
            }
            case SOURCE_DIRECTORY: 
            case SOURCE_ARCHIVE: {
                return true;
            }
        }
        assert (false) : "Unhandled type: " + String.valueOf(this.m_detectedRootDirectoryPath.getType());
        return false;
    }

    public Image getImage() {
        String imageResource = null;
        switch (this.m_detectedRootDirectoryPath.getType()) {
            case CLASSES_ARCHIVE: {
                imageResource = "RootArchivePath";
                break;
            }
            case CLASSES_DIRECTORY: {
                imageResource = "RootDirectoryPath";
                break;
            }
            case SOURCE_ARCHIVE: {
                imageResource = "JavaSourceRootArchivePath";
                break;
            }
            case SOURCE_DIRECTORY: {
                imageResource = "JavaSourceRootDirectoryPath";
                break;
            }
            default: {
                assert (false) : "Unhandled type: " + String.valueOf(this.m_detectedRootDirectoryPath.getType());
                return null;
            }
        }
        CompositeImageDescriptor compositeImageDescriptor = new CompositeImageDescriptor(imageResource);
        compositeImageDescriptor.addMarker(DecoratingImageDescriptor.Corner.UPPER_RIGHT, "QuestionMarker");
        return UiResourceManager.getInstance().getImage(compositeImageDescriptor);
    }
}

