/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.go.wizard;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.command.system.AddNewGoModulesCommand;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.go.wizard.SelectGoModulesPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class GoModuleWizard
extends NonLazySonargraphWizard
implements IDirectoryProvider {
    private SelectGoModulesPage m_moduleSelectionPage;

    public GoModuleWizard() {
        super("New System based on go.mod Files");
    }

    public TFile getDirectory() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        assert (provider.hasSoftwareSystem()) : "Wizard requires existing software system";
        SoftwareSystem system = provider.getSoftwareSystem();
        return system.getBaseDirectoryFile();
    }

    public void addPages() {
        this.m_moduleSelectionPage = new SelectGoModulesPage("PAGE_2", this, false);
        this.addPage((SonargraphWizardPage)this.m_moduleSelectionPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            Interaction interaction = new Interaction();
            AddNewGoModulesCommand command = new AddNewGoModulesCommand(WorkbenchRegistry.getInstance().getProvider(), (AddNewGoModulesCommand.IInteraction)interaction);
            UserInterfaceAdapter.getInstance().run((Command)command);
            return true;
        }
        return false;
    }

    private final class Interaction
    extends SaveCommandInteraction
    implements AddNewGoModulesCommand.IInteraction {
        public Interaction() {
            super(false);
        }

        public boolean collect(AddNewGoModulesCommand.ModuleCreationData data) {
            List<TFile> selectedModuleFiles = GoModuleWizard.this.m_moduleSelectionPage.getSelectedModuleFiles();
            if (selectedModuleFiles.isEmpty()) {
                return false;
            }
            selectedModuleFiles.forEach(f -> data.addGoModFile(f));
            return true;
        }

        public void processModuleCreationResult(OperationResult result) {
            if (!result.isEmpty()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

