/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.go.wizard;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Workspace;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.languageprovider.go.model.IGoWorkspaceProvider;
import com.hello2morrow.sonargraph.languageprovider.go.model.path.GoFileType;
import com.hello2morrow.sonargraph.languageprovider.go.model.workspace.GoModule;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.go.wizard.ModuleFileBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;

final class SelectGoModulesPage
extends StandardWizardPage {
    private final IDirectoryProvider m_directoryProvider;
    private final boolean m_searchForGoModFiles;
    private List<TFile> m_selectedModuleFiles = null;
    private final List<TFile> m_existingModuleFiles = new ArrayList<TFile>();
    private PropertyTableViewer<TFile> m_filesTable;
    private Button m_add;
    private Button m_delete;
    private Button m_up;
    private Button m_down;

    SelectGoModulesPage(String pageName, IDirectoryProvider dirProvider, boolean searchForGoModFiles) {
        super(pageName, "Select Go modules via go.mod files");
        this.m_directoryProvider = dirProvider;
        this.setPageComplete(false);
        this.m_searchForGoModFiles = searchForGoModFiles;
    }

    protected PropertyTableViewer<TFile> createPropertyTableViewer(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'createPropertyTableViewer' must not be null";
        PropertyTableViewer fileTable = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ModuleFileBeanAdapter("GoModule"), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        fileTable.addColumn("Go Module File", "file", "file", "fileImage", 100, PropertyTableViewer.ColumnType.TEXT);
        fileTable.setLayoutData((Object)new GridData(4, 4, true, true));
        return fileTable;
    }

    private void applyModification(TFile select) {
        this.m_filesTable.showData(this.m_selectedModuleFiles);
        this.m_filesTable.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
        this.setPageComplete(this.m_selectedModuleFiles.size() > 0);
    }

    protected void createContent(Composite composite) {
        assert (composite != null) : "Parameter 'composite' of method 'fillDialogArea' must not be null";
        this.m_filesTable = this.createPropertyTableViewer(composite);
        this.m_filesTable.getTableViewer().addSelectionChangedListener((ISelectionChangedListener)new FileSelectionListener());
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        ButtonListener buttonListener = new ButtonListener();
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_add.addSelectionListener((SelectionListener)buttonListener);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((SelectionListener)buttonListener);
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        this.m_up.addSelectionListener((SelectionListener)buttonListener);
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        this.m_down.addSelectionListener((SelectionListener)buttonListener);
        this.m_delete.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
    }

    List<TFile> getSelectedModuleFiles() {
        return Collections.unmodifiableList(this.m_selectedModuleFiles);
    }

    public void setVisible(boolean visible) {
        if (visible && this.m_selectedModuleFiles == null) {
            if (this.m_searchForGoModFiles) {
                ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                IGoWorkspaceProvider wsExt = (IGoWorkspaceProvider)provider.getInstallation().getExtension(IGoWorkspaceProvider.class);
                this.m_selectedModuleFiles = wsExt.findGoModuleFiles(this.m_directoryProvider.getDirectory());
            } else {
                this.m_selectedModuleFiles = new ArrayList<TFile>();
                ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
                assert (provider.hasSoftwareSystem()) : "Wizard requires existing software system";
                SoftwareSystem system = provider.getSoftwareSystem();
                List modules = ((Workspace)system.getUniqueExistingChild(Workspace.class)).getChildren(GoModule.class);
                modules.forEach(m -> {
                    boolean bl = this.m_existingModuleFiles.add(m.getGoModFile());
                });
            }
            this.m_filesTable.showData(this.m_selectedModuleFiles);
            this.applyModification(null);
        }
        super.setVisible(visible);
    }

    private class ButtonListener
    implements SelectionListener {
        private ButtonListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
            List selected = SelectGoModulesPage.this.m_filesTable.getSelected();
            Object source = event.getSource();
            if (source == SelectGoModulesPage.this.m_add) {
                FileDialog fileDialog = new FileDialog(SelectGoModulesPage.this.getShell(), 4096);
                fileDialog.setFilterPath(SelectGoModulesPage.this.m_directoryProvider.getDirectory().getNormalizedAbsolutePath());
                fileDialog.setText("Select a go.mod file");
                fileDialog.setFilterExtensions(GoFileType.MODULE_FILE.getExtensions());
                String path = fileDialog.open();
                if (path != null) {
                    TFile newModuleFile = new TFile(path);
                    if (SelectGoModulesPage.this.m_existingModuleFiles.contains(newModuleFile = newModuleFile.getNormalizedAbsoluteFile())) {
                        UserInterfaceAdapter.getInstance().error("Duplicate Module File", "This file was already added!");
                    } else if (newModuleFile.getName().equals("go.mod") && !SelectGoModulesPage.this.m_selectedModuleFiles.contains(newModuleFile)) {
                        SelectGoModulesPage.this.m_selectedModuleFiles.add(newModuleFile);
                        SelectGoModulesPage.this.m_existingModuleFiles.add(newModuleFile);
                        SelectGoModulesPage.this.applyModification(newModuleFile);
                    }
                }
            } else if (source == SelectGoModulesPage.this.m_delete) {
                SelectGoModulesPage.this.m_selectedModuleFiles.removeAll(selected);
                SelectGoModulesPage.this.m_existingModuleFiles.removeAll(selected);
                SelectGoModulesPage.this.applyModification(null);
            } else if (source == SelectGoModulesPage.this.m_up) {
                assert (selected.size() == 1) : "Only one selected element expected";
                TFile move = (TFile)selected.get(0);
                int pos = SelectGoModulesPage.this.m_selectedModuleFiles.indexOf(move);
                TFile replaced = SelectGoModulesPage.this.m_selectedModuleFiles.set(pos - 1, move);
                SelectGoModulesPage.this.m_selectedModuleFiles.set(pos, replaced);
                SelectGoModulesPage.this.applyModification(move);
            } else if (source == SelectGoModulesPage.this.m_down) {
                assert (selected.size() == 1) : "Only one selected element expected";
                TFile move = (TFile)selected.get(0);
                int pos = SelectGoModulesPage.this.m_selectedModuleFiles.indexOf(move);
                TFile replaced = SelectGoModulesPage.this.m_selectedModuleFiles.set(pos + 1, move);
                SelectGoModulesPage.this.m_selectedModuleFiles.set(pos, replaced);
                SelectGoModulesPage.this.applyModification(move);
            } else assert (false) : "Unhandled source: " + String.valueOf(source);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    }

    private class FileSelectionListener
    implements ISelectionChangedListener {
        private FileSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
            assert (event.getSource() == SelectGoModulesPage.this.m_filesTable.getTableViewer()) : "Unexpected source: " + String.valueOf(event.getSelectionProvider());
            List selected = SelectGoModulesPage.this.m_filesTable.getSelected();
            if (selected.size() == 0) {
                SelectGoModulesPage.this.m_delete.setEnabled(false);
                SelectGoModulesPage.this.m_up.setEnabled(false);
                SelectGoModulesPage.this.m_down.setEnabled(false);
            } else if (selected.size() == 1) {
                SelectGoModulesPage.this.m_delete.setEnabled(true);
                int pos = SelectGoModulesPage.this.m_selectedModuleFiles.indexOf(selected.get(0));
                SelectGoModulesPage.this.m_up.setEnabled(pos > 0);
                SelectGoModulesPage.this.m_down.setEnabled(pos < SelectGoModulesPage.this.m_selectedModuleFiles.size() - 1);
            } else {
                SelectGoModulesPage.this.m_delete.setEnabled(true);
                SelectGoModulesPage.this.m_up.setEnabled(false);
                SelectGoModulesPage.this.m_down.setEnabled(false);
            }
        }
    }
}

