/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.go.wizard;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.ImportQualityModelCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.command.system.CreateNewGoSystemCommand;
import com.hello2morrow.sonargraph.languageprovider.go.foundation.common.GoLanguage;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.QualityModelLoader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.go.wizard.SelectGoModulesPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CreateSystemCommandInteraction;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public final class GoSystemWizard
extends NonLazySonargraphWizard {
    private SystemDirectoryWizardPage m_basicDataPage;
    private SelectGoModulesPage m_moduleSelectionPage;

    public GoSystemWizard() {
        super("New System based on go.mod Files");
    }

    public void addPages() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        List fileDescriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)provider);
        List resolvedDescriptors = QualityModelLoader.loadQualityModelFiles((List)fileDescriptors);
        int defaultIndex = 0;
        int i = 0;
        while (i < resolvedDescriptors.size()) {
            Language qualityModelLanguage = ((ResolvedQualityModelDescriptorFile)resolvedDescriptors.get(i)).getQualityModelFileDescriptor().getLanguage();
            if (qualityModelLanguage != null && qualityModelLanguage.equals((Object)GoLanguage.INSTANCE)) {
                defaultIndex = i;
                break;
            }
            ++i;
        }
        this.m_basicDataPage = new SystemDirectoryWizardPage("PAGE_1", "Specify the name, description and location of the new system", "Name:", "Directory:", "Use predefined quality model", CreateSoftwareSystemCommand.getNameValidator((ISoftwareSystemProvider)provider), CreateSoftwareSystemCommand.getBaseDirectoryValidator((ISoftwareSystemProvider)provider), ImportQualityModelCommand.getImportQualityModelValidator((ISoftwareSystemProvider)provider), resolvedDescriptors, defaultIndex, "", "");
        this.m_moduleSelectionPage = new SelectGoModulesPage("PAGE_2", (IDirectoryProvider)this.m_basicDataPage, true);
        this.addPage((SonargraphWizardPage)this.m_basicDataPage);
        this.addPage((SonargraphWizardPage)this.m_moduleSelectionPage);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            Interaction interaction = new Interaction(this.m_basicDataPage);
            CreateNewGoSystemCommand command = new CreateNewGoSystemCommand(WorkbenchRegistry.getInstance().getProvider(), (CreateNewGoSystemCommand.IInteraction)interaction);
            UserInterfaceAdapter.getInstance().run((Command)command);
            return true;
        }
        return false;
    }

    private final class Interaction
    extends CreateSystemCommandInteraction
    implements CreateNewGoSystemCommand.IInteraction {
        public Interaction(SystemDirectoryWizardPage basicDataPage) {
            super(basicDataPage);
        }

        public boolean collectGoModFiles(CreateNewGoSystemCommand.GoSystemData data) {
            List<TFile> selectedModuleFiles = GoSystemWizard.this.m_moduleSelectionPage.getSelectedModuleFiles();
            if (selectedModuleFiles.isEmpty()) {
                return false;
            }
            selectedModuleFiles.forEach(f -> data.addGoModFile(f));
            return true;
        }

        public void processResult(OperationResult result) {
            if (!result.isEmpty()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }
}

