/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.go.pages.preferences;

import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.go.model.system.IGoSettingsProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.go.dialog.GoDialogId;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public final class GoPreferencesPage
extends StandardPreferencePage
implements ISettingsDelta {
    private ValidatingPathWidget m_goPathWidget;
    private TFile m_goExe = null;
    private String m_goPath;

    public GoPreferencesPage() {
        this.noDefaultAndApplyButton();
    }

    private IGoSettingsProvider getSettingsExtension() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        return (IGoSettingsProvider)installation.getExtension(IGoSettingsProvider.class);
    }

    public IDialogId getDialogId() {
        return GoDialogId.GO_PREFERENCES;
    }

    protected boolean okToLeavePageWithErrors() {
        return true;
    }

    protected final Composite createPageContents(Composite parent) {
        this.initGoLocation();
        Composite container = new Composite(parent, 0);
        container.setSize(this.getWidth(), this.getHeight());
        container.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)2, (boolean)false));
        Composite composite = new Composite(container, 1);
        composite.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayoutWithMargin((int)2, (boolean)false));
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        Label explanation = new Label(composite, 0);
        explanation.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        explanation.setText("Locate the executable for the 'go' executable on this machine.");
        Label labelExecutable = new Label(composite, 0);
        labelExecutable.setText("Go Executable:");
        this.m_goPathWidget = new ValidatingPathWidget(composite, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                GoPreferencesPage.this.m_goExe = input;
                GoPreferencesPage.this.setValid(GoPreferencesPage.this.m_goPathWidget.isValid());
                GoPreferencesPage.this.updateButtonStates(inputModified);
            }
        }, this.getSettingsExtension().getGoPathValidator(), 2, this.m_goExe, true);
        this.m_goPathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.setValid(this.m_goPathWidget.isValid());
        this.createButtonsPart(container, false);
        this.updateButtonStates(false);
        parent.layout();
        return container;
    }

    private void updateButtonStates(boolean inputModified) {
        boolean isModified = inputModified || this.isModified();
        this.getApplyButton().setEnabled(isModified && this.standardIsValid());
        this.getCancelButton().setEnabled(isModified);
    }

    public boolean isModified() {
        if (this.m_goExe != null) {
            return !this.m_goExe.getNormalizedAbsolutePath().equals(this.m_goPath);
        }
        return this.m_goPath != null;
    }

    public void reset() {
        this.initGoLocation();
    }

    private void initGoLocation() {
        TFile goFile = this.getSettingsExtension().getGoFile();
        if (goFile == null) {
            this.m_goPath = null;
            this.m_goExe = null;
        } else {
            this.m_goPath = goFile.getNormalizedAbsolutePath();
            this.m_goExe = goFile.getNormalizedAbsoluteFile();
        }
    }

    protected ISettingsDelta getDelta() {
        return this;
    }

    protected final void cancel() {
        this.reset();
        this.m_goPathWidget.reset();
    }

    protected void internPerformOk() {
        if (this.isModified() && this.standardIsValid()) {
            this.getSettingsExtension().setGoFile(this.m_goExe);
            this.updateButtonStates(false);
        }
    }

    protected OperationResult getOperationResult() {
        return null;
    }
}

