/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.standalone.documentation.ui.help;

import com.hello2morrow.sonargraph.core.model.common.IIssueId;
import com.hello2morrow.sonargraph.core.model.element.Issue;
import com.hello2morrow.sonargraph.foundation.utilities.Platform;
import com.hello2morrow.sonargraph.standalone.documentation.foundation.common.DocumentationResourceProviderAdapter;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpContext;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpContextFileReader;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpResourceType;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpTopic;
import com.hello2morrow.sonargraph.ui.swt.base.view.RcpUtility;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.map.hash.THashMap;
import gnu.trove.set.hash.THashSet;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.helpers.DefaultHandler;

public final class HelpRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(HelpRegistry.class);
    private static final String FILE_PREFIX = "file:///";
    private static final String HTML_CONTENT_PART = "html/content/";
    private static final String[] CONTEXT_FILENAMES = new String[]{"core", "java", "cplusplus", "csharp"};
    private static final String CORE_ISSUE_PROVIDER_ID = "Core";
    private static final String JAVA_ISSUE_PROVIDER_ID = "JavaLanguageProvider";
    private static final String CPLUSPLUS_ISSUE_PROVIDER_ID = "CPlusPlusLanguageProvider";
    private static final String CSHARP_ISSUE_PROVIDER_ID = "CSharpLanguageProvider";
    private static final String DEFAULT_TEXT = "Select a view to get context info and links to related topics in the documentation.";
    private static final HyperLinkListener HYPER_LINK_LISTENER = new HyperLinkListener();
    private static HelpRegistry s_instance;
    private final Set<String> m_issueIdsWithHelp = new THashSet();
    private final Map<Object, String> m_objectToContextIdMap = new THashMap();
    private final Map<String, HelpContext> m_contextMap = new THashMap();
    private final HelpContext m_defaultContext;

    private static String createIssueKey(String providerIdStandardName, String issueIdEnumConstant) {
        assert (providerIdStandardName != null && providerIdStandardName.length() > 0) : "Parameter 'issueProviderIdStandardName' of method 'createIssueKey' must not be empty";
        assert (issueIdEnumConstant != null && issueIdEnumConstant.length() > 0) : "Parameter 'issueIdEnumConstant' of method 'createIssueKey' must not be empty";
        return providerIdStandardName.toLowerCase() + "_" + issueIdEnumConstant.toLowerCase();
    }

    private HelpRegistry(String dynamicHelpContextId) {
        assert (dynamicHelpContextId != null && dynamicHelpContextId.length() > 0) : "Parameter 'dynamicHelpContextId' of method 'HelpRegistry' must not be empty";
        HelpContext.HelpContextBuilder builder = new HelpContext.HelpContextBuilder();
        builder.setDescription(DEFAULT_TEXT);
        builder.setTitle("Dynamic Context Help");
        builder.setId(dynamicHelpContextId);
        builder.addTopic(new HelpTopic("motivation.html", "Sonargraph Help"));
        this.m_defaultContext = builder.build();
        this.m_issueIdsWithHelp.add(HelpRegistry.createIssueKey(CORE_ISSUE_PROVIDER_ID, "DUPLICATE_CODE_BLOCK"));
        this.m_issueIdsWithHelp.add(HelpRegistry.createIssueKey(JAVA_ISSUE_PROVIDER_ID, "CLASS_FILE_OUT_OF_DATE"));
        this.m_issueIdsWithHelp.add(HelpRegistry.createIssueKey(CPLUSPLUS_ISSUE_PROVIDER_ID, "PARSING_ERROR"));
        this.m_issueIdsWithHelp.add(HelpRegistry.createIssueKey(CSHARP_ISSUE_PROVIDER_ID, "CSHARP_PARSING_ERROR"));
        this.m_issueIdsWithHelp.add(HelpRegistry.createIssueKey(CSHARP_ISSUE_PROVIDER_ID, "PROJECT_FILE_PROCESSING_FAILED"));
        String[] stringArray = CONTEXT_FILENAMES;
        int n = CONTEXT_FILENAMES.length;
        int n2 = 0;
        while (n2 < n) {
            String context = stringArray[n2];
            URL url = DocumentationResourceProviderAdapter.getInstance().getResourceUrl(HelpResourceType.CONTEXT, "context/" + context);
            try {
                Throwable throwable = null;
                Object var9_11 = null;
                try (InputStream is = url.openStream();){
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    SAXParser saxParser = factory.newSAXParser();
                    HelpContextFileReader processor = new HelpContextFileReader();
                    saxParser.parse(is, (DefaultHandler)processor);
                    this.m_contextMap.putAll(processor.getContexts());
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                LOGGER.error("Failed to process help context '" + context + "'", (Throwable)ex);
            }
            ++n2;
        }
    }

    public static boolean hasInstance() {
        return s_instance != null;
    }

    public static void createInstance(String dynamicHelpContextId) {
        assert (!HelpRegistry.hasInstance()) : "HelpRegistry instance already created";
        s_instance = new HelpRegistry(dynamicHelpContextId);
    }

    public static HelpRegistry getInstance() {
        assert (HelpRegistry.hasInstance()) : "HelpRegistry instance not created";
        return s_instance;
    }

    public static void delete() {
        s_instance = null;
    }

    public void register(Object object, String contextId) {
        assert (object != null) : "Parameter 'object' of method 'register' must not be null";
        assert (contextId != null && contextId.length() > 0) : "Parameter 'contextId' of method 'register' must not be empty";
        this.m_objectToContextIdMap.put(object, contextId);
    }

    public void unregister(Object object) {
        assert (object != null) : "Parameter 'object' of method 'unregister' must not be null";
        this.m_objectToContextIdMap.remove(object);
    }

    public HelpContext getDefaultHelpContext() {
        return this.m_defaultContext;
    }

    public HelpContext getContext(String contextId) {
        assert (contextId != null && contextId.length() > 0) : "Parameter 'contextId' of method 'getContext' must not be empty";
        return this.m_contextMap.get(contextId);
    }

    public HelpContext getContext(Object object) {
        assert (object != null) : "Parameter 'object' of method 'isHelpAvailable' must not be null";
        String contextId = this.m_objectToContextIdMap.get(object);
        if (contextId != null) {
            return this.m_contextMap.get(contextId);
        }
        if (object instanceof Issue) {
            Issue issue = (Issue)object;
            IIssueId issueId = issue.getId();
            if (!this.m_issueIdsWithHelp.contains(HelpRegistry.createIssueKey(issue.getProvider().getStandardName(), issueId.toString()))) {
                return null;
            }
            HelpContext.HelpContextBuilder builder = new HelpContext.HelpContextBuilder();
            builder.setTitle("Info about '" + issueId.getPresentationName() + "'");
            builder.setDescription("Explanation about the info and how it can be resolved is available in the user manual.");
            builder.setId(issueId.getStandardName());
            builder.addTopic(new HelpTopic(issue.getProvider().getStandardName().toLowerCase() + "_issues.html#" + issueId.toString(), issueId.getPresentationName()));
            return builder.build();
        }
        return null;
    }

    private TFile getDefaultHelpHtmlFile(String relUrl) throws IOException {
        assert (relUrl != null && relUrl.length() > 0) : "Parameter 'relUrl' of method 'getDefaultHelpIndexFile' must not be empty";
        String indexFilePath = Platform.isMac() ? RcpUtility.getInstallationDirectoryPath() + "/Contents/Eclipse/doc/html/content/" + relUrl : RcpUtility.getInstallationDirectoryPath() + "doc/html/content/" + relUrl;
        TFile indexFile = new TFile(indexFilePath);
        if (!indexFile.exists()) {
            throw new IOException("'" + indexFilePath + "' does not exist.");
        }
        if (!indexFile.canRead()) {
            throw new IOException("'" + indexFilePath + "' is not readable.");
        }
        return indexFile;
    }

    private TFile getHelpHtmlFile(String relUrl) {
        TFile helpHtmlFile;
        block4: {
            assert (relUrl != null && relUrl.length() > 0) : "Parameter 'relUrl' of method 'getHelpHtmlFile' must not be empty";
            int anchorPosition = relUrl.indexOf(35);
            String relUrlWithoutAnchor = anchorPosition > -1 ? relUrl.substring(0, anchorPosition) : relUrl;
            helpHtmlFile = null;
            try {
                helpHtmlFile = this.getDefaultHelpHtmlFile(relUrlWithoutAnchor);
            }
            catch (IOException e) {
                String helpHtmlFilePath = System.getProperty("user.dir") + "/../com.hello2morrow.sonargraph.standalone.documentation/dist/html/content/" + relUrlWithoutAnchor.replace(FILE_PREFIX, "");
                helpHtmlFile = new TFile(helpHtmlFilePath);
                if (!helpHtmlFile.exists()) {
                    LOGGER.error("[Development mode] Help html file not found: " + helpHtmlFilePath);
                    return null;
                }
                if (helpHtmlFile.canRead()) break block4;
                LOGGER.error("[Development mode] Help html file not readable: " + helpHtmlFilePath);
                return null;
            }
        }
        return helpHtmlFile;
    }

    public String getUrlForLocalHtmlFile(String relPath) {
        assert (relPath != null && relPath.length() > 0) : "Parameter 'relPath' of method 'getUrlForLocalHelpFile' must not be empty";
        TFile helpHtmlFile = this.getHelpHtmlFile(relPath);
        if (helpHtmlFile != null) {
            int anchorPosition;
            String result = helpHtmlFile.getNormalizedAbsolutePath();
            if (result.startsWith("/")) {
                result = result.substring(1);
            }
            String url = FILE_PREFIX + (String)((anchorPosition = relPath.indexOf(35)) > 0 ? result + relPath.substring(anchorPosition) : result);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(relPath + " -> " + url);
            }
            return url;
        }
        LOGGER.error("Failed to find HTML file {}", (Object)relPath);
        return "html-file-not-found";
    }

    private String processDescription(String description) {
        assert (description != null) : "Parameter 'description' of method 'processDescription' must not be null";
        if (!description.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            boolean firstBlank = true;
            int i = 0;
            while (i < description.length()) {
                char nextChar = description.charAt(i);
                if (nextChar == ' ') {
                    if (firstBlank) {
                        builder.append(nextChar);
                        firstBlank = false;
                    }
                } else if (nextChar != '\n' && nextChar != '\t') {
                    firstBlank = true;
                    builder.append(nextChar);
                }
                ++i;
            }
            return builder.toString().replaceAll("<br/>", "\n");
        }
        return description;
    }

    public void setContextHelpText(List<HelpContext> contexts, StyledText styledText) {
        assert (contexts != null && !contexts.isEmpty()) : "Parameter 'contexts' of method 'setContextHelpText' must not be empty";
        assert (styledText != null) : "Parameter 'styledText' of method 'setContextHelpText' must not be null";
        LinkedHashMap<String, HelpTopic> topics = new LinkedHashMap<String, HelpTopic>();
        for (HelpContext context : contexts) {
            for (HelpTopic nextTopic : context.getTopics()) {
                if (topics.containsKey(nextTopic.getDescription())) continue;
                topics.put(nextTopic.getDescription(), nextTopic);
            }
        }
        styledText.removeListener(3, (Listener)HYPER_LINK_LISTENER);
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        StringBuilder builder = new StringBuilder();
        builder.append(this.processDescription(contexts.get(0).getDescription()));
        if (topics.size() > 0) {
            builder.append("\n\n");
            builder.append("See also:");
            builder.append("\n\n");
            for (HelpTopic nextTopic : topics.values()) {
                String nextHRef = this.getUrlForLocalHtmlFile(nextTopic.getLink());
                if (nextHRef == null) continue;
                builder.append("    ");
                String nextDescription = nextTopic.getDescription();
                StyleRange linkStyleRange = new StyleRange(builder.length(), nextDescription.length(), null, null);
                linkStyleRange.underline = true;
                linkStyleRange.underlineStyle = 4;
                linkStyleRange.data = nextHRef;
                builder.append(nextDescription).append("\n");
                styleRanges.add(linkStyleRange);
            }
        }
        styledText.setText(builder.toString());
        if (!styleRanges.isEmpty()) {
            styledText.setStyleRanges(styleRanges.toArray(new StyleRange[styleRanges.size()]));
            styledText.addListener(3, (Listener)HYPER_LINK_LISTENER);
        }
    }

    static final class HyperLinkListener
    implements Listener {
        HyperLinkListener() {
        }

        public void handleEvent(Event event) {
            assert (event != null) : "Parameter 'event' of method 'handleEvent' must not be null";
            Widget widget = event.widget;
            assert (widget != null && widget instanceof StyledText) : "Unexpected class in method 'handleEvent': " + String.valueOf(widget);
            StyledText styledText = (StyledText)widget;
            int offset = styledText.getOffsetAtPoint(new Point(event.x, event.y));
            if (offset != -1) {
                StyleRange style = null;
                try {
                    style = styledText.getStyleRangeAtOffset(offset);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                if (style != null && style.underline && style.underlineStyle == 4) {
                    Object data = style.data;
                    assert (data != null && data instanceof String) : "Unexpected class in method 'handleEvent': " + String.valueOf(data);
                    Program.launch((String)((String)data));
                }
            }
        }
    }
}

