/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.standalone.documentation.controller.system;

import com.hello2morrow.sonargraph.core.model.analysis.IMetricCategory;
import com.hello2morrow.sonargraph.core.model.analysis.IMetricId;
import com.hello2morrow.sonargraph.core.model.metrics.CoreMetricId;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.CPlusPlusMetricId;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.system.CSharpMetricId;
import com.hello2morrow.sonargraph.languageprovider.java.model.system.JavaMetricId;
import com.hello2morrow.sonargraph.languageprovider.python.model.system.PythonMetricId;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public final class MetricDocumentationGeneratorDevelopment {
    public static void main(String[] args) {
        String targetPath = args.length == 1 ? args[0] : "../com.hello2morrow.sonargraph.standalone.documentation/target/generated-src/doc/metric_descriptions";
        try {
            MetricDocumentationGeneratorDevelopment generator = new MetricDocumentationGeneratorDevelopment();
            File targetDir = new File(targetPath);
            if (targetDir.exists()) {
                MetricDocumentationGeneratorDevelopment.deleteDirectory(targetDir);
            }
            targetDir.mkdirs();
            generator.generateDocBookHelpFiles(targetDir);
            System.out.println("Created metric documentation files in directory: " + targetDir.getAbsolutePath());
        }
        catch (Exception e) {
            System.err.print("Unable to create metric descriptions: " + String.valueOf(e));
        }
    }

    private static void deleteDirectory(File dir) throws IOException {
        File[] entries;
        if (dir.isDirectory() && (entries = dir.listFiles()) != null) {
            File[] fileArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                File entry = fileArray[n2];
                MetricDocumentationGeneratorDevelopment.deleteDirectory(entry);
                ++n2;
            }
        }
        if (!dir.delete()) {
            throw new IOException("Failed to delete " + String.valueOf(dir));
        }
    }

    private void generateDocBookHelpFiles(File targetDir) throws IOException {
        this.writeDescriptionFile("core_metrics", String.valueOf(targetDir) + "/core_metrics.xml", (IMetricId[])CoreMetricId.values(), "Language Independent Metrics");
        this.writeDescriptionFile("java_metrics", String.valueOf(targetDir) + "/java_metrics.xml", (IMetricId[])JavaMetricId.values(), "Java Metrics");
        this.writeDescriptionFile("cplusplus_metrics", String.valueOf(targetDir) + "/cplusplus_metrics.xml", (IMetricId[])CPlusPlusMetricId.values(), "C,C++ Metrics");
        this.writeDescriptionFile("csharp_metrics", String.valueOf(targetDir) + "/csharp_metrics.xml", (IMetricId[])CSharpMetricId.values(), "C# Metrics");
        this.writeDescriptionFile("python_metrics", String.valueOf(targetDir) + "/python_metrics.xml", (IMetricId[])PythonMetricId.values(), "Python Metrics");
    }

    private void writeDescriptionFile(String id, String targetPath, IMetricId[] values, String secondaryIndex) throws IOException {
        StringBuilder output = new StringBuilder();
        output.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n");
        output.append("<!-- DO NOT EDIT: This is generated via Maven in project multilanguage by ").append(this.getClass().getCanonicalName()).append(". -->\n");
        output.append("<section xmlns=\"http://docbook.org/ns/docbook\" xml:id=\"").append(id).append("\">\n");
        output.append("    <title>").append(secondaryIndex).append("</title>\n");
        output.append("    <indexterm>\n");
        output.append("        <primary>").append("Metric Definitions").append("</primary>\n");
        output.append("        <secondary>").append(secondaryIndex).append("</secondary>\n");
        output.append("    </indexterm>\n");
        List ids = Arrays.asList(values).stream().sorted(new MetricIdComparatorDevelopment()).collect(Collectors.toList());
        for (IMetricId next : ids) {
            output.append(this.generatedEntryFor(next, secondaryIndex));
        }
        output.append("</section>");
        FileUtility.writeFile((String)targetPath, (Charset)StandardCharsets.UTF_8, (String)output.toString(), (boolean)false);
        System.out.println("Generated " + targetPath);
    }

    private String generatedEntryFor(IMetricId id, String secondaryIndex) {
        StringBuilder entry = new StringBuilder();
        entry.append("<!-- DO NOT EDIT: This is generated via Maven in project multilanguage by ").append(MetricDocumentationGeneratorDevelopment.class.getCanonicalName()).append(". -->\n");
        entry.append("<note>\n");
        entry.append("    <title>");
        entry.append(id.getPresentationName());
        entry.append("</title>\n");
        entry.append("    <indexterm>\n");
        entry.append("        <primary>\n            ");
        entry.append("Metric Definitions");
        entry.append("\n        </primary>\n");
        entry.append("        <secondary>\n            ");
        entry.append(secondaryIndex);
        entry.append("\n        </secondary>\n");
        entry.append("        <tertiary>\n            ");
        entry.append(id.getPresentationName());
        entry.append("\n        </tertiary>\n");
        entry.append("    </indexterm>");
        this.createPara(entry, "Description: ", id.getDescription());
        this.createPara(entry, "Categories: ", StringUtility.concat((Collection)id.getCategories().stream().map(c -> c.getPresentationName()).collect(Collectors.toList()), (String)", "));
        entry.append("<para>&#x200B;</para>");
        entry.append("\n</note>\n");
        return entry.toString();
    }

    private void createPara(StringBuilder builder, String emphasized, String content) {
        builder.append("\n    <para>\n");
        builder.append("        <emphasis>").append(emphasized).append("</emphasis>");
        builder.append(this.escapeText(content));
        builder.append("\n    </para>");
    }

    private String escapeText(String text) {
        String escapeAmpersand = text.replace("&", "&#x0026;");
        return escapeAmpersand;
    }

    private class MetricIdComparatorDevelopment
    implements Comparator<IMetricId> {
        private MetricIdComparatorDevelopment() {
        }

        @Override
        public int compare(IMetricId id1, IMetricId id2) {
            int compareCategory = Integer.valueOf(((IMetricCategory)id1.getCategories().get(0)).getOrderNumber()).compareTo(((IMetricCategory)id2.getCategories().get(0)).getOrderNumber());
            if (compareCategory == 0) {
                return id1.getPresentationName().compareTo(id2.getPresentationName());
            }
            return compareCategory;
        }
    }
}

