/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.standalone.documentation.ui.help;

import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpContext;
import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpTopic;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

final class HelpContextFileReader
extends DefaultHandler {
    private static final String CONTEXTS_ELEMENT = "contexts";
    private static final String CONTEXT_ELEMENT = "context";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String TOPIC_ELEMENT = "topic";
    private static final String ID_ATTRIBUTE = "id";
    private static final String TITLE_ATTRIBUTE = "title";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String LABEL_ATTRIBUTE = "label";
    private Map<String, HelpContext> m_contextMap;
    private HelpContext.HelpContextBuilder m_currentBuilder;
    private StringBuilder m_currentValue;

    HelpContextFileReader() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.m_currentValue = new StringBuilder();
        switch (qName) {
            case "contexts": {
                this.m_contextMap = new HashMap<String, HelpContext>();
                break;
            }
            case "context": {
                this.m_currentBuilder = new HelpContext.HelpContextBuilder();
                String id = attributes.getValue(ID_ATTRIBUTE);
                assert (id != null && id.length() > 0) : "'id' must not be empty";
                this.m_currentBuilder.setId(id.trim());
                String title = attributes.getValue(TITLE_ATTRIBUTE);
                assert (title != null && title.length() > 0) : "'title' must not be empty";
                this.m_currentBuilder.setTitle(title.trim());
                break;
            }
            case "topic": {
                String href = attributes.getValue(HREF_ATTRIBUTE);
                assert (href != null && href.length() > 0) : "'href' must not be empty";
                String label = attributes.getValue(LABEL_ATTRIBUTE);
                assert (label != null && label.length() > 0) : "'label' must not be empty";
                HelpTopic topic = new HelpTopic(href.trim(), label.trim());
                this.m_currentBuilder.addTopic(topic);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_currentValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        switch (qName) {
            case "description": {
                this.m_currentBuilder.setDescription(this.m_currentValue.toString());
                break;
            }
            case "context": {
                HelpContext context = this.m_currentBuilder.build();
                this.m_contextMap.put(context.getId(), context);
                this.m_currentBuilder = null;
            }
        }
    }

    Map<String, HelpContext> getContexts() {
        return this.m_contextMap;
    }
}

