/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.standalone.documentation.ui.help;

import com.hello2morrow.sonargraph.standalone.documentation.ui.help.HelpTopic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class HelpContext {
    private final String m_id;
    private final String m_description;
    private final List<HelpTopic> m_topics;
    private final String m_title;

    private HelpContext(String id, String title, String description, List<HelpTopic> topics) {
        assert (id != null && id.length() > 0) : "Parameter 'id' of method 'HelpContext' must not be empty";
        assert (title != null && title.length() > 0) : "Parameter 'title' of method 'HelpContext' must not be empty";
        assert (description != null) : "Parameter 'description' of method 'HelpContext' must not be null";
        this.m_id = id;
        this.m_title = title;
        this.m_description = description;
        this.m_topics = topics;
    }

    public String getId() {
        return this.m_id;
    }

    public String getTitle() {
        return this.m_title;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List<HelpTopic> getTopics() {
        if (this.m_topics == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_topics);
    }

    public String toString() {
        return "Id: " + this.getId() + ", title: " + this.getTitle();
    }

    public static class HelpContextBuilder {
        private String m_id;
        private String m_description;
        private String m_title;
        private List<HelpTopic> m_topics;

        public void setId(String id) {
            assert (id != null && id.length() > 0) : "Parameter 'id' of method 'setId' must not be empty";
            this.m_id = id;
        }

        public void setDescription(String description) {
            assert (description != null) : "Parameter 'description' of method 'setDescription' must not be null";
            this.m_description = description;
        }

        public void addTopic(HelpTopic topic) {
            assert (topic != null) : "Parameter 'topic' of method 'addTopic' must not be null";
            if (this.m_topics == null) {
                this.m_topics = new ArrayList<HelpTopic>();
            }
            this.m_topics.add(topic);
        }

        public void setTitle(String title) {
            assert (title != null && title.length() > 0) : "Parameter 'title' of method 'setTitle' must not be empty";
            this.m_title = title;
        }

        public HelpContext build() {
            return new HelpContext(this.m_id, this.m_title, this.m_description, this.m_topics);
        }
    }
}

