/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.csharp.wizard;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.core.model.workspace.Module;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.csharp.command.system.CSharpSolutionImportData;
import com.hello2morrow.sonargraph.languageprovider.csharp.command.system.ImportCSharpSolutionFileCommand;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.path.CSharpFileType;
import com.hello2morrow.sonargraph.languageprovider.csharp.model.roslyn.ProjectInfo;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ProgressBarBasedWorkerContext;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import gnu.trove.set.hash.THashSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ProgressBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class CSharpModuleSelectionPage
extends StandardWizardPage
implements ValidatingPathWidget.IConsumer {
    private static final String SELECT_ALL = "Select All";
    private final IPathValidator m_solutionFileValidator;
    private final SystemDirectoryWizardPage m_directoryPage;
    private PropertyTableViewer<ProjectInfo> m_tableProjects;
    private TFile m_softwareSystemBaseDirectory;
    private TFile m_currentSolutionFile;
    private ValidatingPathWidget m_pathWidget;
    private List<ProjectInfo> m_projects;
    private final Set<ProjectInfo> m_selectedProjects = new THashSet();
    private Set<String> m_originalSelection = Collections.emptySet();
    private OperationResultWithOutcome<List<ProjectInfo>> m_result;
    private Button m_selectAll;
    private Button m_deselectAll;
    private ProgressBar m_progressBar;
    private boolean m_cancelable = true;
    private boolean m_initialized = false;

    public CSharpModuleSelectionPage(String pageName, String title, SystemDirectoryWizardPage directoryPage, IPathValidator solutionFileValidator) {
        super(pageName, title);
        assert (solutionFileValidator != null) : "Parameter 'solutionFileValidator' of method 'CSharpVsSolutionFileDialog' must not be null";
        this.m_directoryPage = directoryPage;
        this.m_solutionFileValidator = solutionFileValidator;
        this.setPageComplete(false);
    }

    public void createContent(Composite composite) {
        if (this.m_directoryPage != null) {
            this.m_softwareSystemBaseDirectory = this.m_directoryPage.getDirectory();
        }
        Label intro = new Label(composite, 64);
        intro.setText("Please make sure that you have built the solution successfully on your machine before creating the Sonargraph system. Also you must have .Net version 10.0 installed.");
        intro.setForeground(UiResourceManager.getInstance().getColor(UiResourceManager.RED));
        intro.setLayoutData((Object)new GridData(4, 128, true, false, 3, 1));
        Label labelSolutionFile = new Label(composite, 0);
        List<String> fileExtensionsList = Arrays.asList(CSharpFileType.SOLUTION_FILE.getExtensions());
        labelSolutionFile.setText("Solution File:");
        this.m_pathWidget = new ValidatingPathWidget(composite, (ValidatingPathWidget.IConsumer)this, this.m_solutionFileValidator, 2, null, true, this.m_softwareSystemBaseDirectory);
        String fileFilter = fileExtensionsList.stream().map(e -> "*" + e).collect(Collectors.joining(";"));
        this.m_pathWidget.setFilterExtensions(new String[]{fileFilter});
        this.m_pathWidget.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        if (this.m_currentSolutionFile != null) {
            this.m_pathWidget.setPath(this.m_currentSolutionFile.getNormalizedAbsolutePath());
        }
        Label importProgressLabel = new Label(composite, 0);
        importProgressLabel.setText("Progress:");
        this.m_progressBar = new ProgressBar(composite, 256);
        this.m_progressBar.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label labelProjects = new Label(composite, 0);
        labelProjects.setText("Projects:");
        labelProjects.setLayoutData((Object)new GridData(1, 128, false, false));
        this.m_tableProjects = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ProjectInfoAdapter(this.m_softwareSystemBaseDirectory), null, true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        this.m_tableProjects.addColumn("Import", "selected", null, "selectedImage", 80, PropertyTableViewer.ColumnType.IMAGE);
        this.m_tableProjects.addColumn("Name", "name", null, "image", 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableProjects.addColumn("File", "path", null, null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_tableProjects.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.addListenerToTable(this.m_tableProjects.getTable());
        Composite buttonComposite = new Composite(composite, 0);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false, 3, 1));
        buttonComposite.setLayout((Layout)new RowLayout());
        this.m_selectAll = new Button(buttonComposite, 8);
        this.m_selectAll.setText(SELECT_ALL);
        this.m_selectAll.setEnabled(false);
        this.m_selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CSharpModuleSelectionPage.this.m_projects != null) {
                    String flavor = CSharpModuleSelectionPage.this.getCurrentFlavor();
                    if (flavor == null) {
                        flavor = "";
                    }
                    for (ProjectInfo pi : CSharpModuleSelectionPage.this.m_projects) {
                        if (CSharpModuleSelectionPage.this.m_selectedProjects.contains(pi) || !flavor.isEmpty() && !flavor.equals(pi.getFlavor())) continue;
                        CSharpModuleSelectionPage.this.addProjectToSelection(pi, true);
                    }
                    CSharpModuleSelectionPage.this.m_tableProjects.showData(CSharpModuleSelectionPage.this.m_projects);
                    CSharpModuleSelectionPage.this.updatePageCompleteStatus();
                    CSharpModuleSelectionPage.this.enableTableButtons(true);
                }
            }
        });
        this.m_deselectAll = new Button(buttonComposite, 8);
        this.m_deselectAll.setText("Deselect All");
        this.m_deselectAll.setEnabled(false);
        this.m_deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSharpModuleSelectionPage.this.m_selectedProjects.clear();
                CSharpModuleSelectionPage.this.m_tableProjects.showData(CSharpModuleSelectionPage.this.m_projects);
                CSharpModuleSelectionPage.this.updatePageCompleteStatus();
                CSharpModuleSelectionPage.this.enableTableButtons(true);
            }
        });
        SwtUtility.createFillerForGridLayoutCell((Composite)composite, (int)3, (int)1);
        SwtUtility.createFillerForGridLayoutCell((Composite)composite);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && !this.m_initialized) {
            this.m_initialized = true;
            if (this.m_currentSolutionFile != null) {
                UserInterfaceAdapter.getInstance().displayUiElementAsync(() -> this.updateSolutionInfo());
            }
        }
    }

    private String getCurrentFlavor() {
        if (this.m_selectedProjects.isEmpty()) {
            return null;
        }
        for (ProjectInfo pi : this.m_selectedProjects) {
            if (pi.getFlavor().isEmpty()) continue;
            return pi.getFlavor();
        }
        return "";
    }

    private Set<String> getFlavors() {
        if (this.m_projects == null) {
            return Collections.emptySet();
        }
        return this.m_projects.stream().map(pi -> pi.getFlavor()).filter(f -> !f.isEmpty()).collect(Collectors.toSet());
    }

    private void updateSolutionInfo() {
        this.m_tableProjects.showData(this.m_projects);
        this.enableTableButtons(true);
        this.updatePageCompleteStatus();
    }

    public boolean canCancel() {
        return this.m_cancelable;
    }

    private void addListenerToTable(final Table table) {
        assert (table != null) : "Parameter 'table' of method 'addListenerToTable' must not be null";
        table.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent event) {
                int key = event.keyCode;
                if (key == 32) {
                    CSharpModuleSelectionPage.this.updateTableRow(table, (EventObject)event);
                    CSharpModuleSelectionPage.this.m_tableProjects.showData(CSharpModuleSelectionPage.this.m_projects);
                    CSharpModuleSelectionPage.this.updatePageCompleteStatus();
                }
            }
        });
        table.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent event) {
                CSharpModuleSelectionPage.this.updateTableRow(table, (EventObject)event);
                CSharpModuleSelectionPage.this.m_tableProjects.showData(CSharpModuleSelectionPage.this.m_projects);
                CSharpModuleSelectionPage.this.updatePageCompleteStatus();
                CSharpModuleSelectionPage.this.enableTableButtons(true);
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    private void updateTableRow(Table table, EventObject event) {
        assert (table != null) : "Parameter 'table' of method 'updateTableRow' must not be null";
        assert (event != null) : "Parameter 'event' of method 'updateTableRow' must not be null";
        Object source = event.getSource();
        assert (source != null && source instanceof Table) : "Unexpected class in method 'mouseDown': " + String.valueOf(source);
        StructuredSelection selection = new StructuredSelection((Object[])table.getSelection());
        if (!selection.isEmpty()) {
            Object firstElement = selection.getFirstElement();
            assert (firstElement instanceof TableItem) : "Unexpected class in method 'selectionChanged': " + String.valueOf(firstElement.getClass());
            TableItem item = (TableItem)firstElement;
            assert (item.getData() != null && item.getData() instanceof ProjectInfo) : "Unexpected class in method 'mouseDown': " + String.valueOf(item.getData());
            ProjectInfo pi = (ProjectInfo)item.getData();
            if (this.m_selectedProjects.contains(pi)) {
                this.m_selectedProjects.remove(pi);
            } else {
                this.addProjectToSelection(pi, true);
            }
        }
    }

    private void addProjectToSelection(ProjectInfo pi, boolean removeprojectWithSamePath) {
        assert (pi != null) : "Parameter 'pi' of method 'addProjectToSelection' must not be null";
        String flavor = pi.getFlavor();
        List sameAssemblyName = this.m_selectedProjects.stream().filter(p -> p.getAssemblyName().equals(pi.getAssemblyName())).collect(Collectors.toList());
        List sameRootPath = this.m_selectedProjects.stream().filter(p -> p.getRootPath().equals(pi.getRootPath())).collect(Collectors.toList());
        List otherFlavors = !flavor.isEmpty() ? this.m_selectedProjects.stream().filter(p -> !p.getFlavor().isEmpty() && !p.getFlavor().equals(flavor)).collect(Collectors.toList()) : Collections.emptyList();
        if (removeprojectWithSamePath) {
            this.m_selectedProjects.removeAll(sameRootPath);
            this.m_selectedProjects.removeAll(otherFlavors);
            this.m_selectedProjects.removeAll(sameAssemblyName);
            this.m_selectedProjects.add(pi);
        } else if (sameRootPath.isEmpty() && otherFlavors.isEmpty() && sameAssemblyName.isEmpty()) {
            this.m_selectedProjects.add(pi);
        }
    }

    public void setSoftwareSystemBaseDirectory(TFile baseDirectory) {
        assert (baseDirectory != null) : "Parameter 'baseDirectory' of method 'setSoftwareSystemBaseDirectory' must not be null";
        this.m_softwareSystemBaseDirectory = baseDirectory;
        if (this.m_pathWidget != null) {
            this.m_pathWidget.setBasePath(this.m_softwareSystemBaseDirectory);
        }
    }

    public TFile getSystemBaseDirectory() {
        return this.m_softwareSystemBaseDirectory;
    }

    public void setPath(TFile input, boolean inputModified) {
        if (input == null || !inputModified) {
            return;
        }
        this.m_currentSolutionFile = input;
        this.m_projects = null;
        this.m_selectedProjects.clear();
        this.m_tableProjects.showData(null);
        if (this.importSolutionFile()) {
            this.m_projects.forEach(pi -> this.addProjectToSelection((ProjectInfo)pi, false));
            this.m_tableProjects.showData(this.m_projects);
            this.enableTableButtons(true);
            this.updatePageCompleteStatus();
        }
    }

    private boolean importSolutionFile() {
        this.importSolutionFile(new Interaction());
        if (this.m_result == null || this.m_result.isFailure()) {
            this.m_currentSolutionFile = null;
            this.m_pathWidget.setPath("");
            this.enableTableButtons(false);
            this.setPageComplete(false);
            return false;
        }
        this.m_projects = (List)this.m_result.getOutcome();
        return true;
    }

    private void updatePageCompleteStatus() {
        this.setPageComplete(!this.m_selectedProjects.isEmpty());
    }

    private void enableTableButtons(boolean isEnabled) {
        boolean enabled = isEnabled && (this.getFlavors().isEmpty() || !this.m_selectedProjects.isEmpty());
        this.m_selectAll.setEnabled(enabled);
        this.m_deselectAll.setEnabled(isEnabled && !this.m_selectedProjects.isEmpty());
        if (enabled) {
            String flavor = this.getCurrentFlavor();
            if (flavor == null || flavor.isEmpty()) {
                this.setSelectAllLabel(SELECT_ALL);
            } else {
                this.setSelectAllLabel("Select All (" + flavor + ")");
            }
        } else {
            this.setSelectAllLabel(SELECT_ALL);
        }
    }

    private void setSelectAllLabel(String label) {
        if (this.getControl() != null && !this.getControl().isDisposed()) {
            this.getControl().setRedraw(false);
            this.m_selectAll.setText(label);
            this.m_selectAll.getParent().requestLayout();
            this.getControl().requestLayout();
            this.getControl().setRedraw(true);
        }
    }

    private void importSolutionFile(ImportCSharpSolutionFileCommand.IInteraction interaction) {
        assert (interaction != null) : "Parameter 'interaction' of method 'importSolutionFile' must not be null";
        ImportCSharpSolutionFileCommand command = new ImportCSharpSolutionFileCommand(WorkbenchRegistry.getInstance().getProvider(), interaction);
        ProgressBarBasedWorkerContext workerContext = new ProgressBarBasedWorkerContext(this.m_progressBar, 0);
        this.m_cancelable = false;
        UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)command, (IWorkerContext)workerContext);
        this.m_cancelable = true;
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    public boolean selectionHasChangedAndContainsModules() {
        if (this.m_projects == null) {
            return false;
        }
        if (this.m_selectedProjects.size() != this.m_originalSelection.size()) {
            return this.m_selectedProjects.size() > 0;
        }
        return this.m_selectedProjects.stream().map(pi -> pi.getName()).anyMatch(name -> !this.m_originalSelection.contains(name));
    }

    public final List<ProjectInfo> getProjectsToImport() {
        return this.m_projects == null ? Collections.emptyList() : this.m_projects.stream().filter(pi -> this.m_selectedProjects.contains(pi)).collect(Collectors.toList());
    }

    public final TFile getSolutionFile() {
        return this.m_currentSolutionFile;
    }

    public void setData(SoftwareSystem system, CSharpSolutionImportData data) {
        this.setSoftwareSystemBaseDirectory(system.getDirectoryFile());
        this.m_currentSolutionFile = data.getSolutionFile();
        this.m_originalSelection = data.getOrignalModules();
        this.m_projects = data.getProjectsToImport();
        this.m_selectedProjects.clear();
        for (ProjectInfo pi : this.m_projects) {
            if (!this.m_originalSelection.contains(pi.getName())) continue;
            this.m_selectedProjects.add(pi);
        }
    }

    private class Interaction
    implements ImportCSharpSolutionFileCommand.IInteraction {
        private Interaction() {
        }

        public boolean collectSolutionFile(ImportCSharpSolutionFileCommand.SolutionFileData data) {
            data.setSolutionFile(CSharpModuleSelectionPage.this.m_currentSolutionFile);
            return true;
        }

        public void processResult(OperationResultWithOutcome<List<ProjectInfo>> result) {
            CSharpModuleSelectionPage.this.m_result = result;
            if (result.isFailure()) {
                UserInterfaceAdapter.getInstance().process(result);
            }
        }
    }

    private class ProjectInfoAdapter
    extends BeanPropertyReader.BeanAdapter<ProjectInfo> {
        private ProjectInfo m_projectInfo;
        private final TFile m_baseDir;

        ProjectInfoAdapter(TFile baseDir) {
            assert (baseDir != null) : "Parameter 'baseDir' of method 'ProjectInfoAdapter' must not be null";
            this.m_baseDir = baseDir;
        }

        protected void setAdaptedObject(ProjectInfo projectInfo) {
            this.m_projectInfo = projectInfo;
        }

        public String getName() {
            return this.m_projectInfo.getName();
        }

        public String getPath() {
            return FileUtility.calculateRelativePath((TFile)new TFile(this.m_projectInfo.getRootPath()), (TFile)this.m_baseDir);
        }

        public Image getImage() {
            return UiResourceManager.getInstance().getImage(Module.IMAGE_RESOURCE_NAME);
        }

        public boolean isSelected() {
            return CSharpModuleSelectionPage.this.m_selectedProjects.contains(this.m_projectInfo);
        }

        public Image getSelectedImage() {
            return this.isSelected() ? UiResourceManager.getInstance().getImage("CheckBoxChecked") : UiResourceManager.getInstance().getImage("CheckBoxUnchecked");
        }
    }
}

