/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.shared;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.ImportCapturingOrCommandFileModulesCommand;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.SaveCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.CppImportWizard;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IModuleToRootsMapper;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;

public abstract class NewCPlusPlusModuleWizard
extends CppImportWizard
implements IDirectoryProvider {
    private final ISoftwareSystemProvider m_softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();

    protected NewCPlusPlusModuleWizard(String title) {
        super(title);
    }

    protected TFile getCommandFile() {
        return null;
    }

    protected TFile getCCSpyDir() {
        return null;
    }

    protected Installation getInstallation() {
        return this.m_softwareSystemProvider.getInstallation();
    }

    protected SoftwareSystem getSoftwareSystem() {
        return this.m_softwareSystemProvider.getSoftwareSystem();
    }

    @Override
    public TFile getSoftwareSystemDirectory() {
        return this.getSoftwareSystem().getDirectoryFile();
    }

    public TFile getDirectory() {
        return this.getSoftwareSystemDirectory();
    }

    @Override
    protected Command createCommand(ISoftwareSystemProvider provider) {
        Interaction interaction = new Interaction(this.getModuleAssignmentPage(), this.getCommandFile(), this.getCCSpyDir());
        return new ImportCapturingOrCommandFileModulesCommand((ImportCapturingOrCommandFileModulesCommand.IInteraction)interaction, provider);
    }

    private final class Interaction
    extends SaveCommandInteraction
    implements ImportCapturingOrCommandFileModulesCommand.IInteraction {
        private final IModuleToRootsMapper m_mapper;
        private final TFile m_commandFile;
        private final TFile m_ccspyDir;

        private Interaction(IModuleToRootsMapper mapper, TFile commandFile, TFile ccspyDir) {
            super(true);
            assert (mapper != null) : "Parameter 'mapper' of method 'Interaction' must not be null";
            this.m_mapper = mapper;
            this.m_commandFile = commandFile;
            this.m_ccspyDir = ccspyDir;
        }

        public boolean collect(ImportCapturingOrCommandFileModulesCommand.ImportData data) {
            boolean result = false;
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            for (String module : this.m_mapper.getModuleNames()) {
                data.addModule(module, this.m_mapper.getRootDirectoriesFor(module));
                result = true;
            }
            if (this.m_commandFile != null) {
                data.setCommandFile(this.m_commandFile);
            }
            if (this.m_ccspyDir != null) {
                data.setCcspyDir(this.m_ccspyDir);
            }
            return result;
        }

        public void processModuleCreationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }
}

