/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.shared;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResultWithOutcome;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ICompilerSelectionProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.List;

public final class CompilerSelectionPage
extends StandardWizardPage
implements SelectionListener {
    private static final String CREATE_NEW = "Create new...";
    private final ICPlusPlusInstallationProvider m_cppInstallation;
    private List m_compilerList;
    private final ICompilerSelectionProvider m_compilerSelectionProvider;

    public CompilerSelectionPage(String pageName, ICPlusPlusInstallationProvider cppInst, ICompilerSelectionProvider csp) {
        super(pageName, "Select compiler definition to be used for the new project");
        assert (cppInst != null) : "Parameter 'cppInst' of method 'CompilerSelectionPage' must not be null";
        assert (csp != null) : "Parameter 'csp' of method 'CompilerSelectionPage' must not be null";
        this.m_cppInstallation = cppInst;
        this.m_compilerSelectionProvider = csp;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.COMPILER_DEFINITION_SELECTION_WIZARD_PAGE;
    }

    protected void createContent(Composite parent) {
        this.m_compilerList = new List(parent, 516);
        this.m_compilerList.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        OperationResultWithOutcome result = this.m_cppInstallation.loadRelevantDefinitionsWithoutErrors();
        if (result.isFailure()) {
            this.setErrorMessage((String)result.getErrorMessages().get(0));
            this.setPageComplete(false);
        } else {
            this.setErrorMessage(null);
            ArrayList compilerDefinitionNames = new ArrayList(((Map)result.getOutcome()).keySet());
            Collections.sort(compilerDefinitionNames);
            compilerDefinitionNames.forEach(cname -> this.m_compilerList.add(cname));
            this.m_compilerList.add(CREATE_NEW);
            InstCompilerDefinition active = this.m_cppInstallation.getActiveCompilerDefinition();
            if (active != null) {
                this.m_compilerSelectionProvider.selectCompiler(active.getName());
                this.m_compilerList.select(this.m_compilerList.indexOf(active.getName()));
                this.setPageComplete(true);
            } else {
                this.setPageComplete(false);
            }
        }
        this.m_compilerList.addSelectionListener((SelectionListener)this);
    }

    public void widgetSelected(SelectionEvent e) {
        String[] selection = this.m_compilerList.getSelection();
        if (selection.length == 0) {
            this.setPageComplete(false);
        } else {
            String selected = selection[0];
            if (selected.equals(CREATE_NEW)) {
                this.m_compilerSelectionProvider.selectCompiler(null);
            } else {
                this.m_compilerSelectionProvider.selectCompiler(selected);
            }
            this.setPageComplete(true);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }
}

