/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.foundation.utilities.StringUtility;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.IProjectAnalyzerProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IModuleToRootsMapper;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

final class OptionDefinitionPage
extends StandardWizardPage {
    private static final String GLOBAL = "All Modules";
    private final IModuleToRootsMapper m_mapper;
    private final IProjectAnalyzerProvider m_analyzerProvider;
    private org.eclipse.swt.widgets.List m_moduleList;
    private org.eclipse.swt.widgets.List m_includeDirectoryList;
    private Button m_removeIncludeDirectoryButton;
    private Text m_macros;
    private String m_currentSelection = null;
    private boolean m_initialized = false;
    private final Map<String, String> m_macroMap = new HashMap<String, String>();
    private final Map<String, Set<String>> m_removedIncludesMap = new HashMap<String, Set<String>>();

    public OptionDefinitionPage(String pageName, IModuleToRootsMapper mapper, IProjectAnalyzerProvider provider) {
        super(pageName, "Define macros for conditional compilation and check include directories");
        this.m_mapper = mapper;
        this.m_analyzerProvider = provider;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.SYSTEM_CREATION_MODULE_COMPILER_OPTIONS_WIZARD_PAGE;
    }

    protected void createContent(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Modules:");
        label.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        Label label1 = new Label(composite, 0);
        label1.setText("Include directories:");
        label1.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        this.m_moduleList = new org.eclipse.swt.widgets.List(composite, 516);
        this.m_moduleList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.m_moduleList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                OptionDefinitionPage.this.updateSelection();
            }
        });
        this.m_includeDirectoryList = new org.eclipse.swt.widgets.List(composite, 770);
        this.m_includeDirectoryList.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.m_includeDirectoryList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                OptionDefinitionPage.this.updateIncludeSelection();
            }
        });
        this.m_removeIncludeDirectoryButton = new Button(composite, 8);
        this.m_removeIncludeDirectoryButton.setText("Remove Include Directory");
        this.m_removeIncludeDirectoryButton.setEnabled(false);
        this.m_removeIncludeDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!$assertionsDisabled && OptionDefinitionPage.this.m_currentSelection == null) {
                    throw new AssertionError();
                }
                Set<String> removedIncludes = OptionDefinitionPage.this.m_removedIncludesMap.get(OptionDefinitionPage.this.m_currentSelection);
                if (removedIncludes == null) {
                    removedIncludes = new HashSet<String>();
                    OptionDefinitionPage.this.m_removedIncludesMap.put(OptionDefinitionPage.this.m_currentSelection, removedIncludes);
                }
                String[] stringArray = OptionDefinitionPage.this.m_includeDirectoryList.getSelection();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String toBeRemoved = stringArray[n2];
                    OptionDefinitionPage.this.m_includeDirectoryList.remove(toBeRemoved);
                    removedIncludes.add(toBeRemoved);
                    ++n2;
                }
            }
        });
        Label label2 = new Label(composite, 0);
        label2.setText("Macro definitions, one per line:\n(e.g. NDEBUG or VAL=17)");
        label2.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        this.m_macros = new Text(composite, 770);
        this.m_macros.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
    }

    private void updateIncludeSelection() {
        if (this.m_currentSelection.equals(GLOBAL)) {
            this.m_removeIncludeDirectoryButton.setEnabled(false);
        } else {
            this.m_removeIncludeDirectoryButton.setEnabled(this.m_includeDirectoryList.getSelectionCount() > 0);
        }
    }

    private void updateSelection() {
        String[] selections;
        if (this.m_currentSelection != null) {
            String macros = this.m_macros.getText();
            if (macros.length() == 0) {
                this.m_macroMap.remove(this.m_currentSelection);
            } else {
                this.m_macroMap.put(this.m_currentSelection, macros);
            }
        }
        if ((selections = this.m_moduleList.getSelection()).length > 0) {
            this.m_currentSelection = selections[0];
            String macros = this.m_macroMap.get(this.m_currentSelection);
            this.m_macros.setText(macros == null ? "" : macros);
            this.m_macros.setEditable(true);
        } else {
            this.m_currentSelection = null;
            this.m_macros.setText("");
            this.m_macros.setEditable(false);
        }
        this.m_macros.setSelection(this.m_macros.getText().length());
        this.m_includeDirectoryList.removeAll();
        if (GLOBAL.equals(this.m_currentSelection)) {
            for (TFile extraIncDir : this.m_analyzerProvider.getProjectAnalyzer().getExtraIncludeDirectories()) {
                this.m_includeDirectoryList.add(extraIncDir.getPath());
            }
        } else if (this.m_currentSelection != null) {
            List dirs = this.m_analyzerProvider.getProjectAnalyzer().computeIncludePaths(this.m_mapper.getRootDirectoriesFor(this.m_currentSelection));
            Set removedIncludes = this.m_removedIncludesMap.getOrDefault(this.m_currentSelection, Collections.emptySet());
            dirs.stream().filter(d -> !removedIncludes.contains(d)).forEach(d -> this.m_includeDirectoryList.add(d));
        }
        this.m_removeIncludeDirectoryButton.setEnabled(false);
    }

    protected boolean getColumnsEqualWidth() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.m_moduleList.removeAll();
            this.m_moduleList.add(GLOBAL);
            this.m_mapper.getModuleNames().forEach(name -> this.m_moduleList.add(name));
            if (!this.m_initialized) {
                StringBuilder macros = new StringBuilder();
                for (String macroDef : this.m_analyzerProvider.getProjectAnalyzer().getGlobalOptions()) {
                    if (macroDef.startsWith("-D")) {
                        macroDef = macroDef.substring(2);
                    }
                    macros.append(macroDef).append('\n');
                }
                this.m_macroMap.put(GLOBAL, macros.toString());
                this.m_initialized = true;
                this.m_moduleList.select(0);
                this.m_currentSelection = GLOBAL;
                this.m_macros.setText(macros.toString());
            }
        }
        this.updateSelection();
    }

    List<String> getMacrosForModule(String modName) {
        String macros = modName == null ? this.m_macroMap.get(GLOBAL) : this.m_macroMap.get(modName);
        if (macros != null) {
            return StringUtility.multiLineStringToList((String)macros);
        }
        return Collections.emptyList();
    }

    List<String> getIncludeDirectoriesForModule(String modName) {
        assert (modName != null && modName.length() > 0) : "Parameter 'modName' of method 'getIncludeDirectoriesForModule' must not be empty";
        List dirs = this.m_analyzerProvider.getProjectAnalyzer().computeIncludePaths(this.m_mapper.getRootDirectoriesFor(modName));
        Set removedIncludes = this.m_removedIncludesMap.getOrDefault(modName, Collections.emptySet());
        dirs.removeAll(removedIncludes);
        return dirs;
    }
}

