/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeReference;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.IProjectAnalyzerProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;

public final class IncludeAnalyzerPage
extends StandardWizardPage {
    private Button m_removeIncludeDirectoryButton;
    private PropertyTableViewer<TFile> m_directoryList;
    private final IProjectAnalyzerProvider m_analyzerProvider;
    private PropertyTableViewer<IncludeReference> m_unresolvedIncludesTable;
    private List<TFile> m_selection = null;

    public IncludeAnalyzerPage(String pageName, IProjectAnalyzerProvider provider) {
        super(pageName, "Handle Missing Include Directories");
        this.m_analyzerProvider = provider;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.SYSTEM_MISSING_INCLUDE_WIZARD_PAGE;
    }

    protected void createContent(Composite composite) {
        Label label1 = new Label(composite, 0);
        label1.setText("Potentially unresolved includes:");
        label1.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_unresolvedIncludesTable = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new IncludeReferenceBeanAdapter(), "includedName", true, PropertyTableViewer.SelectionType.SINGLE_FULL_LINE);
        GridData gridData1 = new GridData(4, 4, true, true, 2, 1);
        gridData1.minimumWidth = 300;
        gridData1.minimumHeight = 80;
        this.m_unresolvedIncludesTable.addColumn("Included From", "path", "path", null, 200, PropertyTableViewer.ColumnType.TEXT);
        this.m_unresolvedIncludesTable.addColumn("Included Name", "includedName", "includedName", null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_unresolvedIncludesTable.addColumn("Line", "lineNumber", "lineNumber", null, 50, PropertyTableViewer.ColumnType.NUMBER);
        this.m_unresolvedIncludesTable.setLayoutData((Object)gridData1);
        Label label2 = new Label(composite, 0);
        label2.setText("Added include directories:");
        label2.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
        this.m_directoryList = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new ExtraIncludeDirectoryBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_directoryList.addColumn("Path", "path", null, null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_directoryList.addColumn("Matches", "numberOfResolvedFiles", null, null, 50, PropertyTableViewer.ColumnType.NUMBER);
        GridData gridData2 = new GridData(4, 4, true, true, 2, 1);
        gridData2.minimumWidth = 300;
        gridData2.minimumHeight = 80;
        this.m_directoryList.setLayoutData((Object)gridData2);
        this.m_directoryList.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent evt) {
                IncludeAnalyzerPage.this.updateSelection();
            }
        });
        Button addButton = new Button(composite, 8);
        addButton.setText("Add Include Directory");
        addButton.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(IncludeAnalyzerPage.this.getShell(), 0);
                String path = directoryDialog.open();
                if (path != null) {
                    List unresolved = IncludeAnalyzerPage.this.m_analyzerProvider.getProjectAnalyzer().addExtraIncludeDirectory(new TFile(path));
                    IncludeAnalyzerPage.this.m_unresolvedIncludesTable.showData((Collection)unresolved);
                    IncludeAnalyzerPage.this.m_directoryList.showData((Collection)IncludeAnalyzerPage.this.m_analyzerProvider.getProjectAnalyzer().getExtraIncludeDirectories());
                    IncludeAnalyzerPage.this.updateSelection();
                }
            }
        });
        this.m_removeIncludeDirectoryButton = new Button(composite, 8);
        this.m_removeIncludeDirectoryButton.setText("Remove Include Directory");
        this.m_removeIncludeDirectoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (IncludeAnalyzerPage.this.m_selection != null) {
                    List unresolved = IncludeAnalyzerPage.this.m_analyzerProvider.getProjectAnalyzer().removeExtraIncludeDirectories(IncludeAnalyzerPage.this.m_selection);
                    IncludeAnalyzerPage.this.m_selection = null;
                    IncludeAnalyzerPage.this.m_unresolvedIncludesTable.showData((Collection)unresolved);
                    IncludeAnalyzerPage.this.m_directoryList.showData((Collection)IncludeAnalyzerPage.this.m_analyzerProvider.getProjectAnalyzer().getExtraIncludeDirectories());
                    IncludeAnalyzerPage.this.updateSelection();
                }
            }
        });
        this.m_removeIncludeDirectoryButton.setEnabled(false);
        this.m_removeIncludeDirectoryButton.setLayoutData((Object)new GridData(0, 0, false, false, 1, 1));
        this.setPageComplete(true);
    }

    private void updateSelection() {
        this.m_selection = this.m_directoryList.getSelected();
        if (this.m_selection.size() == 0) {
            this.m_selection = null;
        }
        this.m_removeIncludeDirectoryButton.setEnabled(this.m_selection != null);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IProjectAnalyzer analyzer = this.m_analyzerProvider.getProjectAnalyzer();
            this.m_unresolvedIncludesTable.showData((Collection)analyzer.getUnresolvedIncludes());
            this.m_directoryList.showData((Collection)this.m_analyzerProvider.getProjectAnalyzer().getExtraIncludeDirectories());
        }
    }

    private class ExtraIncludeDirectoryBeanAdapter
    extends BeanPropertyReader.BeanAdapter<TFile> {
        private TFile m_dir;

        private ExtraIncludeDirectoryBeanAdapter() {
        }

        protected void setAdaptedObject(TFile adaptedObject) {
            this.m_dir = adaptedObject;
        }

        public String getPath() {
            return this.m_dir.getAbsolutePath();
        }

        public Number getNumberOfResolvedFiles() {
            return IncludeAnalyzerPage.this.m_analyzerProvider.getProjectAnalyzer().getNumberOfResolvedFiles(this.m_dir);
        }
    }

    private static class IncludeReferenceBeanAdapter
    extends BeanPropertyReader.BeanAdapter<IncludeReference> {
        private IncludeReference m_reference;

        private IncludeReferenceBeanAdapter() {
        }

        protected void setAdaptedObject(IncludeReference adaptedObject) {
            this.m_reference = adaptedObject;
        }

        public String getPath() {
            return this.m_reference.getPath();
        }

        public String getIncludedName() {
            return this.m_reference.getIncludedName();
        }

        public Number getLineNumber() {
            return this.m_reference.getLineNo();
        }
    }
}

