/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.manual;

import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.activity.IWorkerContext;
import com.hello2morrow.sonargraph.foundation.file.FileUtility;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.SystemAndModuleCreationData;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IProjectAnalyzer;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ModuleInfo;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.SystemExtraInfo;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.FileExclusionPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.IProjectAnalyzerProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.IncludeAnalyzerPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.OptionDefinitionPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.manual.ScanSourcesForIncludesPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.CppImportWizard;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.Collections;
import java.util.List;

abstract class CPlusPlusManualWizard
extends CppImportWizard
implements IDirectoryBeanProvider,
IProjectAnalyzerProvider {
    private IProjectAnalyzer m_projectAnalyzer;
    private OptionDefinitionPage m_optionPage;
    private FileExclusionPage m_fileExclusionPage;

    protected CPlusPlusManualWizard(String title) {
        super(title);
    }

    protected ICPlusPlusInstallationProvider getInstallationProvider() {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        Installation installation = provider.getInstallation();
        return (ICPlusPlusInstallationProvider)installation.getExtension(ICPlusPlusInstallationProvider.class);
    }

    protected List<TFile> getSystemIncludeDirectories() {
        InstCompilerDefinition cdef = (InstCompilerDefinition)this.getInstallationProvider().listRelevantDefinitions(false).get(this.getCompilerDefinitionName());
        return cdef != null ? cdef.getIncludeDirectories() : Collections.emptyList();
    }

    protected abstract String getCompilerDefinitionName();

    /*
     * WARNING - void declaration
     */
    protected boolean collect(SystemAndModuleCreationData data) {
        SystemExtraInfo extraInfo = new SystemExtraInfo();
        String compilerDefName = this.getCompilerDefinitionName();
        if (compilerDefName == null) {
            compilerDefName = this.getModel().getName();
        } else {
            data.setSelectedCompilerDefinition(compilerDefName);
        }
        extraInfo.setCompilerDefinitionId(compilerDefName);
        for (TFile tFile : this.getProjectAnalyzer().getExtraIncludeDirectories()) {
            extraInfo.addOption("-I" + tFile.getPath());
        }
        for (String string : this.m_optionPage.getMacrosForModule(null)) {
            void var4_9;
            if (!string.startsWith("-D")) {
                String string2 = "-D" + string;
            }
            extraInfo.addOption((String)var4_9);
        }
        extraInfo.addExcludedFiles(this.m_fileExclusionPage.getExcludedFiles());
        data.setExtraSystemInfo(extraInfo);
        for (String string : this.getModuleToRootsMapper().getModuleNames()) {
            ModuleInfo modInfo = new ModuleInfo(string);
            modInfo.addRoots(this.getModuleToRootsMapper().getRootDirectoriesFor(string));
            for (String string3 : this.m_optionPage.getIncludeDirectoriesForModule(string)) {
                modInfo.addOption("-I" + string3);
            }
            for (String string4 : this.m_optionPage.getMacrosForModule(string)) {
                void var7_17;
                if (!string4.startsWith("-D")) {
                    String string5 = "-D" + string4;
                }
                modInfo.addOption((String)var7_17);
            }
            data.addModule(modInfo);
        }
        return true;
    }

    @Override
    public final TFile getFile() {
        return null;
    }

    @Override
    protected final IDirectoryBeanProvider getDirectoryBeanProvider() {
        return this;
    }

    @Override
    public final List<DirectoryBean> getRoots(OperationResult result) {
        return this.m_projectAnalyzer.getRoots();
    }

    protected abstract IProjectAnalyzer createProjectAnalyzer(IWorkerContext var1, ICppImportExtension var2, List<TFile> var3, List<TFile> var4);

    @Override
    public IProjectAnalyzer getProjectAnalyzer() {
        assert (this.m_projectAnalyzer != null);
        return this.m_projectAnalyzer;
    }

    @Override
    public boolean hasValidProjectAnalyzer() {
        if (this.m_projectAnalyzer == null) {
            return false;
        }
        TFile rootDir = this.getRootDirectory();
        List<TFile> systemIncludeDirectories = this.getSystemIncludeDirectories();
        List currentSystemIncludes = this.m_projectAnalyzer.getSystemIncludeDirectories();
        if (!FileUtility.areEqual((TFile)this.m_projectAnalyzer.getRootDir(), (TFile)rootDir)) {
            return false;
        }
        if (currentSystemIncludes.size() != systemIncludeDirectories.size()) {
            return false;
        }
        int i = 0;
        while (i < systemIncludeDirectories.size()) {
            if (!FileUtility.areEqual((TFile)systemIncludeDirectories.get(i), (TFile)((TFile)currentSystemIncludes.get(i)))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public final IProjectAnalyzer createProjectAnalyzer(IWorkerContext workerContext) {
        ISoftwareSystemProvider provider = WorkbenchRegistry.getInstance().getProvider();
        Installation installation = provider.getInstallation();
        List<TFile> systemIncludeDirectories = this.getSystemIncludeDirectories();
        List extraIncludeDirectories = Collections.emptyList();
        if (this.m_projectAnalyzer != null) {
            extraIncludeDirectories = this.m_projectAnalyzer.getExtraIncludeDirectories();
            this.m_projectAnalyzer = null;
        }
        if (this.m_projectAnalyzer == null && !systemIncludeDirectories.isEmpty()) {
            ICppImportExtension ext = (ICppImportExtension)installation.getExtension(ICppImportExtension.class);
            this.m_projectAnalyzer = this.createProjectAnalyzer(workerContext, ext, systemIncludeDirectories, extraIncludeDirectories);
        }
        return this.m_projectAnalyzer;
    }

    protected void addModuleDefinitionPages() {
        ScanSourcesForIncludesPage scanSourcesForIncludesPage = new ScanSourcesForIncludesPage("SCAN_PAGE", this);
        this.addPage((SonargraphWizardPage)scanSourcesForIncludesPage);
        IncludeAnalyzerPage incPage = new IncludeAnalyzerPage("INC_PAGE", this);
        this.addPage((SonargraphWizardPage)incPage);
        this.addSystemDefinitionPages();
        this.m_optionPage = new OptionDefinitionPage("OPT_PAGE", this.getModuleToRootsMapper(), this);
        this.addPage((SonargraphWizardPage)this.m_optionPage);
        this.m_fileExclusionPage = new FileExclusionPage("EXCLUSION_PAGE", this.getModuleToRootsMapper(), this);
        this.addPage((SonargraphWizardPage)this.m_fileExclusionPage);
    }
}

