/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateCompilerDefinitionCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.ActivationPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CPlusPlusCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerPropertiesPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.IncludePage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.OptionsPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.SelectCxxConfigFilePage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;

final class NewCPlusPlusCompilerDefinitionWizard
extends NonLazySonargraphWizard {
    private final CompilerDefinitionModel m_model = new CompilerDefinitionModel();
    private final ISoftwareSystemProvider m_softwareSystemProvider;

    NewCPlusPlusCompilerDefinitionWizard(ISoftwareSystemProvider provider) {
        super("Create New Compiler Definition");
        assert (provider != null) : "Parameter 'provider' of method 'NewCPlusPlusCompilerDefinitionWizard' must not be null";
        this.m_softwareSystemProvider = provider;
    }

    public void addPages() {
        Installation installation = this.m_softwareSystemProvider.getInstallation();
        this.addPage((SonargraphWizardPage)new SelectCxxConfigFilePage("PAGE_1", installation, this.m_model));
        this.addPage((SonargraphWizardPage)new CompilerPropertiesPage("PAGE_2", installation, this.m_model));
        this.addPage((SonargraphWizardPage)new CompilerCompatibilityPage("PAGE_3", this.m_model));
        this.addPage((SonargraphWizardPage)new CPlusPlusCompatibilityPage("PAGE_4", this.m_model));
        this.addPage((SonargraphWizardPage)new CCompatibilityPage("PAGE_5", this.m_model));
        this.addPage((SonargraphWizardPage)new IncludePage("CPP_INCUDES", "Define C++ specific implicit system include directories", this.m_model, this.m_model.getCppModel(), m -> !m.isAllowCpp()));
        this.addPage((SonargraphWizardPage)new OptionsPage("CPP_OPTION", "Define C++ specific options and predefined macros", this.m_model, this.m_model.getCppModel(), m -> !m.isAllowCpp()));
        this.addPage((SonargraphWizardPage)new IncludePage("C_INCLUDES", "Define C specific implicit system include directories", this.m_model, this.m_model.getcModel(), m -> m.isAllCpp() || !m.isAllowC()));
        this.addPage((SonargraphWizardPage)new OptionsPage("C_OPTION", "Define C specific options and predefined macros", this.m_model, this.m_model.getcModel(), m -> m.isAllCpp() || !m.isAllowC()));
        this.addPage((SonargraphWizardPage)new ActivationPage("ACTIVATION", this.m_model));
    }

    public boolean canFinish() {
        boolean canFinish = super.canFinish() && this.m_model.isComplete();
        return canFinish;
    }

    public boolean performFinish() {
        assert (this.m_model.isComplete()) : "compiler definition model is incomplete";
        CreateCompilerDefinitionCommand cmd = new CreateCompilerDefinitionCommand(this.m_softwareSystemProvider, (CreateCompilerDefinitionCommand.IInteraction)new Interaction());
        UserInterfaceAdapter.getInstance().run((Command)cmd);
        return true;
    }

    private class Interaction
    implements CreateCompilerDefinitionCommand.IInteraction {
        private Interaction() {
        }

        public void processOperationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public void collect(CreateCompilerDefinitionCommand.CreateCompilerDefinitionData data) {
            data.setModel(NewCPlusPlusCompilerDefinitionWizard.this.m_model);
        }
    }
}

