/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition;

import com.hello2morrow.sonargraph.foundation.propertyreader.BeanPropertyReader;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.IncludeAndOptionModel;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerDefinitionWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.IncludeDirectoryBeanAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.PropertyTableViewer;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;

public final class IncludePage
extends CompilerDefinitionWizardPage
implements SelectionListener {
    private static final String INCDIR = "INCDIR";
    private final IncludeAndOptionModel m_includeAndOptionModel;
    private final Predicate<CompilerDefinitionModel> m_skip;
    private PropertyTableViewer<String> m_includeDirectoryTable;
    private Button m_add;
    private Button m_delete;
    private Button m_edit;
    private Button m_up;
    private Button m_down;
    private List<String> m_current;

    public IncludePage(String pageName, String title, CompilerDefinitionModel model, IncludeAndOptionModel includeAndOptionModel, Predicate<CompilerDefinitionModel> skip) {
        super(pageName, title, model);
        assert (includeAndOptionModel != null) : "Parameter 'includeAndOptionModel' of method 'IncludeAndOptionPage' must not be null";
        assert (skip != null) : "Parameter 'skip' of method 'IncludeAndOptionPage' must not be null";
        this.m_includeAndOptionModel = includeAndOptionModel;
        this.m_skip = skip;
    }

    protected boolean skip() {
        return this.m_skip.test(this.m_model) || super.skip();
    }

    protected void createContent(Composite composite) {
        this.m_includeDirectoryTable = new PropertyTableViewer(composite, (BeanPropertyReader.BeanAdapter)new IncludeDirectoryBeanAdapter(), PropertyTableViewer.SelectionType.MULTI_FULL_LINE);
        this.m_includeDirectoryTable.addColumn("Path", "path", "path", null, 300, PropertyTableViewer.ColumnType.TEXT);
        this.m_includeDirectoryTable.addColumn("Status", "status", "status", null, 100, PropertyTableViewer.ColumnType.TEXT);
        this.m_includeDirectoryTable.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite buttonRow = new Composite(composite, 0);
        buttonRow.setLayoutData((Object)new GridData(1, 4, false, true));
        buttonRow.setLayout((Layout)SwtUtility.createMultipleRootWidgetGridLayout((int)1));
        this.m_add = new Button(buttonRow, 8);
        this.m_add.setImage(UiResourceManager.getInstance().getImage("New"));
        this.m_add.addSelectionListener((SelectionListener)this);
        this.m_delete = new Button(buttonRow, 8);
        this.m_delete.setImage(UiResourceManager.getInstance().getImage("Delete"));
        this.m_delete.addSelectionListener((SelectionListener)this);
        this.m_edit = new Button(buttonRow, 8);
        this.m_edit.setImage(UiResourceManager.getInstance().getImage("Edit"));
        this.m_edit.addSelectionListener((SelectionListener)this);
        this.m_up = new Button(buttonRow, 8);
        this.m_up.setImage(UiResourceManager.getInstance().getImage("ArrowUp"));
        this.m_up.addSelectionListener((SelectionListener)this);
        this.m_down = new Button(buttonRow, 8);
        this.m_down.setImage(UiResourceManager.getInstance().getImage("ArrowDown"));
        this.m_down.addSelectionListener((SelectionListener)this);
        this.m_add.setEnabled(true);
        this.m_delete.setEnabled(false);
        this.m_edit.setEnabled(false);
        this.m_up.setEnabled(false);
        this.m_down.setEnabled(false);
        this.m_includeDirectoryTable.getTableViewer().addSelectionChangedListener(event -> this.selectionChanged(event));
    }

    private String chooseDirectory(String initialDir) {
        String path;
        DirectoryDialog directoryDialog = new DirectoryDialog(this.getShell(), 0);
        if (initialDir != null) {
            directoryDialog.setFilterPath(initialDir);
        }
        if ((path = directoryDialog.open()) != null) {
            this.putPreference(INCDIR, path);
        }
        return path;
    }

    private void selectionChanged(SelectionChangedEvent event) {
        assert (event != null) : "Parameter 'event' of method 'selectionChanged' must not be null";
        List selected = this.m_includeDirectoryTable.getSelected();
        if (selected.size() == 0) {
            this.m_add.setEnabled(true);
            this.m_delete.setEnabled(false);
            this.m_edit.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        } else if (selected.size() == 1) {
            this.m_add.setEnabled(true);
            this.m_delete.setEnabled(true);
            this.m_edit.setEnabled(true);
            int pos = this.m_current.indexOf(selected.get(0));
            this.m_up.setEnabled(pos > 0);
            this.m_down.setEnabled(pos < this.m_current.size() - 1);
        } else {
            this.m_add.setEnabled(true);
            this.m_delete.setEnabled(true);
            this.m_edit.setEnabled(false);
            this.m_up.setEnabled(false);
            this.m_down.setEnabled(false);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_current = this.m_includeAndOptionModel.getSystemIncludes();
            this.applyModification(null);
        }
        super.setVisible(visible);
    }

    private void validate() {
        if (this.m_current.size() == 0) {
            this.setPageComplete(false);
        } else {
            this.setPageComplete(this.m_current.stream().map(path -> new TFile(path)).allMatch(dir -> dir.exists() && dir.isDirectory()));
        }
    }

    private void applyModification(String select) {
        this.m_includeDirectoryTable.showData(this.m_current);
        this.m_includeDirectoryTable.getTableViewer().setSelection((ISelection)(select == null ? new StructuredSelection() : new StructuredSelection((Object)select)));
        this.validate();
    }

    public void widgetSelected(SelectionEvent event) {
        assert (event != null) : "Parameter 'event' of method 'widgetSelected' must not be null";
        List selected = this.m_includeDirectoryTable.getSelected();
        Object source = event.getSource();
        if (source == this.m_add) {
            String path = this.chooseDirectory(this.getPreference(INCDIR));
            if (path != null) {
                this.m_current.add(path);
                this.applyModification(path);
            }
        } else if (source == this.m_edit) {
            String pathToEdit = (String)selected.get(0);
            int pos = this.m_current.indexOf(pathToEdit);
            TFile dir = new TFile(pathToEdit);
            String newPath = null;
            newPath = dir.exists() && dir.isDirectory() ? this.chooseDirectory(dir.getAbsolutePath()) : this.chooseDirectory(this.getPreference(INCDIR));
            if (newPath != null) {
                this.m_current.set(pos, newPath);
                this.applyModification(newPath);
            }
        } else if (source == this.m_delete) {
            this.m_current.removeAll(selected);
            this.applyModification(null);
        } else if (source == this.m_up) {
            String move = (String)selected.get(0);
            int pos = this.m_current.indexOf(move);
            String replaced = this.m_current.set(pos - 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else if (source == this.m_down) {
            String move = (String)selected.get(0);
            int pos = this.m_current.indexOf(move);
            String replaced = this.m_current.set(pos + 1, move);
            this.m_current.set(pos, replaced);
            this.applyModification(move);
        } else assert (false) : "Unhandled source: " + String.valueOf(source);
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

