/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.commandfile;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardFilePathValidator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.file.IFileType;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CommandFile;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public final class SelectCommandFilePage
extends StandardWizardPage
implements IDirectoryBeanProvider {
    private final IDirectoryProvider m_dirProvider;
    private final ICppImportExtension m_importer;
    private final IFileType m_fileType;
    private final String m_label;
    private TFile m_selectedFile;
    private final SoftwareSystem m_softwareSystem;
    private List<DirectoryBean> m_roots;
    private ValidatingPathWidget m_pathWidget;
    private Button m_readCommandFile;

    public SelectCommandFilePage(String pageName, String title, IFileType fileType, String label, IDirectoryProvider dirProvider, ICppImportExtension importer) {
        super(pageName, title);
        this.m_dirProvider = dirProvider;
        this.m_importer = importer;
        this.m_fileType = fileType;
        this.m_label = label;
        this.m_softwareSystem = null;
    }

    public SelectCommandFilePage(String pageName, String title, SoftwareSystem system, CommandFile file, String label, IDirectoryProvider dirProvider, ICppImportExtension importer) {
        super(pageName, title);
        this.m_dirProvider = dirProvider;
        this.m_importer = importer;
        this.m_fileType = file.getFileType();
        this.m_selectedFile = file.getFile();
        this.m_label = label;
        this.m_softwareSystem = system;
    }

    protected void createContent(Composite parent) {
        Label explanationLabel = new Label(parent, 64);
        explanationLabel.setText(this.m_label);
        explanationLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.m_pathWidget = new ValidatingPathWidget(parent, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    SelectCommandFilePage.this.m_selectedFile = input.getNormalizedFile();
                    SelectCommandFilePage.this.m_readCommandFile.setEnabled(SelectCommandFilePage.this.m_selectedFile.canRead());
                }
            }
        }, (IPathValidator)new StandardFilePathValidator(this.m_fileType), 5, null, false);
        this.m_pathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_readCommandFile = new Button(parent, 8);
        this.m_readCommandFile.setText("Read Command Data");
        this.m_readCommandFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCommandFilePage.this.readCommandFile();
            }
        });
        if (this.m_selectedFile != null) {
            this.m_pathWidget.setPath(this.m_selectedFile.getNormalizedAbsolutePath());
            this.m_readCommandFile.setEnabled(this.m_selectedFile.canRead());
        } else {
            this.m_readCommandFile.setEnabled(false);
        }
        this.setPageComplete(false);
    }

    private void readCommandFile() {
        OperationResult result = new OperationResult("Reading Command File");
        if (this.m_softwareSystem == null) {
            this.m_roots = this.m_importer.importCommandFile(this.m_selectedFile);
            if (this.m_roots == null) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "The selected files does not have the required structure", new Object[0]);
            }
        } else {
            this.m_roots = this.m_importer.readCommandFileForSystem(this.m_softwareSystem, this.m_selectedFile, result);
        }
        if (this.m_roots != null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_pathWidget.setBasePath(this.m_dirProvider.getDirectory());
        }
        super.setVisible(visible);
    }

    @Override
    public TFile getFile() {
        return this.m_selectedFile;
    }

    @Override
    public List<DirectoryBean> getRoots(OperationResult result) {
        return this.m_roots;
    }
}

