/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.commandfile;

import com.hello2morrow.sonargraph.core.foundation.common.base.IPathValidator;
import com.hello2morrow.sonargraph.core.foundation.common.base.StandardDirectoryValidator;
import com.hello2morrow.sonargraph.core.model.system.SoftwareSystem;
import com.hello2morrow.sonargraph.foundation.utilities.IOMessageCause;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICppImportExtension;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.IDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.swt.base.ValidatingPathWidget;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class SelectCCSpyDirectoryPage
extends StandardWizardPage
implements IDirectoryBeanProvider {
    private final IDirectoryProvider m_dirProvider;
    private final ICppImportExtension m_importer;
    private TFile m_selectedDir;
    private final SoftwareSystem m_softwareSystem;
    private List<DirectoryBean> m_roots;
    private ValidatingPathWidget m_pathWidget;
    private Button m_readCCSpyDir;

    public SelectCCSpyDirectoryPage(String pageName, IDirectoryProvider dirProvider, ICppImportExtension importer) {
        super(pageName, "Select ccspy output directory");
        this.m_dirProvider = dirProvider;
        this.m_importer = importer;
        this.m_softwareSystem = null;
    }

    protected void createContent(Composite parent) {
        Label explanationLabel = new Label(parent, 64);
        explanationLabel.setText("Please build your system with ccspy as capturing tool (see documentation).\n\nccspy output directory:");
        explanationLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.m_pathWidget = new ValidatingPathWidget(parent, new ValidatingPathWidget.IConsumer(){

            public void setPath(TFile input, boolean inputModified) {
                if (input != null) {
                    SelectCCSpyDirectoryPage.this.m_selectedDir = input.getNormalizedFile();
                    SelectCCSpyDirectoryPage.this.m_readCCSpyDir.setEnabled(true);
                }
            }
        }, (IPathValidator)new StandardDirectoryValidator(StandardDirectoryValidator.Permission.READ), 5, null, false);
        this.m_pathWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.m_readCCSpyDir = new Button(parent, 8);
        this.m_readCCSpyDir.setText("Read CCSpy Directory");
        this.m_readCCSpyDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectCCSpyDirectoryPage.this.readCommandFile();
            }
        });
        if (this.m_selectedDir != null) {
            this.m_pathWidget.setPath(this.m_selectedDir.getNormalizedAbsolutePath());
            this.m_readCCSpyDir.setEnabled(true);
        } else {
            this.m_readCCSpyDir.setEnabled(false);
        }
        this.setPageComplete(false);
    }

    private void readCommandFile() {
        OperationResult result = new OperationResult("Reading ccspy directory");
        if (this.m_softwareSystem == null) {
            this.m_roots = this.m_importer.readCCSpyDirectory(this.m_selectedDir, true);
            if (this.m_roots == null) {
                result.addError((OperationResult.IMessageCause)IOMessageCause.WRONG_FORMAT, "The selected directory does not have the required content", new Object[0]);
            }
        }
        if (this.m_roots != null) {
            this.setPageComplete(true);
        } else {
            this.setPageComplete(false);
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.m_pathWidget.setBasePath(this.m_dirProvider.getDirectory());
        }
        super.setVisible(visible);
    }

    @Override
    public TFile getFile() {
        return this.m_selectedDir;
    }

    @Override
    public List<DirectoryBean> getRoots(OperationResult result) {
        return this.m_roots;
    }
}

