/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.foundation.common.base.ValidationResult;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsCallback;
import com.hello2morrow.sonargraph.foundation.common.StandaloneResourceProviderAdapter;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinition;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.InstCompilerDefinitionDelta;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.ValidatingTabItemWidget;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences.DefinitionTabItem;
import com.hello2morrow.sonargraph.ui.swt.base.SwtUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.Text;

class HeaderItem
extends DefinitionTabItem<InstCompilerDefinition> {
    private Text m_textDescription;
    private Combo m_comboLongSize;
    private Combo m_comboPointerSize;
    private SelectionAdapter m_pointerSelectionAdapter;
    private SelectionAdapter m_longSelectionAdapter;
    private ModifyListener m_modifyListener;

    public HeaderItem(TabFolder parent, ISettingsCallback callback) {
        super("General", parent, new DefinitionHeaderValidator(), null, callback);
    }

    public Composite createTabItemContent(TabFolder folder) {
        Composite container = super.createContainer(folder, 3);
        SwtUtility.createOneCellLabel((Composite)container, (String)StandaloneResourceProviderAdapter.getInstance().getString("standalone.label.description", new Object[0]), (int)131072);
        this.m_textDescription = SwtUtility.createTextFieldForGridLayout((Composite)container, (boolean)false, (int)0);
        GridData gridData = new GridData(4, 1, true, false, 2, 1);
        this.m_textDescription.setLayoutData((Object)gridData);
        this.m_modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                HeaderItem.this.getDelta().getModified().setDescription(((Text)event.getSource()).getText());
                HeaderItem.this.notifyChanges();
            }
        };
        SwtUtility.createOneCellLabel((Composite)container, (String)"Long size", (int)131072);
        this.m_comboLongSize = new Combo(container, 12);
        this.m_comboLongSize.add("4");
        this.m_comboLongSize.add("8");
        SwtUtility.createOneCellLabel((Composite)container, (String)"Bytes", (int)16384);
        this.m_longSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String longValue = ((Combo)e.getSource()).getText();
                HeaderItem.this.getDelta().getModified().setLongSize(Integer.parseInt(longValue));
                HeaderItem.this.notifyChanges();
            }
        };
        SwtUtility.createOneCellLabel((Composite)container, (String)"Pointer size", (int)131072);
        this.m_comboPointerSize = new Combo(container, 12);
        this.m_comboPointerSize.add("4");
        this.m_comboPointerSize.add("8");
        SwtUtility.createOneCellLabel((Composite)container, (String)"Bytes", (int)16384);
        this.m_pointerSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String pointerValue = ((Combo)e.getSource()).getText();
                HeaderItem.this.getDelta().getModified().setPointerSize(Integer.parseInt(pointerValue));
                HeaderItem.this.notifyChanges();
            }
        };
        this.addListeners();
        return container;
    }

    @Override
    public void clearWidgets() {
        this.m_textDescription.setText("");
        SwtUtility.selectElementOfCombo((Combo)this.m_comboPointerSize, (String)"4");
        SwtUtility.selectElementOfCombo((Combo)this.m_comboPointerSize, (String)"8");
    }

    @Override
    protected void applyDeltaToWidgets(InstCompilerDefinitionDelta delta) {
        this.m_textDescription.setText(delta.getModified().getDescription());
        SwtUtility.selectElementOfCombo((Combo)this.m_comboLongSize, (String)Integer.toString(delta.getModified().getLongSize()));
        SwtUtility.selectElementOfCombo((Combo)this.m_comboPointerSize, (String)Integer.toString(delta.getModified().getPointerSize()));
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        this.m_textDescription.setEditable(isEnabled);
        this.m_comboLongSize.setEnabled(isEnabled);
        this.m_comboPointerSize.setEnabled(isEnabled);
    }

    @Override
    public void removeListeners() {
        if (!this.m_comboLongSize.isDisposed()) {
            this.m_comboLongSize.removeSelectionListener((SelectionListener)this.m_longSelectionAdapter);
        }
        if (!this.m_comboPointerSize.isDisposed()) {
            this.m_comboPointerSize.removeSelectionListener((SelectionListener)this.m_pointerSelectionAdapter);
        }
        if (!this.m_textDescription.isDisposed()) {
            this.m_textDescription.removeModifyListener(this.m_modifyListener);
        }
    }

    @Override
    public void addListeners() {
        this.m_textDescription.addModifyListener(this.m_modifyListener);
        this.m_comboLongSize.addSelectionListener((SelectionListener)this.m_longSelectionAdapter);
        this.m_comboPointerSize.addSelectionListener((SelectionListener)this.m_pointerSelectionAdapter);
    }

    private static class DefinitionHeaderValidator
    implements ValidatingTabItemWidget.IValidator<InstCompilerDefinition> {
        private DefinitionHeaderValidator() {
        }

        public ValidationResult validate(InstCompilerDefinition objectToValidate) {
            return null;
        }
    }
}

