/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.cplusplus.pages.preferences;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.core.model.system.settings.ISettingsDelta;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.settings.ConfigureParserDaemonsCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.system.ICPlusPlusParserConfigurationProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.preferencepage.StandardPreferencePage;
import com.hello2morrow.sonargraph.ui.standalone.settings.IntegerConfigurationEntryWidget;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class CppParserDaemonConfigurationPage
extends StandardPreferencePage {
    private final ICPlusPlusParserConfigurationProvider m_configurationProvider;
    private IntegerConfigurationEntryWidget m_numberOfDaemonsWidget;
    private IntegerConfigurationEntryWidget m_daemonStackSizeWidget;
    private int m_numberOfDaemons;
    private int m_daemonStackSize;

    public CppParserDaemonConfigurationPage() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        this.m_configurationProvider = (ICPlusPlusParserConfigurationProvider)installation.getExtension(ICPlusPlusParserConfigurationProvider.class);
        this.m_daemonStackSize = this.m_configurationProvider.getDaemonStackSize();
        this.m_numberOfDaemons = this.m_configurationProvider.getNumberOfDaemons();
    }

    protected Composite createPageContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 7;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginBottom = 5;
        gridLayout.marginTop = 5;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 5;
        composite.setLayout((Layout)gridLayout);
        ValueListener listener = new ValueListener();
        this.m_numberOfDaemonsWidget = new IntegerConfigurationEntryWidget(composite, this.m_configurationProvider.getNumberOfDaemonsDescriptor(), this.m_configurationProvider.getNumberOfDaemons(), (IntegerConfigurationEntryWidget.IValueListener)listener);
        this.m_numberOfDaemonsWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.m_daemonStackSizeWidget = new IntegerConfigurationEntryWidget(composite, this.m_configurationProvider.getDaemonStackSizeDescriptor(), this.m_configurationProvider.getDaemonStackSize(), (IntegerConfigurationEntryWidget.IValueListener)listener);
        this.m_daemonStackSizeWidget.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        return composite;
    }

    protected void performDefaults() {
        this.m_daemonStackSize = this.m_configurationProvider.getDaemonStackSizeDescriptor().getDefaultValue();
        this.m_daemonStackSizeWidget.setValue(this.m_daemonStackSize);
        this.m_numberOfDaemons = this.m_configurationProvider.getNumberOfDaemonsDescriptor().getDefaultValue();
        this.m_numberOfDaemonsWidget.setValue(this.m_numberOfDaemons);
        super.performDefaults();
    }

    protected ISettingsDelta getDelta() {
        return new Delta();
    }

    protected OperationResult getOperationResult() {
        return null;
    }

    protected void internPerformOk() {
        if (this.getDelta().isModified()) {
            ConfigureParserDaemonsCommand cmd = new ConfigureParserDaemonsCommand(WorkbenchRegistry.getInstance().getProvider(), (ConfigureParserDaemonsCommand.IInteraction)new Interaction());
            UserInterfaceAdapter.getInstance().runWaitingForCompletion((Command)cmd);
        }
    }

    protected void cancel() {
    }

    private class Delta
    implements ISettingsDelta {
        private Delta() {
        }

        public boolean isModified() {
            return CppParserDaemonConfigurationPage.this.m_daemonStackSize != CppParserDaemonConfigurationPage.this.m_configurationProvider.getDaemonStackSize() || CppParserDaemonConfigurationPage.this.m_numberOfDaemons != CppParserDaemonConfigurationPage.this.m_configurationProvider.getNumberOfDaemons();
        }

        public void reset() {
            CppParserDaemonConfigurationPage.this.m_daemonStackSize = CppParserDaemonConfigurationPage.this.m_configurationProvider.getDaemonStackSize();
            CppParserDaemonConfigurationPage.this.m_daemonStackSizeWidget.setValue(CppParserDaemonConfigurationPage.this.m_daemonStackSize);
            CppParserDaemonConfigurationPage.this.m_numberOfDaemons = CppParserDaemonConfigurationPage.this.m_configurationProvider.getNumberOfDaemons();
            CppParserDaemonConfigurationPage.this.m_numberOfDaemonsWidget.setValue(CppParserDaemonConfigurationPage.this.m_numberOfDaemons);
        }

        public void dispose() {
        }
    }

    private class Interaction
    implements ConfigureParserDaemonsCommand.IInteraction {
        private Interaction() {
        }

        public boolean collect(ConfigureParserDaemonsCommand.InteractionData data) {
            data.setNumberOfDaemons(CppParserDaemonConfigurationPage.this.m_numberOfDaemons);
            data.setDaemonStackSize(CppParserDaemonConfigurationPage.this.m_daemonStackSize);
            return true;
        }

        public void processResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }
    }

    private class ValueListener
    implements IntegerConfigurationEntryWidget.IValueListener {
        private ValueListener() {
        }

        public void valueChanged(IntegerConfigurationEntryWidget source, int value) {
            if (source == CppParserDaemonConfigurationPage.this.m_numberOfDaemonsWidget) {
                CppParserDaemonConfigurationPage.this.m_numberOfDaemons = value;
            } else {
                CppParserDaemonConfigurationPage.this.m_daemonStackSize = value;
            }
        }
    }
}

