/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.shared;

import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.DirectoryBean;
import com.hello2morrow.sonargraph.ui.standalone.cplusplus.CPlusPlusDialogId;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ICommandDataProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.swt.base.UiResourceManager;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.StandardWizardPage;
import com.hello2morrow.sonargraph.ui.swt.common.IDialogId;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public final class SelectRootAndExcludedDirectoriesPage
extends StandardWizardPage
implements ICommandDataProvider {
    private final IDirectoryBeanProvider m_directoryBeanProvider;
    private TreeViewer m_treeViewer;
    private DirectoryBean m_rootBean;
    private DirectoryBean m_selection;
    private Button m_markRoot;
    private Button m_markExcluded;
    private Button m_unmark;
    private final List<DirectoryBean> m_rootDirectories = new ArrayList<DirectoryBean>();

    public SelectRootAndExcludedDirectoriesPage(String pageName, String title, IDirectoryBeanProvider dataProvider) {
        super(pageName, title);
        this.m_directoryBeanProvider = dataProvider;
    }

    protected IDialogId getDialogId() {
        return CPlusPlusDialogId.SELECT_ROOT_DIRECTORIES_WIZARD_PAGE;
    }

    protected int getNumberOfColumns() {
        return 3;
    }

    protected void createContent(Composite composite) {
        this.m_treeViewer = new TreeViewer(composite, 67588);
        this.m_treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.m_treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                DirectoryBean dir = (DirectoryBean)element;
                String imageName = dir.isExcluded() ? "RedDirectoryPath" : (dir.isRoot() ? "BlueDirectoryPath" : "DirectoryPath");
                return UiResourceManager.getInstance().getImage(imageName);
            }

            public String getText(Object element) {
                DirectoryBean dir = (DirectoryBean)element;
                if (dir.getParent() == SelectRootAndExcludedDirectoriesPage.this.m_rootBean) {
                    return dir.getDirectory().getPath();
                }
                return dir.getDirectory().getName();
            }
        });
        this.m_treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                List dirs = ((DirectoryBean)parentElement).getSubDirectories();
                return dirs.toArray();
            }

            public Object getParent(Object element) {
                return ((DirectoryBean)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return ((DirectoryBean)element).hasSubDirectories();
            }
        });
        this.m_treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                SelectRootAndExcludedDirectoriesPage.this.selectionChanged((DirectoryBean)thisSelection.getFirstElement());
            }
        });
        this.m_treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection thisSelection = (IStructuredSelection)event.getSelection();
                Object selectedNode = thisSelection.getFirstElement();
                SelectRootAndExcludedDirectoriesPage.this.m_treeViewer.setExpandedState(selectedNode, !SelectRootAndExcludedDirectoriesPage.this.m_treeViewer.getExpandedState(selectedNode));
            }
        });
        this.m_markRoot = new Button(composite, 8);
        this.m_markRoot.setText("&Mark as Root Directory");
        this.m_markRoot.setEnabled(false);
        this.m_markRoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootAndExcludedDirectoriesPage.this.m_selection.setRoot(true);
                SelectRootAndExcludedDirectoriesPage.this.m_markRoot.setEnabled(false);
                SelectRootAndExcludedDirectoriesPage.this.m_unmark.setEnabled(true);
                SelectRootAndExcludedDirectoriesPage.this.m_rootDirectories.add(SelectRootAndExcludedDirectoriesPage.this.m_selection);
                SelectRootAndExcludedDirectoriesPage.this.setPageComplete(true);
                SelectRootAndExcludedDirectoriesPage.this.m_treeViewer.refresh();
            }
        });
        this.m_markExcluded = new Button(composite, 8);
        this.m_markExcluded.setText("Mark as E&xcluded");
        this.m_markExcluded.setEnabled(false);
        this.m_markExcluded.setToolTipText("You can exclude sub-directories of a\nroot from being included in the project");
        this.m_markExcluded.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootAndExcludedDirectoriesPage.this.m_selection.setExcluded(true);
                SelectRootAndExcludedDirectoriesPage.this.m_markExcluded.setEnabled(false);
                SelectRootAndExcludedDirectoriesPage.this.m_unmark.setEnabled(true);
                SelectRootAndExcludedDirectoriesPage.this.m_treeViewer.refresh();
            }
        });
        this.m_unmark = new Button(composite, 8);
        this.m_unmark.setText("&Unmark");
        this.m_unmark.setEnabled(false);
        this.m_unmark.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectRootAndExcludedDirectoriesPage.this.m_selection.setRoot(false);
                SelectRootAndExcludedDirectoriesPage.this.m_rootDirectories.remove(SelectRootAndExcludedDirectoriesPage.this.m_selection);
                if (SelectRootAndExcludedDirectoriesPage.this.m_rootDirectories.isEmpty()) {
                    SelectRootAndExcludedDirectoriesPage.this.setPageComplete(false);
                }
                SelectRootAndExcludedDirectoriesPage.this.m_selection.setExcluded(false);
                SelectRootAndExcludedDirectoriesPage.this.m_treeViewer.refresh();
                SelectRootAndExcludedDirectoriesPage.this.m_unmark.setEnabled(false);
                SelectRootAndExcludedDirectoriesPage.this.m_markRoot.setEnabled(SelectRootAndExcludedDirectoriesPage.this.m_selection.canBeRoot());
                SelectRootAndExcludedDirectoriesPage.this.m_markExcluded.setEnabled(SelectRootAndExcludedDirectoriesPage.this.m_selection.canBeExcluded());
            }
        });
        this.setPageComplete(false);
    }

    private void selectionChanged(DirectoryBean newSelection) {
        this.m_selection = newSelection;
        if (this.m_selection == null) {
            this.m_unmark.setEnabled(false);
            this.m_markRoot.setEnabled(false);
            this.m_markExcluded.setEnabled(false);
        } else {
            this.m_unmark.setEnabled(this.m_selection.isExcludedRoot() || this.m_selection.isRoot());
            this.m_markRoot.setEnabled(this.m_selection.canBeRoot());
            this.m_markExcluded.setEnabled(this.m_selection.canBeExcluded());
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.m_rootBean == null) {
                OperationResult result = new OperationResult("Scanning project");
                this.m_rootBean = new DirectoryBean(null, null);
                for (DirectoryBean dir : this.m_directoryBeanProvider.getRoots(result)) {
                    this.m_rootBean.addSubDirectory(dir);
                }
                if (result.isFailure()) {
                    this.setErrorMessage((String)result.getErrorMessages().get(0));
                } else {
                    this.setErrorMessage(null);
                }
            }
            this.m_treeViewer.setInput((Object)this.m_rootBean);
        } else {
            this.m_treeViewer.setInput(null);
        }
        super.setVisible(visible);
    }

    @Override
    public List<DirectoryBean> getRootDirectoriesForModules() {
        return this.m_rootDirectories;
    }
}

