/*
 * Decompiled with CFR 0.152.
 */
package com.hello2morrow.sonargraph.ui.standalone.wizard.shared;

import com.hello2morrow.sonargraph.core.command.common.Command;
import com.hello2morrow.sonargraph.core.command.system.CreateSoftwareSystemCommand;
import com.hello2morrow.sonargraph.core.command.system.ImportQualityModelCommand;
import com.hello2morrow.sonargraph.core.foundation.common.base.Language;
import com.hello2morrow.sonargraph.core.model.path.ResolvedQualityModelDescriptorFile;
import com.hello2morrow.sonargraph.core.model.system.ISoftwareSystemProvider;
import com.hello2morrow.sonargraph.core.model.system.Installation;
import com.hello2morrow.sonargraph.foundation.utilities.OperationResult;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateCompilerDefinitionCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.command.system.CreateNewSystemFromCompileCommandsCommand;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.foundation.common.CPlusPlusLanguage;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.CompilerDefinitionModel;
import com.hello2morrow.sonargraph.languageprovider.cplusplus.model.settings.ICPlusPlusInstallationProvider;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.QualityModelLoader;
import com.hello2morrow.sonargraph.ui.standalone.base.dialog.SystemDirectoryWizardPage;
import com.hello2morrow.sonargraph.ui.standalone.softwaresystemview.CreateSystemCommandInteraction;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CPlusPlusCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerCompatibilityPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.CompilerPropertiesPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.IncludePage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.OptionsPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.compilerdefinition.SelectCxxConfigFilePage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.CompilerSelectionPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ICommandDataProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ICompilerSelectionProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IDirectoryBeanProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.IModuleToRootsMapper;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ISoftwareSystemDirectoryProvider;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.ModuleAssignmentPage;
import com.hello2morrow.sonargraph.ui.standalone.wizard.shared.SelectRootAndExcludedDirectoriesPage;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.NonLazySonargraphWizard;
import com.hello2morrow.sonargraph.ui.swt.base.wizard.SonargraphWizardPage;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.UserInterfaceAdapter;
import com.hello2morrow.sonargraph.ui.swt.base.workbench.WorkbenchRegistry;
import de.schlichtherle.truezip.file.TFile;
import java.util.List;

public abstract class CppImportWizard
extends NonLazySonargraphWizard
implements ICompilerSelectionProvider,
ISoftwareSystemDirectoryProvider {
    private final CompilerDefinitionModel m_model = new CompilerDefinitionModel();
    private String m_selectedCompilerDefinition = null;
    private SystemDirectoryWizardPage m_basicDataPage;
    private SelectRootAndExcludedDirectoriesPage m_rootSelectionPage;
    private ModuleAssignmentPage m_moduleAssignmentPage;

    protected CppImportWizard(String title) {
        super(title);
    }

    protected abstract IDirectoryBeanProvider getDirectoryBeanProvider();

    protected final ICommandDataProvider getCommandDataProvider() {
        return this.m_rootSelectionPage;
    }

    protected SystemDirectoryWizardPage getBasicDataPage() {
        return this.m_basicDataPage;
    }

    protected IModuleToRootsMapper getModuleToRootsMapper() {
        return this.m_moduleAssignmentPage;
    }

    protected void addCompilerDefinitionPages() {
        Installation installation = WorkbenchRegistry.getInstance().getProvider().getInstallation();
        ICPlusPlusInstallationProvider cppInst = (ICPlusPlusInstallationProvider)installation.getExtension(ICPlusPlusInstallationProvider.class);
        this.addPage((SonargraphWizardPage)new CompilerSelectionPage("COMPILER_SELECTION", cppInst, this));
        this.addPage(new SelectCxxConfigFilePage("CXX_IMPORT", installation, this.m_model).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new CompilerPropertiesPage("COMP_PROPS", installation, this.m_model).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new CompilerCompatibilityPage("COMP_COMPAT", this.m_model).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new CPlusPlusCompatibilityPage("CPP_COMPAT", this.m_model).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new CCompatibilityPage("C_COMPAT", this.m_model).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new IncludePage("CPP_INCUDES", "Define C++ specific implicit system include directories", this.m_model, this.m_model.getCppModel(), m -> !m.isAllowCpp()).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new OptionsPage("CPP_OPTION", "Define C++ specific options and predefined macros", this.m_model, this.m_model.getCppModel(), m -> !m.isAllowCpp()).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new IncludePage("C_INCLUDES", "Define C specific implicit system include directories", this.m_model, this.m_model.getcModel(), m -> m.isAllCpp() || !m.isAllowC()).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
        this.addPage(new OptionsPage("C_OPTION", "Define C specific options and predefined macros", this.m_model, this.m_model.getcModel(), m -> m.isAllCpp() || !m.isAllowC()).setSkipPredicate(() -> this.m_selectedCompilerDefinition != null));
    }

    protected void addBasicDataPage() {
        List fileDescriptors = CreateSoftwareSystemCommand.getQualityModelFileDescriptors((ISoftwareSystemProvider)WorkbenchRegistry.getInstance().getProvider());
        List resolvedDescriptors = QualityModelLoader.loadQualityModelFiles((List)fileDescriptors);
        int defaultIndex = 0;
        int i = 0;
        while (i < resolvedDescriptors.size()) {
            Language qualityModelLanguage = ((ResolvedQualityModelDescriptorFile)resolvedDescriptors.get(i)).getQualityModelFileDescriptor().getLanguage();
            if (qualityModelLanguage != null && qualityModelLanguage.equals((Object)CPlusPlusLanguage.INSTANCE)) {
                defaultIndex = i;
                break;
            }
            ++i;
        }
        ISoftwareSystemProvider softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider();
        this.m_basicDataPage = new SystemDirectoryWizardPage("PAGE_1", "Specify the name, description and location of the new system", "Name:", "Directory:", "Use predefined quality model", CreateSoftwareSystemCommand.getNameValidator((ISoftwareSystemProvider)softwareSystemProvider), CreateSoftwareSystemCommand.getBaseDirectoryValidator((ISoftwareSystemProvider)softwareSystemProvider), ImportQualityModelCommand.getImportQualityModelValidator((ISoftwareSystemProvider)softwareSystemProvider), resolvedDescriptors, defaultIndex, "", "");
        this.addPage((SonargraphWizardPage)this.m_basicDataPage);
    }

    protected void addSystemDefinitionPages() {
        this.m_rootSelectionPage = new SelectRootAndExcludedDirectoriesPage("PAGE_3", "Select the root directories that will be assigned to modules in the next step.", this.getDirectoryBeanProvider());
        this.m_moduleAssignmentPage = new ModuleAssignmentPage("PAGE_4", "For each root directory enter the name of the associated module.", this.m_rootSelectionPage);
        this.addPage((SonargraphWizardPage)this.m_rootSelectionPage);
        this.addPage((SonargraphWizardPage)this.m_moduleAssignmentPage);
    }

    @Override
    public void selectCompiler(String compilerDefinitionName) {
        this.m_selectedCompilerDefinition = compilerDefinitionName;
    }

    protected final ModuleAssignmentPage getModuleAssignmentPage() {
        return this.m_moduleAssignmentPage;
    }

    protected final String getSelectedCompilerDefinition() {
        return this.m_selectedCompilerDefinition;
    }

    protected final CompilerDefinitionModel getModel() {
        return this.m_model;
    }

    @Override
    public TFile getSoftwareSystemDirectory() {
        if (this.m_basicDataPage != null) {
            return this.m_basicDataPage.getDirectory();
        }
        return null;
    }

    protected Command createCommand(ISoftwareSystemProvider provider) {
        return new CreateNewSystemFromCompileCommandsCommand(provider, (CreateNewSystemFromCompileCommandsCommand.IInteraction)new Interaction(this.m_basicDataPage));
    }

    public final boolean performFinish() {
        ISoftwareSystemProvider softwareSystemProvider;
        Command cmd;
        if (this.canFinish() && (cmd = this.createCommand(softwareSystemProvider = WorkbenchRegistry.getInstance().getProvider())) != null) {
            UserInterfaceAdapter.getInstance().run(cmd);
            return true;
        }
        return false;
    }

    protected class Interaction
    extends CreateSystemCommandInteraction
    implements CreateNewSystemFromCompileCommandsCommand.IInteraction {
        public Interaction(SystemDirectoryWizardPage basicDataPage) {
            super(basicDataPage);
        }

        public boolean collect(CreateNewSystemFromCompileCommandsCommand.ImportData data) {
            assert (data != null) : "Parameter 'data' of method 'collect' must not be null";
            for (String module : CppImportWizard.this.m_moduleAssignmentPage.getModuleNames()) {
                data.addModule(module, CppImportWizard.this.m_moduleAssignmentPage.getRootDirectoriesFor(module));
            }
            TFile commandFileOrCCSpyDir = CppImportWizard.this.getDirectoryBeanProvider().getFile();
            if (commandFileOrCCSpyDir.isDirectory()) {
                data.setCCSpyDirectory(commandFileOrCCSpyDir);
            } else {
                data.setCommandFile(CppImportWizard.this.getDirectoryBeanProvider().getFile());
            }
            if (CppImportWizard.this.getSelectedCompilerDefinition() != null) {
                data.setSelectedCompilerDefinition(CppImportWizard.this.getSelectedCompilerDefinition());
            }
            return true;
        }

        public void processModuleCreationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public void processOperationResult(OperationResult result) {
            UserInterfaceAdapter.getInstance().process(result);
        }

        public void collect(CreateCompilerDefinitionCommand.CreateCompilerDefinitionData data) {
            if (CppImportWizard.this.getSelectedCompilerDefinition() == null) {
                data.setModel(CppImportWizard.this.getModel());
            }
        }
    }
}

